/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.screen;

import ballistix.common.inventory.container.ContainerVLS;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.TileVerticalLaunchSilo;
import ballistix.prefab.utils.BallistixTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenVLS
extends GenericScreen<ContainerVLS> {
    private boolean needsUpdate = true;
    private final ScreenComponentEditBox xCoordField;
    private final ScreenComponentEditBox yCoordField;
    private final ScreenComponentEditBox zCoordField;
    private final ScreenComponentEditBox frequencyField;

    public ScreenVLS(ContainerVLS container, Inventory inv, Component title) {
        super((GenericContainer)container, inv, title);
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2).wattage(BallistixConstants.MISSILESILO_USAGE * 20.0));
        this.xCoordField = new ScreenComponentEditBox(10, 17, 48, 15, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(10).setResponder(this::setX).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.xCoordField);
        this.yCoordField = new ScreenComponentEditBox(10, 35, 48, 15, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(10).setResponder(this::setY).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.yCoordField);
        this.zCoordField = new ScreenComponentEditBox(10, 53, 48, 15, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(10).setResponder(this::setZ).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.zCoordField);
        this.frequencyField = new ScreenComponentEditBox(80, 17, 48, 15, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(10).setResponder(this::setFrequency).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.frequencyField);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(60, 19, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("missilesilo.x", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(60, 37, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("missilesilo.y", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(60, 55, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("missilesilo.z", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(130, 19, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("missilesilo.freq", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(101, 39, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("missilesilo.sync", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(130, 32, 20, 20).setOnPress(button -> {
            TileVerticalLaunchSilo silo = (TileVerticalLaunchSilo)((ContainerVLS)this.m_6262_()).getSafeHost();
            if (silo == null) {
                return;
            }
            silo.shouldLaunch.setValue((Object)true);
        }).setColor(new Color(255, 0, 0, 255)).onTooltip((graphics, component, mouseX, mouseY) -> graphics.m_280557_(this.getFontRenderer(), (Component)BallistixTextUtils.tooltip("silo.launch", new Object[0]), mouseX, mouseY)));
    }

    protected void initializeComponents() {
        super.initializeComponents();
    }

    private void setSiloTargetX(String coord) {
        if (coord.isEmpty()) {
            return;
        }
        TileVerticalLaunchSilo silo = (TileVerticalLaunchSilo)((ContainerVLS)this.f_97732_).getSafeHost();
        if (silo == null) {
            return;
        }
        int x = ((BlockPos)silo.target.getValue()).m_123341_();
        try {
            x = Integer.parseInt(coord);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ScreenVLS.updateSiloCoords(x, ((BlockPos)silo.target.getValue()).m_123342_(), ((BlockPos)silo.target.getValue()).m_123343_(), silo);
    }

    private void setSiloTargetY(String coord) {
        if (coord.isEmpty()) {
            return;
        }
        TileVerticalLaunchSilo silo = (TileVerticalLaunchSilo)((ContainerVLS)this.f_97732_).getSafeHost();
        if (silo == null) {
            return;
        }
        int y = ((BlockPos)silo.target.getValue()).m_123342_();
        try {
            y = Integer.parseInt(coord);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ScreenVLS.updateSiloCoords(((BlockPos)silo.target.getValue()).m_123341_(), y, ((BlockPos)silo.target.getValue()).m_123343_(), silo);
    }

    private void setSiloTargetZ(String coord) {
        if (coord.isEmpty()) {
            return;
        }
        TileVerticalLaunchSilo silo = (TileVerticalLaunchSilo)((ContainerVLS)this.f_97732_).getSafeHost();
        if (silo == null) {
            return;
        }
        int z = ((BlockPos)silo.target.getValue()).m_123343_();
        try {
            z = Integer.parseInt(coord);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ScreenVLS.updateSiloCoords(((BlockPos)silo.target.getValue()).m_123341_(), ((BlockPos)silo.target.getValue()).m_123342_(), z, silo);
    }

    private static void updateSiloCoords(int x, int y, int z, TileVerticalLaunchSilo silo) {
        silo.target.setValue((Object)new BlockPos(x, y, z));
    }

    private void setSiloFrequency(String val) {
        if (val.isEmpty()) {
            return;
        }
        TileVerticalLaunchSilo silo = (TileVerticalLaunchSilo)((ContainerVLS)this.f_97732_).getSafeHost();
        if (silo == null) {
            return;
        }
        int frequency = 0;
        try {
            frequency = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        silo.frequency.setValue((Object)frequency);
    }

    private void setFrequency(String val) {
        this.frequencyField.setFocus(true);
        this.xCoordField.setFocus(false);
        this.yCoordField.setFocus(false);
        this.zCoordField.setFocus(false);
        this.setSiloFrequency(val);
    }

    private void setX(String val) {
        this.xCoordField.setFocus(true);
        this.yCoordField.setFocus(false);
        this.zCoordField.setFocus(false);
        this.frequencyField.setFocus(false);
        this.setSiloTargetX(val);
    }

    private void setY(String val) {
        this.yCoordField.setFocus(true);
        this.xCoordField.setFocus(false);
        this.zCoordField.setFocus(false);
        this.frequencyField.setFocus(false);
        this.setSiloTargetY(val);
    }

    private void setZ(String val) {
        this.zCoordField.setFocus(true);
        this.yCoordField.setFocus(false);
        this.xCoordField.setFocus(false);
        this.frequencyField.setFocus(false);
        this.setSiloTargetZ(val);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            TileVerticalLaunchSilo silo = (TileVerticalLaunchSilo)((ContainerVLS)this.f_97732_).getSafeHost();
            if (silo != null) {
                this.xCoordField.setValue("" + ((BlockPos)silo.target.getValue()).m_123341_());
                this.yCoordField.setValue("" + ((BlockPos)silo.target.getValue()).m_123342_());
                this.zCoordField.setValue("" + ((BlockPos)silo.target.getValue()).m_123343_());
                this.frequencyField.setValue("" + silo.frequency.getValue());
            }
        }
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileVerticalLaunchSilo silo = (TileVerticalLaunchSilo)((ContainerVLS)this.f_97732_).getSafeHost();
        if (silo == null) {
            return list;
        }
        ComponentElectrodynamic el = (ComponentElectrodynamic)silo.getComponent(IComponentType.Electrodynamic);
        list.add(BallistixTextUtils.tooltip("missilesilo.charge", ChatFormatter.getChatDisplayShort((double)el.getJoulesStored(), (IDisplayUnit)DisplayUnits.JOULES).m_130940_(ChatFormatting.GRAY), ChatFormatter.getChatDisplayShort((double)BallistixConstants.MISSILESILO_USAGE, (IDisplayUnit)DisplayUnits.JOULES).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(VoltaicTextUtils.gui((String)"machine.voltage", (Object[])new Object[]{ChatFormatter.getChatDisplayShort((double)el.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        return list;
    }
}

