/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier3;

import ballistix.api.blast.IBlast;
import ballistix.api.blast.IHasCustomRender;
import ballistix.common.blast.util.Blast;
import ballistix.common.blast.util.thread.ThreadSimpleBlast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.settings.BallistixConstants;
import ballistix.registers.BallistixSounds;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.api.item.IItemElectric;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class BlastEMP
extends Blast
implements IHasCustomRender {
    private ThreadSimpleBlast thread;
    private int pertick = -1;
    private Iterator<BlockPos> cachedIterator;

    public BlastEMP(Level world, BlockPos position, @Nullable Entity owner, @Nullable Entity blastEntity) {
        super(world, position, owner, blastEntity);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.thread = new ThreadSimpleBlast(this.world, this.position, (int)BallistixConstants.EXPLOSIVE_EMP_RADIUS, 2.1474836E9f, null, this.getBlastType().id());
            this.thread.start();
            this.world.m_5594_(null, this.position, (SoundEvent)BallistixSounds.SOUND_EMPEXPLOSION.get(), SoundSource.BLOCKS, 25.0f, 1.0f);
        }
    }

    @Override
    public boolean shouldRender() {
        return this.pertick > 0;
    }

    @Override
    public boolean doExplode(int callCount) {
        super.doExplode(callCount);
        if (this.world.f_46443_) {
            return false;
        }
        if (this.thread == null) {
            return true;
        }
        if (!this.thread.isComplete) {
            return false;
        }
        this.hasStarted = true;
        if (this.pertick == -1) {
            this.pertick = (int)((double)this.thread.results.size() / BallistixConstants.EXPLOSIVE_ANTIMATTER_DURATION + 1.0);
            this.cachedIterator = this.thread.results.iterator();
        }
        int finished = this.pertick;
        while (this.cachedIterator.hasNext() && finished-- >= 0) {
            BlockEntity entity;
            BlockPos p = new BlockPos((Vec3i)this.cachedIterator.next()).m_121955_((Vec3i)this.position);
            if (!BlastEMP.canHarmBlock(p) || (entity = this.world.m_7702_(p)) == null) continue;
            for (Direction dir : Direction.values()) {
                ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)entity.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, dir).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
                if (electro != CapabilityUtils.EMPTY_ELECTRO) {
                    electro.setJoulesStored(0.0);
                    continue;
                }
                IEnergyStorage fe = (IEnergyStorage)entity.getCapability(ForgeCapabilities.ENERGY, dir).orElse((Object)CapabilityUtils.EMPTY_FE);
                if (fe == CapabilityUtils.EMPTY_FE) continue;
                fe.extractEnergy(Integer.MAX_VALUE, false);
            }
        }
        if (!this.cachedIterator.hasNext()) {
            float doubleSize = (float)(BallistixConstants.EXPLOSIVE_EMP_RADIUS * 2.0);
            int x0 = Mth.m_14107_((double)((double)this.position.m_123341_() - (double)doubleSize - 1.0));
            int x1 = Mth.m_14107_((double)((double)this.position.m_123341_() + (double)doubleSize + 1.0));
            int y0 = Mth.m_14107_((double)((double)this.position.m_123342_() - (double)doubleSize - 1.0));
            int y1 = Mth.m_14107_((double)((double)this.position.m_123342_() + (double)doubleSize + 1.0));
            int z0 = Mth.m_14107_((double)((double)this.position.m_123343_() - (double)doubleSize - 1.0));
            int z1 = Mth.m_14107_((double)((double)this.position.m_123343_() + (double)doubleSize + 1.0));
            List entities = this.world.m_45933_(null, new AABB((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
            for (Entity entity : entities) {
                if (!entity.m_6084_() || !BlastEMP.canHarmEntity(entity)) continue;
                IEnergyStorage entityFE = (IEnergyStorage)entity.getCapability(ForgeCapabilities.ENERGY).orElse((Object)CapabilityUtils.EMPTY_FE);
                if (entityFE != CapabilityUtils.EMPTY_FE && entityFE.canExtract()) {
                    while (entityFE.getEnergyStored() > 0) {
                        entityFE.extractEnergy(Integer.MAX_VALUE, false);
                    }
                }
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                Inventory inv = player.m_150109_();
                for (int i = 0; i < inv.m_6643_(); ++i) {
                    Item item;
                    ItemStack stack = inv.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    IEnergyStorage itemFE = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).orElse((Object)CapabilityUtils.EMPTY_FE);
                    if (itemFE != null && itemFE.canExtract()) {
                        while (itemFE.getEnergyStored() > 0) {
                            itemFE.extractEnergy(Integer.MAX_VALUE, false);
                        }
                    }
                    if ((item = stack.m_41720_()) instanceof IItemElectric) {
                        IItemElectric electric = (IItemElectric)item;
                        while (electric.getJoulesStored(stack) > 0.0) {
                            electric.extractPower(stack, Double.MAX_VALUE, false);
                        }
                    }
                    inv.m_6836_(i, stack);
                }
                inv.m_6596_();
            }
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void produceParticles() {
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public IBlast getBlastType() {
        return SubtypeBlast.emp;
    }
}

