/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier3;

import ballistix.api.blast.IBlast;
import ballistix.api.blast.IHasCustomRender;
import ballistix.client.particle.ParticleOptionsBlastSmoke;
import ballistix.client.particle.ParticleOptionsShockwave;
import ballistix.client.shake.CameraShakeEffect;
import ballistix.client.shake.CameraShakeManager;
import ballistix.common.blast.util.BlastLasting;
import ballistix.common.blast.util.thread.ThreadSimpleBlast;
import ballistix.common.blast.util.thread.raycast.ThreadDynamicRaycastBlast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.packet.NetworkHandler;
import ballistix.common.packet.type.client.particle.BlastParticleSpawnType;
import ballistix.common.packet.type.client.particle.PacketSpawnBlastParticle;
import ballistix.common.settings.BallistixConstants;
import ballistix.compatibility.nuclearscience.RadiationHandler;
import ballistix.prefab.utils.ParticleUtilities;
import ballistix.registers.BallistixSounds;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkDirection;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.prefab.utilities.object.Location;

public class BlastNuclear
extends BlastLasting
implements IHasCustomRender {
    private Iterator<BlockPos> cachedIteratorRay;
    private Iterator<BlockPos> cachedIterator;
    private ThreadDynamicRaycastBlast threadRay;
    private ThreadSimpleBlast threadSimple;
    private int pertick = -1;
    private int perticksimple = -1;
    private boolean hasShaken;
    private boolean secondDamage = false;
    private boolean thirdDamage = false;
    private boolean sounded = false;

    public BlastNuclear(Level world, BlockPos position, @Nullable Entity owner, @Nullable Entity blastEntity) {
        super(world, position, owner, blastEntity);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.threadRay = new ThreadDynamicRaycastBlast(this.world, this.position, (int)BallistixConstants.EXPLOSIVE_NUCLEAR_SIZE, (float)BallistixConstants.EXPLOSIVE_NUCLEAR_ENERGY, null);
            this.threadSimple = new ThreadSimpleBlast(this.world, this.position, (int)BallistixConstants.EXPLOSIVE_NUCLEAR_RADIATION_RADIUS, 2.1474836E9f, null, this.getBlastType().id());
            this.threadSimple.strictnessAtEdges = 1.7;
            if (BallistixConstants.SHOULD_MULTITHREAD_RAYTRACING) {
                this.threadRay.start();
            } else {
                this.threadRay.run();
            }
            this.threadSimple.start();
            Explosion ex = new Explosion(this.world, null, null, null, (double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), (float)BallistixConstants.EXPLOSIVE_NUCLEAR_SIZE, false, Explosion.BlockInteraction.DESTROY);
            this.attackEntities((float)BallistixConstants.EXPLOSIVE_NUCLEAR_SIZE * 2.0f, ex);
        }
    }

    @Override
    public boolean shouldRender() {
        return this.pertick > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doExplode(int callCount) {
        super.doExplode(callCount);
        if (this.threadRay == null) {
            return !this.world.f_46443_;
        }
        Explosion ex = new Explosion(this.world, this.blastEntity, this.world.m_269111_().m_269036_(this.blastEntity, this.owner), null, (double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), (float)BallistixConstants.EXPLOSIVE_NUCLEAR_SIZE * 3.0f, false, Explosion.BlockInteraction.DESTROY);
        if (callCount % 2 == 0) {
            Set<BlockPos> set = this.threadRay.finishedBlocks;
            synchronized (set) {
                if (this.pertick == -1) {
                    this.hasStarted = true;
                    this.attackEntities((float)BallistixConstants.EXPLOSIVE_NUCLEAR_SIZE * 2.0f, ex);
                    this.world.m_5594_(null, this.position, (SoundEvent)BallistixSounds.SOUND_NUCLEAREXPLOSION.get(), SoundSource.BLOCKS, 25.0f, 1.0f);
                    this.pertick = (int)(864000.0 / BallistixConstants.EXPLOSIVE_NUCLEAR_DURATION);
                }
                int finished = this.pertick;
                this.cachedIteratorRay = this.threadRay.finishedBlocks.iterator();
                while (this.cachedIteratorRay.hasNext() && finished-- >= 0) {
                    BlockPos offset;
                    BlockPos p = this.cachedIteratorRay.next();
                    BlockState state = this.world.m_8055_(p);
                    if (!BlastNuclear.canBreakBlockState(this.world, state, p, this.owner)) continue;
                    Block block = state.m_60734_();
                    BlockState toPlace = Blocks.f_50016_.m_49966_();
                    double dis = new Location((double)p.m_123341_(), 0.0, (double)p.m_123343_()).distance(new Location((double)this.position.m_123341_(), 0.0, (double)this.position.m_123343_()));
                    if ((double)this.world.f_46441_.m_188501_() < 1.0 / (3.0 * Math.sqrt(dis)) && !this.threadRay.results.contains(offset = p.m_121945_(Direction.DOWN))) {
                        toPlace = Blocks.f_50083_.m_49966_();
                    }
                    block.m_7592_(this.world, p, ex);
                    this.world.m_7731_(p, toPlace, 35);
                    Level level = this.world;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverlevel = (ServerLevel)level;
                        if (!this.sounded) {
                            serverlevel.m_7726_().f_8325_.m_183262_(new ChunkPos(p), false).forEach(player -> serverlevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)BallistixSounds.SOUND_NUCLEAREXPLOSION.get(), SoundSource.PLAYERS, 25.0f, 1.0f));
                            this.sounded = true;
                        }
                        if ((double)this.world.f_46441_.m_188501_() < 0.05) {
                            serverlevel.m_7726_().f_8325_.m_183262_(new ChunkPos(p), false).forEach(pl -> NetworkHandler.CHANNEL.sendTo((Object)new PacketSpawnBlastParticle(p, BlastParticleSpawnType.EXPLOSIVE_BLOCK_BREAK), pl.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
                        }
                    }
                    this.cachedIteratorRay.remove();
                }
            }
        }
        if (this.threadRay.isComplete && !this.secondDamage) {
            this.attackEntities((float)BallistixConstants.EXPLOSIVE_NUCLEAR_SIZE * 2.0f, ex);
            this.secondDamage = true;
        }
        if (this.threadSimple.isComplete && callCount % 2 == 0) {
            if (!this.thirdDamage) {
                this.attackEntities((float)BallistixConstants.EXPLOSIVE_NUCLEAR_SIZE * 2.0f, ex);
                this.thirdDamage = true;
            }
            if (BlastNuclear.canSpawnParticle(this.position)) {
                RadiationSystem.addRadiationSource((Level)this.world, (SimpleRadiationSource)new SimpleRadiationSource(150000.0, 2.0, (int)BallistixConstants.EXPLOSIVE_NUCLEAR_RADIATION_RADIUS, false, 1728000, this.position, true, false));
            }
            if (this.perticksimple == -1) {
                this.cachedIterator = this.threadSimple.results.iterator();
            }
            int finished = this.perticksimple = (int)(Math.PI * 2 * (double)Mth.m_14045_((int)(callCount * callCount), (int)0, (int)((int)(BallistixConstants.EXPLOSIVE_NUCLEAR_RADIATION_RADIUS * BallistixConstants.EXPLOSIVE_NUCLEAR_RADIATION_RADIUS))));
            while (this.cachedIterator.hasNext() && finished-- >= 0) {
                Direction dir;
                BlockPos pos = this.cachedIterator.next().m_121955_((Vec3i)this.position);
                if (!BlastNuclear.canHarmBlock(pos) || !ModList.get().isLoaded("nuclearscience") || !(pos.m_123331_((Vec3i)this.position) / (BallistixConstants.EXPLOSIVE_NUCLEAR_RADIATION_RADIUS * BallistixConstants.EXPLOSIVE_NUCLEAR_RADIATION_RADIUS * 4.0) < 0.6 + 0.2 * this.world.f_46441_.m_188500_())) continue;
                RadiationHandler.addNuclearExplosiveIrradidatedBlock(pos, this.world);
                BlockState at = this.world.m_8055_(pos);
                if (at.m_204336_(Tags.Blocks.GLASS)) {
                    this.world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
                    continue;
                }
                if (!((double)this.world.f_46441_.m_188501_() < 0.2) || !at.isFlammable((BlockGetter)this.world, pos, dir = Direction.m_235672_((RandomSource)this.world.f_46441_))) continue;
                this.world.m_7731_(pos.m_121945_(dir), Blocks.f_50083_.m_49966_(), 35);
            }
            if (!this.cachedIterator.hasNext()) {
                return this.ticksSinceBlastStart > 1500;
            }
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void produceParticles() {
        double x = (double)this.position.m_123341_() + 0.5;
        double y = (double)this.position.m_123342_() + 0.5;
        double z = (double)this.position.m_123343_() + 0.5;
        double initialSpeed = 1.25;
        if (this.ticksSinceBlastStart < 5) {
            particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 12.5f, -0.045f, 1500, true, true, 200, 0.985);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 90, 10.0, 90.0, initialSpeed, true);
            initialSpeed = 2.0;
            particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 5.0f, 0.045f, 1500, true, 0.99);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 25, 0.0, 35.0, initialSpeed, true);
            initialSpeed = 2.0;
            particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 5.0f, 0.045f, 1500, true, 0.995);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 50, 0.0, 30.0, initialSpeed, true);
            initialSpeed = 2.0;
            particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 5.0f, 0.015f, 1500, true, 0.97);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 50, 0.0, 20.0, initialSpeed, true);
            initialSpeed = 2.0;
            particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 5.0f, -0.015f, 300, true, 0.97);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 33, 0.0, 20.0, initialSpeed, true);
            if (this.ticksSinceBlastStart == 3) {
                initialSpeed = 1.5;
                particle = new ParticleOptionsShockwave().setParameters(1.0f, 1.0f, 1.0f, 1.0f, 4.0f, 150, false, 0.999);
                ParticleUtilities.spawnParticleRing(particle, x, y + 25.0, z, 100, initialSpeed, false);
            }
        } else if (this.ticksSinceBlastStart < 1500 && this.ticksSinceBlastStart % 3 == 0) {
            initialSpeed = 0.7;
            particle = new ParticleOptionsBlastSmoke().setParameters(0.5078125f, 0.5078125f, 0.5078125f, 5.0f, -0.045f, Mth.m_14045_((int)(1600 - this.ticksSinceBlastStart), (int)1, (int)1500), true, 0.975);
            ParticleUtilities.spawnParticleSphere(particle, x, y + (double)(0.024f * (float)this.ticksSinceBlastStart), z, 1, -20.0, 20.0, initialSpeed, true);
            particle = new ParticleOptionsBlastSmoke().setParameters(0.5078125f, 0.5078125f, 0.5078125f, 5.0f, -0.045f, Mth.m_14045_((int)(1600 - this.ticksSinceBlastStart), (int)1, (int)1500), true, 0.975);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 1, -20.0, 20.0, initialSpeed, true);
            if (this.ticksSinceBlastStart < 1400) {
                initialSpeed = 0.5;
                particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 6.0f, -0.045f, Mth.m_14045_((int)(1640 - this.ticksSinceBlastStart), (int)1, (int)1400), true, true, 500, 0.98);
                ParticleUtilities.spawnParticleSphere(particle, x, y + (double)(0.027f * (float)this.ticksSinceBlastStart), z, 1, -20.0, 20.0, initialSpeed, true);
            }
        }
        double spawnSize = 3.0;
        double endSize = BallistixConstants.EXPLOSIVE_NUCLEAR_SIZE * 5.0;
        int diff = (int)(endSize - spawnSize);
        if (this.ticksSinceBlastStart > diff) {
            return;
        }
        double size = ParticleUtilities.progressGroundShockwave(this.world, x, z, (double)(this.ticksSinceBlastStart * 5) / (double)diff, spawnSize, endSize, 0.2);
        if (this.hasShaken) {
            return;
        }
        Vec3 pos = new Vec3(x, y, z);
        double realDistance = Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(pos);
        double dist = Mth.m_14154_((float)((float)(realDistance - size)));
        if (dist < 3.0) {
            this.hasShaken = true;
            CameraShakeEffect effect = CameraShakeManager.createBlastSourcedEffect(80.0, endSize, this.world.m_46467_(), pos);
            CameraShakeManager.addShake(effect);
        }
    }

    @Override
    public boolean isDoneCalculating() {
        if (this.world.f_46443_) {
            return this.shouldRenderCustomClient;
        }
        return this.threadRay == null || this.threadRay.isComplete;
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public IBlast getBlastType() {
        return SubtypeBlast.nuclear;
    }
}

