/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.util.thread;

import ballistix.common.blast.util.thread.ThreadBlast;
import ballistix.common.settings.BallistixConstants;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import voltaic.Voltaic;
import voltaic.prefab.block.HashDistanceBlockPos;

public class ThreadSimpleBlast
extends ThreadBlast {
    private static final HashMap<Pair<Integer, ResourceLocation>, Set<BlockPos>> CACHED_EUCLIDEAN_RESULTS = new HashMap();
    private static final Set<Integer> currentlyCalculating = Collections.synchronizedSet(new HashSet());
    private final Pair<Integer, ResourceLocation> idPair;
    private boolean sortBasedOnDistance = false;
    public double strictnessAtEdges = 1.85;

    public ThreadSimpleBlast(Level world, BlockPos position, int range, float energy, Entity source, ResourceLocation id) {
        super(world, position, range, energy, source);
        this.setName("Simple blast thread");
        this.idPair = new Pair((Object)range, (Object)id);
        this.setPriority(10);
    }

    public ThreadSimpleBlast(Level world, BlockPos position, int range, float energy, Entity source, ResourceLocation id, boolean sortBasedOnDistance) {
        this(world, position, range, energy, source, id);
        this.sortBasedOnDistance = sortBasedOnDistance;
    }

    @Override
    public void run() {
        int explosionRadius = this.explosionRadius;
        Random random = Voltaic.RANDOM;
        this.runEuclidian(explosionRadius, random);
        super.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEuclidian(int explosionRadius, Random random) {
        if (BallistixConstants.SHOULD_CACHE_EXPLOSIONS) {
            Set<Integer> set = currentlyCalculating;
            synchronized (set) {
                while (currentlyCalculating.contains(explosionRadius)) {
                    try {
                        ThreadSimpleBlast.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                if (CACHED_EUCLIDEAN_RESULTS.get(this.idPair) == null) {
                    currentlyCalculating.add(explosionRadius);
                }
            }
            if (CACHED_EUCLIDEAN_RESULTS.get(this.idPair) == null) {
                int rSqrd = explosionRadius * explosionRadius;
                ArrayList<Object> positions = new ArrayList<Object>((int)(4.1887902047863905 * (double)rSqrd * (double)(explosionRadius + 1)));
                for (int i = -explosionRadius; i <= explosionRadius; ++i) {
                    for (int j = 0; j <= explosionRadius; ++j) {
                        int dist2D = i * i + j * j;
                        if (dist2D > rSqrd) continue;
                        int kMax = (int)Math.floor(Math.sqrt(rSqrd - dist2D));
                        for (int k = 0; k <= kMax; ++k) {
                            int dist3D = dist2D + k * k;
                            if (!((double)(random.nextFloat() * (float)rSqrd) < (double)rSqrd * this.strictnessAtEdges - (double)dist3D)) continue;
                            positions.add(new HashDistanceBlockPos((double)i, (double)k, (double)j, (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                            if (k != 0) {
                                positions.add(new HashDistanceBlockPos((double)i, (double)(-k), (double)j, (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                                if (j != 0) {
                                    positions.add(new HashDistanceBlockPos((double)i, (double)(-k), (double)(-j), (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                                }
                            }
                            if (j == 0) continue;
                            positions.add(new HashDistanceBlockPos((double)i, (double)k, (double)(-j), (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                        }
                    }
                }
                Random rand = Voltaic.RANDOM;
                for (int i = 0; i < positions.size(); ++i) {
                    int newIndex = rand.nextInt(Math.max(0, i - 10), Math.min(positions.size() - 1, i + 10));
                    BlockPos atNew = (BlockPos)positions.get(newIndex);
                    positions.set(newIndex, (BlockPos)positions.get(i));
                    positions.set(i, atNew);
                }
                if (this.sortBasedOnDistance) {
                    Comparator<BlockPos> byCenterDistance = Comparator.comparingLong(pos -> {
                        long x = pos.m_123341_();
                        long y = pos.m_123342_();
                        long z = pos.m_123343_();
                        return x * x + y * y + z * z;
                    });
                    byCenterDistance = byCenterDistance.thenComparingInt(Vec3i::m_123341_).thenComparingInt(Vec3i::m_123342_).thenComparingInt(Vec3i::m_123343_);
                    TreeSet<BlockPos> sorted = new TreeSet<BlockPos>(byCenterDistance);
                    sorted.addAll(positions);
                    CACHED_EUCLIDEAN_RESULTS.put(this.idPair, sorted);
                } else {
                    CACHED_EUCLIDEAN_RESULTS.put(this.idPair, Sets.newHashSet(positions));
                }
            }
            this.results = CACHED_EUCLIDEAN_RESULTS.get(this.idPair);
            Set<Integer> rSqrd = currentlyCalculating;
            synchronized (rSqrd) {
                currentlyCalculating.remove(explosionRadius);
            }
        }
        int rSqrd = explosionRadius * explosionRadius;
        ArrayList<Object> positions = new ArrayList<Object>((int)(4.1887902047863905 * (double)rSqrd * (double)(explosionRadius + 1)));
        for (int i = -explosionRadius; i <= explosionRadius; ++i) {
            for (int j = 0; j <= explosionRadius; ++j) {
                int dist2D = i * i + j * j;
                if (dist2D > rSqrd) continue;
                int kMax = (int)Math.floor(Math.sqrt(rSqrd - dist2D));
                for (int k = 0; k <= kMax; ++k) {
                    int dist3D = dist2D + k * k;
                    if (!((double)(random.nextFloat() * (float)rSqrd) < (double)rSqrd * this.strictnessAtEdges - (double)dist3D)) continue;
                    positions.add(new HashDistanceBlockPos((double)i, (double)k, (double)j, (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                    if (k != 0) {
                        positions.add(new HashDistanceBlockPos((double)i, (double)(-k), (double)j, (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                        if (j != 0) {
                            positions.add(new HashDistanceBlockPos((double)i, (double)(-k), (double)(-j), (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                        }
                    }
                    if (j == 0) continue;
                    positions.add(new HashDistanceBlockPos((double)i, (double)k, (double)(-j), (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                }
            }
        }
        Random rand = Voltaic.RANDOM;
        for (int i = 0; i < positions.size(); ++i) {
            int newIndex = rand.nextInt(Math.max(0, i - 10), Math.min(positions.size() - 1, i + 10));
            BlockPos atNew = (BlockPos)positions.get(newIndex);
            positions.set(newIndex, (BlockPos)positions.get(i));
            positions.set(i, atNew);
        }
        this.results = Sets.newHashSet(positions);
        if (this.sortBasedOnDistance) {
            Comparator<BlockPos> byCenterDistance = Comparator.comparingLong(pos -> {
                long x = pos.m_123341_();
                long y = pos.m_123342_();
                long z = pos.m_123343_();
                return x * x + y * y + z * z;
            });
            byCenterDistance = byCenterDistance.thenComparingInt(Vec3i::m_123341_).thenComparingInt(Vec3i::m_123342_).thenComparingInt(Vec3i::m_123343_);
            TreeSet<BlockPos> sorted = new TreeSet<BlockPos>(byCenterDistance);
            sorted.addAll(positions);
            this.results = sorted;
        }
    }
}

