/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.block;

import ballistix.api.blast.IBlast;
import ballistix.common.entity.EntityExplosive;
import ballistix.prefab.utils.BallistixTextUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import voltaic.common.block.states.VoltaicBlockStates;

public class BlockExplosive
extends Block {
    public final IBlast explosive;

    public BlockExplosive(IBlast explosive) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50077_).m_60966_().m_60918_(SoundType.f_56740_).m_60955_().m_60924_((a, b, c) -> false));
        this.explosive = explosive;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61138_((Property)VoltaicBlockStates.FACING)) {
            return this.explosive.getShape().getShape((Direction)state.m_61143_((Property)VoltaicBlockStates.FACING));
        }
        return this.explosive.getShape().getShape(null);
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, Direction face, LivingEntity igniter) {
        BlockExplosive.explode(world, pos, this.explosive, (Entity)igniter);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_()) && worldIn.m_276867_(pos)) {
            this.onCaughtFire(state, worldIn, pos, null, null);
            worldIn.m_7471_(pos, false);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity ent) {
        super.m_7892_(state, level, pos, ent);
        this.explosive.onEntityInside(state, level, pos, ent);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.m_276867_(pos)) {
            this.onCaughtFire(state, worldIn, pos, null, null);
            worldIn.m_7471_(pos, false);
        }
    }

    public void m_7592_(Level worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.f_46443_) {
            LivingEntity owner = explosionIn.m_252906_();
            if (owner == null) {
                owner = explosionIn.m_253049_();
            }
            if (owner instanceof TraceableEntity) {
                TraceableEntity trace = (TraceableEntity)owner;
                owner = trace.m_19749_();
            }
            BlockExplosive.explode(worldIn, pos, this.explosive, (Entity)owner);
        }
    }

    public static void explode(Level worldIn, BlockPos pos, IBlast explosive, @Nullable Entity owner) {
        if (!worldIn.f_46443_) {
            EntityExplosive explosiveEntity = new EntityExplosive(worldIn, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, owner);
            explosiveEntity.setBlastType(explosive);
            worldIn.m_7967_((Entity)explosiveEntity);
            worldIn.m_6263_((Player)null, explosiveEntity.m_20185_(), explosiveEntity.m_20186_(), explosiveEntity.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (item != Items.f_42409_ && item != Items.f_42613_) {
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        this.onCaughtFire(state, worldIn, pos, hit.m_82434_(), (LivingEntity)player);
        worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        if (!player.m_7500_()) {
            if (item == Items.f_42409_) {
                itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(handIn));
            } else {
                itemstack.m_41774_(1);
            }
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!worldIn.f_46443_) {
            Entity entity = projectile.m_19749_();
            if (projectile.m_6060_()) {
                LivingEntity l;
                BlockPos blockpos = hit.m_82425_();
                this.onCaughtFire(state, worldIn, blockpos, null, entity instanceof LivingEntity ? (l = (LivingEntity)entity) : null);
                worldIn.m_7471_(blockpos, false);
            }
        }
    }

    public boolean m_6903_(Explosion explosionIn) {
        return false;
    }

    public void m_5871_(ItemStack stack, BlockGetter context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.m_5871_(stack, context, tooltipComponents, tooltipFlag);
        if (this.explosive.tier() >= 0) {
            tooltipComponents.add((Component)BallistixTextUtils.tooltip("explosive.tier", Component.m_237113_((String)("" + this.explosive.tier())).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

