/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.entity;

import ballistix.api.missile.MissileManager;
import ballistix.api.missile.virtual.VirtualMissile;
import ballistix.client.particle.ParticleOptionsMissileSmoke;
import ballistix.registers.BallistixEntities;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import voltaic.Voltaic;
import voltaic.prefab.utilities.BlockEntityUtils;

public class EntityMissile
extends Entity {
    private static final EntityDataAccessor<Integer> MISSILE_TYPE = SynchedEntityData.m_135353_(EntityMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> TARGET = SynchedEntityData.m_135353_(EntityMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(EntityMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_X = SynchedEntityData.m_135353_(EntityMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_Z = SynchedEntityData.m_135353_(EntityMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> FLIGHT_PATH = SynchedEntityData.m_135353_(EntityMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CURRENTLYEXPLODING = SynchedEntityData.m_135353_(EntityMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HASIGNIGHTED = SynchedEntityData.m_135353_(EntityMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int missileType = -1;
    public float speed = 0.0f;
    @Nullable
    public UUID id;
    public int flightPath = 2;
    public boolean isExploding = false;
    public BlockPos target = BlockEntityUtils.OUT_OF_REACH;
    public float startX;
    public float startZ;
    private boolean hasIgnighted = false;

    public EntityMissile(EntityType<? extends EntityMissile> type, Level worldIn) {
        super(type, worldIn);
        this.f_19850_ = true;
    }

    public EntityMissile(Level worldIn) {
        this((EntityType<? extends EntityMissile>)((EntityType)BallistixEntities.ENTITY_MISSILE.get()), worldIn);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET, (Object)BlockEntityUtils.OUT_OF_REACH);
        this.f_19804_.m_135372_(MISSILE_TYPE, (Object)-1);
        this.f_19804_.m_135372_(START_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FLIGHT_PATH, (Object)2);
        this.f_19804_.m_135372_(CURRENTLYEXPLODING, (Object)false);
        this.f_19804_.m_135372_(HASIGNIGHTED, (Object)false);
    }

    public void m_8119_() {
        VirtualMissile.FlightPath path;
        boolean isServerSide;
        Level level = this.m_9236_();
        boolean isClientSide = level.f_46443_;
        boolean bl = isServerSide = !isClientSide;
        if (isServerSide) {
            if (this.id == null) {
                this.m_6089_();
                return;
            }
            VirtualMissile missile = MissileManager.getMissile((ResourceKey<Level>)level.m_46472_(), this.id);
            if (missile == null) {
                this.m_6089_();
                return;
            }
            if (missile.hasExploded()) {
                this.m_6089_();
                return;
            }
            if (missile.blastEntity != null) {
                this.isExploding = true;
            }
            if (!this.m_20183_().equals((Object)missile.blockPosition())) {
                this.m_146884_(missile.position);
                this.m_20256_(missile.deltaMovement);
                this.speed = missile.speed;
            }
        }
        if (isServerSide) {
            this.f_19804_.m_135381_(TARGET, (Object)this.target);
            this.f_19804_.m_135381_(MISSILE_TYPE, (Object)this.missileType);
            this.f_19804_.m_135381_(START_X, (Object)Float.valueOf(this.startX));
            this.f_19804_.m_135381_(START_Z, (Object)Float.valueOf(this.startZ));
            this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(this.speed));
            this.f_19804_.m_135381_(FLIGHT_PATH, (Object)this.flightPath);
            this.f_19804_.m_135381_(CURRENTLYEXPLODING, (Object)this.isExploding);
            this.f_19804_.m_135381_(HASIGNIGHTED, (Object)this.hasIgnighted);
        } else {
            this.target = (BlockPos)this.f_19804_.m_135370_(TARGET);
            this.missileType = (Integer)this.f_19804_.m_135370_(MISSILE_TYPE);
            this.startX = ((Float)this.f_19804_.m_135370_(START_X)).floatValue();
            this.startZ = ((Float)this.f_19804_.m_135370_(START_Z)).floatValue();
            this.speed = ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
            this.flightPath = (Integer)this.f_19804_.m_135370_(FLIGHT_PATH);
            this.isExploding = (Boolean)this.f_19804_.m_135370_(CURRENTLYEXPLODING);
            this.hasIgnighted = (Boolean)this.f_19804_.m_135370_(HASIGNIGHTED);
        }
        if (this.isExploding) {
            return;
        }
        if (this.m_20184_().m_82553_() > 0.0) {
            this.m_146926_((float)(Math.atan(this.m_20184_().m_7098_() / Math.sqrt(this.m_20184_().m_7096_() * this.m_20184_().m_7096_() + this.m_20184_().m_7094_() * this.m_20184_().m_7094_())) * 180.0 / Math.PI));
            this.m_146922_((float)(Math.atan2(this.m_20184_().m_7096_(), this.m_20184_().m_7094_()) * 180.0 / Math.PI));
        }
        if (((path = VirtualMissile.FlightPath.values()[this.flightPath]) == VirtualMissile.FlightPath.SILO || path == VirtualMissile.FlightPath.SILO_CLUSTER) && this.missileType != -1) {
            float iDeltaX = (float)this.target.m_123341_() - this.startX;
            float iDeltaZ = (float)this.target.m_123343_() - this.startZ;
            float initialDistance = (float)Math.sqrt(iDeltaX * iDeltaX + iDeltaZ * iDeltaZ);
            float halfwayDistance = initialDistance / 2.0f;
            float deltaX = (float)(this.m_20185_() - (double)this.startX);
            float deltaZ = (float)(this.m_20189_() - (double)this.startZ);
            float distanceTraveled = (float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double maxRadii = 100.0;
            float turnRadius = (float)Mth.m_14008_((double)halfwayDistance, (double)0.001f, (double)maxRadii);
            float deltaY = (float)(this.m_20186_() - 400.0);
            float phi = 0.0f;
            float signY = 1.0f;
            if ((double)halfwayDistance <= maxRadii) {
                if (this.m_20186_() >= 400.0 && distanceTraveled < halfwayDistance) {
                    phi = (float)Math.asin(Mth.m_14036_((float)(deltaY / turnRadius), (float)0.0f, (float)1.0f));
                } else if (distanceTraveled >= halfwayDistance) {
                    if (path == VirtualMissile.FlightPath.SILO_CLUSTER) {
                        this.m_6089_();
                    }
                    phi = (float)Math.asin(Mth.m_14036_((float)((initialDistance - distanceTraveled) / turnRadius), (float)0.0f, (float)1.0f));
                    signY = -1.0f;
                } else if (distanceTraveled >= initialDistance) {
                    signY = -1.0f;
                }
                x = (float)((double)(iDeltaX / initialDistance) * Math.sin(phi));
                z = (float)((double)(iDeltaZ / initialDistance) * Math.sin(phi));
                this.m_20256_(new Vec3((double)x, Math.cos(phi) * (double)signY, (double)z));
            } else {
                if (this.m_20186_() >= 400.0 && distanceTraveled < halfwayDistance) {
                    phi = distanceTraveled <= turnRadius ? (float)Math.asin(Mth.m_14036_((float)(deltaY / turnRadius), (float)0.0f, (float)1.0f)) : 1.5707964f;
                } else if (distanceTraveled >= halfwayDistance) {
                    if (distanceTraveled >= initialDistance - turnRadius) {
                        if (path == VirtualMissile.FlightPath.SILO_CLUSTER) {
                            this.m_6089_();
                        }
                        phi = (float)Math.asin(Mth.m_14036_((float)((initialDistance - distanceTraveled) / turnRadius), (float)0.0f, (float)1.0f));
                        signY = -1.0f;
                    } else {
                        phi = 1.5707964f;
                    }
                } else if (distanceTraveled >= initialDistance) {
                    signY = -1.0f;
                }
                x = (float)((double)(iDeltaX / initialDistance) * Math.sin(phi));
                z = (float)((double)(iDeltaZ / initialDistance) * Math.sin(phi));
                this.m_20256_(new Vec3((double)x, Math.cos(phi) * (double)signY, (double)z));
            }
        } else if (path == VirtualMissile.FlightPath.VLS && this.missileType != -1) {
            if (!this.hasIgnighted && (double)this.speed > -0.15) {
                this.speed -= 0.03f;
            } else if (!this.hasIgnighted) {
                this.hasIgnighted = true;
            } else if ((double)this.speed > 0.5) {
                Vec3 desiredVector = new Vec3((double)this.target.m_123341_() - this.m_20185_(), (double)this.target.m_123342_() - this.m_20186_(), (double)this.target.m_123343_() - this.m_20189_()).m_82541_();
                Vec3 currVector = this.m_20184_().m_82541_();
                double dotProduct = desiredVector.m_82526_(this.m_20184_().m_82541_());
                double maxTurnRadians = 0.05;
                if (dotProduct != 0.0) {
                    if (Math.acos(dotProduct) <= maxTurnRadians) {
                        this.m_20256_(desiredVector);
                    } else {
                        Vec3 perpVector = currVector.m_82537_(desiredVector).m_82537_(currVector).m_82541_();
                        Vec3 result = currVector.m_82490_(Math.cos(maxTurnRadians)).m_82549_(perpVector.m_82490_(Math.sin(maxTurnRadians)));
                        this.m_20256_(result.m_82541_());
                    }
                }
            }
        }
        if (this.f_19797_ != 0) {
            Vec3 vec = new Vec3(this.m_20185_() + (double)this.speed * this.m_20184_().f_82479_, this.m_20186_() + (double)this.speed * this.m_20184_().f_82480_, this.m_20189_() + (double)this.speed * this.m_20184_().f_82481_);
            this.m_146884_(vec);
        }
        if ((path == VirtualMissile.FlightPath.SILO || path == VirtualMissile.FlightPath.SILO_CLUSTER || path == VirtualMissile.FlightPath.VLS && this.hasIgnighted) && !this.target.equals((Object)BlockEntityUtils.OUT_OF_REACH) && this.speed < 3.0f) {
            this.speed += 0.02f;
        }
        if (this.missileType == -1 || isServerSide || this.speed >= 3.0f || path == VirtualMissile.FlightPath.VLS && !this.hasIgnighted) {
            return;
        }
        float x = (float)this.m_20185_();
        float y = (float)this.m_20186_();
        float z = (float)this.m_20189_();
        float motionX = (float)((double)this.speed * this.m_20184_().f_82479_);
        float motionY = (float)((double)this.speed * this.m_20184_().f_82480_);
        float motionZ = (float)((double)this.speed * this.m_20184_().f_82481_);
        x -= motionX;
        y -= motionY;
        z -= motionZ;
        for (int i = 0; i < 4; ++i) {
            Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)new ParticleOptionsMissileSmoke().setParameters(1.0f, 1.0f, 1.0f, this.missileType == 1 ? 0.3f : (this.missileType == 2 ? 0.5f : 0.2f), 50, true), (double)x, (double)y, (double)z, (double)(-motionX) * (0.4 + 0.2 * Voltaic.RANDOM.nextDouble()), (double)(-motionY) * (0.4 + 0.2 * Voltaic.RANDOM.nextDouble()), (double)(-motionZ) * (0.4 + 0.2 * Voltaic.RANDOM.nextDouble()));
        }
    }

    protected boolean m_7341_(Entity entityIn) {
        return true;
    }

    protected void m_7380_(CompoundTag compound) {
        ServerLevel server;
        Level level = this.m_9236_();
        if (!(!(level instanceof ServerLevel) || (server = (ServerLevel)level).m_143340_(this.m_20183_()) && server.m_46805_(this.m_20183_()))) {
            this.m_142467_(Entity.RemovalReason.DISCARDED);
        }
        compound.m_128405_("range", this.missileType);
        if (this.id != null) {
            UUIDUtil.f_235867_.encode((Object)this.id, (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).result().ifPresent(tag -> compound.m_128365_("id", tag));
        }
        BlockPos.f_121852_.encode((Object)this.target, (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).result().ifPresent(tag -> compound.m_128365_("target", tag));
        compound.m_128350_("startx", this.startX);
        compound.m_128350_("startz", this.startZ);
        compound.m_128405_("flightpath", this.flightPath);
        compound.m_128379_("hasignited", this.hasIgnighted);
    }

    protected void m_7378_(CompoundTag compound) {
        this.missileType = compound.m_128451_("range");
        UUIDUtil.f_235867_.decode((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128469_("id")).result().ifPresent(pair -> {
            this.id = (UUID)pair.getFirst();
        });
        BlockPos.f_121852_.decode((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128469_("target")).result().ifPresent(pair -> {
            this.target = (BlockPos)pair.getFirst();
        });
        this.startX = compound.m_128457_("startx");
        this.startZ = compound.m_128457_("startz");
        this.flightPath = compound.m_128451_("flightpath");
        this.hasIgnighted = compound.m_128471_("hasignited");
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            return player.m_7998_((Entity)this, true) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        VirtualMissile missile;
        if (!this.m_9236_().f_46443_ && this.id != null && (missile = MissileManager.getMissile((ResourceKey<Level>)this.m_9236_().m_46472_(), this.id)) != null) {
            missile.setSpawned(false, -1);
        }
        super.m_142687_(reason);
    }

    public boolean m_142389_() {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

