/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.item;

import ballistix.api.blast.IBlast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.entity.EntityMinecart;
import ballistix.registers.BallistixCreativeTabs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import voltaic.api.ISubtype;
import voltaic.common.item.ItemVoltaic;

public class ItemMinecart
extends ItemVoltaic {
    private IBlast blast;
    private static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel level = source.m_7727_();
            double d0 = source.m_7096_() + (double)direction.m_122429_() * 1.125;
            double d1 = Math.floor(source.m_7098_()) + (double)direction.m_122430_();
            double d2 = source.m_7094_() + (double)direction.m_122431_() * 1.125;
            BlockPos blockpos = source.m_7961_().m_121945_(direction);
            BlockState blockstate = level.m_8055_(blockpos);
            Block block = blockstate.m_60734_();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock rail = (BaseRailBlock)block;
                v0 = rail.getRailDirection(blockstate, (BlockGetter)level, blockpos, null);
            } else {
                v0 = railshape = RailShape.NORTH_SOUTH;
            }
            if (blockstate.m_204336_(BlockTags.f_13034_)) {
                d3 = railshape.m_61745_() ? 0.6 : 0.1;
            } else {
                RailShape railShape;
                if (!blockstate.m_60795_() || !level.m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_13034_)) {
                    return this.defaultDispenseItemBehavior.m_6115_(source, stack);
                }
                BlockState blockstate1 = level.m_8055_(blockpos.m_7495_());
                Block block2 = blockstate1.m_60734_();
                if (block2 instanceof BaseRailBlock) {
                    BaseRailBlock rail = (BaseRailBlock)block2;
                    railShape = (RailShape)blockstate1.m_61143_(rail.m_7978_());
                } else {
                    railShape = RailShape.NORTH_SOUTH;
                }
                RailShape railshape1 = railShape;
                d3 = direction != Direction.DOWN && railshape1.m_61745_() ? -0.4 : -0.9;
            }
            EntityMinecart cart = new EntityMinecart((Level)level, null);
            cart.m_6034_(d0, d1 + d3, d2);
            if (stack.m_41788_()) {
                cart.m_6593_(stack.m_41786_());
            }
            cart.setExplosiveType(((ItemMinecart)stack.m_41720_()).blast);
            level.m_7967_((Entity)cart);
            stack.m_41774_(1);
            return stack;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_46796_(1000, source.m_7961_(), 0);
        }
    };

    public ItemMinecart(IBlast blast) {
        super(new Item.Properties().m_41487_(1), () -> (CreativeModeTab)BallistixCreativeTabs.MAIN.get());
        this.blast = blast;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.m_43725_();
        BlockState blockstate = level.m_8055_(blockpos = context.m_8083_());
        if (!blockstate.m_204336_(BlockTags.f_13034_)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = context.m_43722_();
        if (!level.f_46443_) {
            RailShape railShape;
            Block block = blockstate.m_60734_();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock rail = (BaseRailBlock)block;
                railShape = rail.getRailDirection(blockstate, (BlockGetter)level, blockpos, null);
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape railshape = railShape;
            double d0 = 0.0;
            if (railshape.m_61745_()) {
                d0 = 0.5;
            }
            EntityMinecart cart = new EntityMinecart(level, (Entity)context.m_43723_());
            cart.m_6034_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.0625 + d0, (double)blockpos.m_123343_() + 0.5);
            if (itemstack.m_41788_()) {
                cart.m_6593_(itemstack.m_41786_());
            }
            cart.setExplosiveType(this.blast);
            level.m_7967_((Entity)cart);
            level.m_142346_((Entity)context.m_43723_(), GameEvent.f_157810_, blockpos);
        }
        itemstack.m_41774_(1);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static enum SubtypeMinecart implements ISubtype
    {
        obsidian(SubtypeBlast.obsidian),
        condensive(SubtypeBlast.condensive),
        attractive(SubtypeBlast.attractive),
        repulsive(SubtypeBlast.repulsive),
        incendiary(SubtypeBlast.incendiary),
        shrapnel(SubtypeBlast.shrapnel),
        anvil(SubtypeBlast.anvil),
        chemical(SubtypeBlast.chemical),
        infestive(SubtypeBlast.infestive),
        debilitation(SubtypeBlast.debilitation),
        fragmentation(SubtypeBlast.fragmentation),
        contagious(SubtypeBlast.contagious),
        sonic(SubtypeBlast.sonic),
        breaching(SubtypeBlast.breaching),
        thermobaric(SubtypeBlast.thermobaric),
        antigravity(SubtypeBlast.antigravity),
        emp(SubtypeBlast.emp),
        endothermic(SubtypeBlast.endothermic),
        exothermic(SubtypeBlast.exothermic),
        ender(SubtypeBlast.ender),
        hypersonic(SubtypeBlast.hypersonic),
        rejuvination(SubtypeBlast.rejuvination),
        nuclear(SubtypeBlast.nuclear),
        antimatter(SubtypeBlast.antimatter),
        largeantimatter(SubtypeBlast.largeantimatter),
        darkmatter(SubtypeBlast.darkmatter);

        public final SubtypeBlast explosiveType;

        private SubtypeMinecart(SubtypeBlast explosive) {
            this.explosiveType = explosive;
        }

        public String forgeTag() {
            return "explosive_minecarts/" + this.name();
        }

        public boolean isItem() {
            return true;
        }

        public String tag() {
            return "minecart" + this.name();
        }
    }
}

