/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile.turret.antimissile.util;

import ballistix.api.turret.ITarget;
import ballistix.common.tile.radar.TileFireControlRadar;
import ballistix.common.tile.turret.antimissile.util.TileTurretAntimissile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import voltaic.Voltaic;

public abstract class TileTurretAntimissileProjectile
extends TileTurretAntimissile {
    public TileTurretAntimissileProjectile(BlockEntityType<?> tileEntityTypeIn, BlockPos worldPos, BlockState blockState, double range, double minRange, double usage, double rotationSpeedRadians, double inaccuracy) {
        super(tileEntityTypeIn, worldPos, blockState, range, minRange, usage, rotationSpeedRadians, inaccuracy);
    }

    @Override
    @Nullable
    public Vec3 getTargetPosition(ITarget target) {
        float trackingSpeed = 0.0f;
        Vec3 trackingVector = target.getTargetMovement();
        double timeToIntercept = TileFireControlRadar.getTimeToIntercept(target.getTargetLocation(), trackingVector, trackingSpeed, this.getProjectileSpeed(), this.getProjectileLaunchPosition());
        if (timeToIntercept <= 0.0) {
            return null;
        }
        return target.getTargetLocation().m_82549_(trackingVector.m_82490_((double)trackingSpeed).m_82490_(timeToIntercept));
    }

    public abstract float getProjectileSpeed();

    public Vec3 getProjectileTrajectoryFromInaccuracy(double inaccuracy, double baseRange, double inaccuracyMultiplier, Vec3 launchPos, Vec3 interceptionPos) {
        double distanceToTarget = TileFireControlRadar.getDistanceToMissile(launchPos, interceptionPos);
        double deltaX = interceptionPos.f_82479_ - launchPos.f_82479_;
        double deltaY = interceptionPos.f_82480_ - launchPos.f_82480_;
        double deltaZ = interceptionPos.f_82481_ - launchPos.f_82481_;
        double rangePenalty = 1.0;
        if (distanceToTarget > baseRange) {
            rangePenalty = (distanceToTarget - baseRange) / baseRange * inaccuracyMultiplier * Voltaic.RANDOM.nextDouble();
        }
        if (Voltaic.RANDOM.nextBoolean()) {
            deltaX *= 1.0 + inaccuracy * Voltaic.RANDOM.nextDouble();
        } else {
            deltaZ *= 1.0 + inaccuracy * Voltaic.RANDOM.nextDouble();
        }
        if (rangePenalty < 1.0) {
            if (Voltaic.RANDOM.nextBoolean()) {
                deltaZ *= 1.0 + rangePenalty;
            } else {
                deltaX *= 1.0 + rangePenalty;
            }
        }
        return new Vec3(deltaX, deltaY, deltaZ).m_82541_();
    }
}

