/*
 * Decompiled with CFR 0.152.
 */
package ballistix.prefab.screen;

import ballistix.api.radar.IDetected;
import ballistix.common.inventory.container.ContainerSearchRadar;
import ballistix.common.tile.radar.TileSearchRadar;
import ballistix.prefab.screen.RadarTextures;
import ballistix.prefab.utils.BallistixTextUtils;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.utilities.math.Color;

public class ScreenComponentDetection
extends ScreenComponentGeneric {
    private IDetected.Detected detection;

    public ScreenComponentDetection(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (!this.isVisible()) {
            return;
        }
        GenericScreen screen = (GenericScreen)this.gui;
        TileSearchRadar tile = (TileSearchRadar)((ContainerSearchRadar)screen.m_6262_()).getSafeHost();
        if (tile == null) {
            return;
        }
        RadarTextures texture = RadarTextures.FREQUENCY;
        ScreenComponentEditBox.drawExpandedBox((GuiGraphics)graphics, (ResourceLocation)texture.getLocation(), (int)(this.xLocation + guiWidth), (int)(this.yLocation + guiHeight), (int)this.width, (int)this.height);
        if (this.detection == null) {
            return;
        }
        graphics.m_280480_(new ItemStack((ItemLike)this.detection.getItem()), guiWidth + this.xLocation + 2, guiHeight + this.yLocation + 4);
        Font font = screen.getFontRenderer();
        MutableComponent text = Component.m_237113_((String)new BlockPos((int)this.detection.getPosition().f_82479_, (int)this.detection.getPosition().f_82480_, (int)this.detection.getPosition().f_82481_).toString());
        int x = this.xLocation + 20;
        int y = this.yLocation + 4;
        int maxWidth = this.width - x - 2;
        int width = font.m_92852_((FormattedText)text);
        float scale = 1.0f;
        if (width > maxWidth) {
            scale = (float)maxWidth / (float)width;
            Objects.requireNonNull(font);
            Objects.requireNonNull(font);
            y += (int)((9.0f - 9.0f * scale) / 2.0f);
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)(guiWidth + x), (float)(guiHeight + y), 0.0f);
        graphics.m_280168_().m_85841_(scale, scale, 0.0f);
        graphics.m_280614_(font, (Component)text, 0, 0, Color.TEXT_GRAY.color(), false);
        graphics.m_280168_().m_85849_();
        y = this.yLocation + 15;
        if (this.detection.showBearing()) {
            double deltaX = (double)tile.m_58899_().m_123341_() - this.detection.getPosition().f_82479_;
            double deltaZ = (double)tile.m_58899_().m_123343_() - this.detection.getPosition().f_82481_;
            double mag = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double angleRads = Math.atan2(deltaZ /= mag, deltaX /= mag);
            double theta = angleRads / Math.PI * 180.0 + (angleRads > 0.0 ? 0.0 : 360.0);
            int thetaMin = (int)(Math.floor(theta) - 1.0);
            int thetaMax = (int)(Math.floor(theta) + 1.0);
            text = BallistixTextUtils.gui("radar.bearing", Component.m_237113_((String)("" + thetaMin % 360)).m_130940_(ChatFormatting.WHITE), Component.m_237113_((String)("" + thetaMax % 360)).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.BLACK);
            scale = 1.0f;
            if (width > maxWidth) {
                scale = (float)maxWidth / (float)width;
                Objects.requireNonNull(font);
                Objects.requireNonNull(font);
                y += (int)((9.0f - 9.0f * scale) / 2.0f);
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(guiWidth + x), (float)(guiHeight + y), 0.0f);
            graphics.m_280168_().m_85841_(scale, scale, 0.0f);
            graphics.m_280614_(font, (Component)text, 0, 0, Color.TEXT_GRAY.color(), false);
            graphics.m_280168_().m_85849_();
        } else {
            graphics.m_280614_(font, (Component)BallistixTextUtils.gui("radar.bearingunknown", new Object[0]), guiWidth + x, guiHeight + y, Color.BLACK.color(), false);
        }
    }

    public void setDetection(IDetected.Detected detection) {
        this.detection = detection;
    }
}

