/*
 * Decompiled with CFR 0.152.
 */
package ballistix.prefab.screen;

import ballistix.client.screen.ScreenESMTower;
import ballistix.common.inventory.container.ContainerESMTower;
import ballistix.common.tile.TileESMTower;
import ballistix.prefab.screen.ScreenComponentFireControlRadar;
import ballistix.prefab.utils.BallistixTextUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.ScreenComponentVerticalSlider;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;

public class WrapperESMTowerDetections {
    private final ScreenESMTower screen;
    private ScreenComponentFireControlRadar[] frequencies = new ScreenComponentFireControlRadar[5];
    private int topRowIndex = 0;
    private int lastRowCount = 0;
    private static final int BUTTON_COUNT = 5;

    public WrapperESMTowerDetections(ScreenESMTower screen, int x, int y) {
        int i;
        this.screen = screen;
        screen.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(x + 25, y + 30, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("esmtower.detectedfirecontrolradars", new Object[0])));
        int butOffX = 25;
        int butOffY = 40;
        for (i = 0; i < 5; ++i) {
            this.frequencies[i] = new ScreenComponentFireControlRadar(x + butOffX, y + butOffY + 24 * i, 135, 24);
        }
        for (i = 0; i < 5; ++i) {
            screen.addComponent((AbstractScreenComponent)this.frequencies[i]);
        }
    }

    public void tick() {
        TileESMTower tile = (TileESMTower)((ContainerESMTower)this.screen.m_6262_()).getSafeHost();
        if (tile == null) {
            return;
        }
        List frequencyList = (List)tile.fireControlRadars.getValue();
        this.lastRowCount = frequencyList.size();
        for (int i = 0; i < 5; ++i) {
            ScreenComponentFireControlRadar button = this.frequencies[i];
            int index = this.topRowIndex + i;
            if (index < frequencyList.size()) {
                button.setBlockPos((BlockPos)frequencyList.get(index));
                continue;
            }
            button.setBlockPos(null);
        }
        ScreenComponentVerticalSlider slider = this.screen.slider;
        if (this.lastRowCount > 5) {
            slider.updateActive(true);
            if (!slider.isSliderHeld()) {
                int moveRoom = this.screen.slider.height - 15 - 2;
                double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                slider.setSliderYOffset((int)((double)moveRoom * moved));
            }
        } else {
            slider.updateActive(false);
            slider.setSliderYOffset(0);
            this.topRowIndex = 0;
        }
    }

    public void handleMouseScroll(int dir) {
        if (Screen.m_96637_()) {
            dir *= 4;
        }
        int lastRowIndex = this.lastRowCount - 1;
        if (this.lastRowCount > 5) {
            if (this.topRowIndex >= this.lastRowCount) {
                this.topRowIndex = lastRowIndex - 4;
            }
            this.topRowIndex = Mth.m_14045_((int)(this.topRowIndex += dir), (int)0, (int)(lastRowIndex - 4));
        } else {
            this.topRowIndex = 0;
        }
    }

    public Consumer<Integer> getSliderClickedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.slider;
            if (slider.isSliderActive()) {
                int sliderY = slider.yLocation;
                int sliderHeight = slider.height;
                int mouseHeight = mouseY - sliderY;
                if (mouseHeight >= sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else if (mouseHeight <= 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else {
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                    int moveRoom = slider.height - 15 - 2;
                    double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                    slider.setSliderYOffset((int)((double)moveRoom * moved));
                }
            }
        };
    }

    public Consumer<Integer> getSliderDraggedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.slider;
            if (slider.isSliderActive()) {
                int sliderY = slider.yLocation;
                int sliderHeight = slider.height;
                if (mouseY <= sliderY + 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else if (mouseY >= sliderY + sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else {
                    int mouseHeight = mouseY - sliderY;
                    slider.setSliderYOffset(mouseHeight);
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                }
            }
        };
    }
}

