/*
 * Decompiled with CFR 0.152.
 */
package ballistix.prefab.screen;

import ballistix.api.radar.IDetected;
import ballistix.client.screen.ScreenSearchRadar;
import ballistix.common.inventory.container.ContainerSearchRadar;
import ballistix.common.tile.radar.TileSearchRadar;
import ballistix.prefab.screen.ScreenComponentDetection;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import voltaic.prefab.screen.component.types.ScreenComponentVerticalSlider;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;

public class WrapperSearchRadarDetections {
    private final ScreenSearchRadar screen;
    private ScreenComponentDetection[] detections = new ScreenComponentDetection[5];
    private int topRowIndex = 0;
    private int lastRowCount = 0;
    private static final int BUTTON_COUNT = 5;

    public WrapperSearchRadarDetections(ScreenSearchRadar screen, int x, int y) {
        int i;
        this.screen = screen;
        int butOffX = 25;
        int butOffY = 20;
        for (i = 0; i < 5; ++i) {
            this.detections[i] = new ScreenComponentDetection(x + butOffX, y + butOffY + 26 * i, 140, 26);
        }
        for (i = 0; i < 5; ++i) {
            screen.addComponent((AbstractScreenComponent)this.detections[i]);
        }
    }

    public void tick() {
        TileSearchRadar tile = (TileSearchRadar)((ContainerSearchRadar)this.screen.m_6262_()).getSafeHost();
        if (tile == null) {
            return;
        }
        ArrayList<IDetected.Detected> frequencyList = new ArrayList<IDetected.Detected>(tile.detections);
        this.lastRowCount = frequencyList.size();
        for (int i = 0; i < 5; ++i) {
            ScreenComponentDetection button = this.detections[i];
            int index = this.topRowIndex + i;
            if (index < frequencyList.size()) {
                button.setDetection((IDetected.Detected)frequencyList.get(index));
                continue;
            }
            button.setDetection(null);
        }
        ScreenComponentVerticalSlider slider = this.screen.detectionsSlider;
        if (this.lastRowCount > 5) {
            slider.updateActive(true);
            if (!slider.isSliderHeld()) {
                int moveRoom = this.screen.detectionsSlider.height - 15 - 2;
                double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                slider.setSliderYOffset((int)((double)moveRoom * moved));
            }
        } else {
            slider.updateActive(false);
            slider.setSliderYOffset(0);
            this.topRowIndex = 0;
        }
    }

    public void handleMouseScroll(int dir) {
        if (Screen.m_96637_()) {
            dir *= 4;
        }
        int lastRowIndex = this.lastRowCount - 1;
        if (this.lastRowCount > 5) {
            if (this.topRowIndex >= this.lastRowCount) {
                this.topRowIndex = lastRowIndex - 4;
            }
            this.topRowIndex = Mth.m_14045_((int)(this.topRowIndex += dir), (int)0, (int)(lastRowIndex - 4));
        } else {
            this.topRowIndex = 0;
        }
    }

    public Consumer<Integer> getSliderClickedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.detectionsSlider;
            if (slider.isSliderActive()) {
                int sliderY = slider.yLocation;
                int sliderHeight = slider.height;
                int mouseHeight = mouseY - sliderY;
                if (mouseHeight >= sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else if (mouseHeight <= 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else {
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                    int moveRoom = slider.height - 15 - 2;
                    double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                    slider.setSliderYOffset((int)((double)moveRoom * moved));
                }
            }
        };
    }

    public Consumer<Integer> getSliderDraggedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.detectionsSlider;
            if (slider.isSliderActive()) {
                int sliderY = slider.yLocation;
                int sliderHeight = slider.height;
                if (mouseY <= sliderY + 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else if (mouseY >= sliderY + sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else {
                    int mouseHeight = mouseY - sliderY;
                    slider.setSliderYOffset(mouseHeight);
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                }
            }
        };
    }

    public void updateVisibility(boolean show) {
        for (ScreenComponentDetection component : this.detections) {
            component.setVisible(show);
        }
    }
}

