/*
 * Decompiled with CFR 0.152.
 */
package ballistix.prefab.utils;

import ballistix.client.particle.ParticleOptionsShockwave;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import voltaic.Voltaic;

public class ParticleUtilities {
    public static void spawnParticleRing(ParticleOptions particle, double centerX, double centerY, double centerZ, int count, double initialSpeed, boolean shouldRandomize) {
        float rad = 0.0f;
        while ((double)rad < 6.2831854820251465) {
            double x = (double)Mth.m_14089_((float)rad) * (shouldRandomize ? Voltaic.RANDOM.nextDouble() * 0.05 + 1.0 : 1.0) * initialSpeed;
            double z = (double)Mth.m_14031_((float)rad) * (shouldRandomize ? Voltaic.RANDOM.nextDouble() * 0.05 + 1.0 : 1.0) * initialSpeed;
            Minecraft.m_91087_().f_91061_.m_107370_(particle, centerX, centerY, centerZ, x, 0.0, z);
            rad += (float)Math.PI * 2 / (float)count;
        }
    }

    public static void spawnParticleSphere(ParticleOptions particle, double centerX, double centerY, double centerZ, int count, double thetamin, double thetamax, double initialSpeed, boolean shouldRandomize) {
        double latMinRad = Math.toRadians(thetamin);
        double latMaxRad = Math.toRadians(thetamax);
        double sinLatMin = Math.sin(latMinRad);
        double sinLatMax = Math.sin(latMaxRad);
        for (int i = 0; i < count; ++i) {
            double u = Math.random();
            double v = Math.random();
            double cosTheta = sinLatMin + u * (sinLatMax - sinLatMin);
            double theta = Math.acos(cosTheta);
            double phi = Math.PI * 2 * v;
            double theta_random = theta * (1.0 + Voltaic.RANDOM.nextDouble() * 0.15);
            double phi_random = phi * (1.0 + Voltaic.RANDOM.nextDouble() * 0.15);
            double sinTheta = Math.sin(theta_random);
            double x = sinTheta * Math.cos(phi_random) * (shouldRandomize ? Voltaic.RANDOM.nextDouble() : 1.0) * initialSpeed;
            double z = sinTheta * Math.sin(phi_random) * (shouldRandomize ? Voltaic.RANDOM.nextDouble() : 1.0) * initialSpeed;
            double y = Math.cos(theta_random) * (shouldRandomize ? Voltaic.RANDOM.nextDouble() : 1.0) * initialSpeed;
            Minecraft.m_91087_().f_91061_.m_107370_(particle, centerX, centerY, centerZ, x, y, z);
        }
    }

    public static double progressGroundShockwave(Level world, double x, double z, double progress, double spawnSize, double endSize, double chance) {
        if (progress > 1.0) {
            return endSize;
        }
        int r = (int)(spawnSize + (endSize - spawnSize) * progress);
        for (double i = 0.0; i < 360.0; i += 360.0 / (Math.PI * 2 * (double)r) * (0.5 + Voltaic.RANDOM.nextDouble())) {
            if (!(Voltaic.RANDOM.nextDouble() < chance)) continue;
            double angle = Math.toRadians(i);
            double dirX = Math.cos(angle);
            double dirZ = Math.sin(angle);
            int rx = (int)(x + (double)r * dirX);
            int rz = (int)(z + (double)r * dirZ);
            int ry = world.m_6924_(Heightmap.Types.WORLD_SURFACE, rx, rz);
            int life = 15;
            if (life <= 0) continue;
            Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)new ParticleOptionsShockwave().setParameters(1.0f, 1.0f, 1.0f, (float)(1.0 - progress), 1.3f, life, false, 1.0), (double)rx + 1.5, (double)ry, (double)rz + 0.5, 0.0, 0.0, 0.0);
        }
        return r;
    }
}

