/*
 * Decompiled with CFR 0.152.
 */
package ballistix.api.capability;

import ballistix.registers.BallistixCapabilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilitySiloRegistry
implements ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<CapabilitySiloRegistry> lazyOptional = LazyOptional.of(() -> this);
    private HashMap<Integer, HashSet<BlockPos>> siloMap = new HashMap();

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == BallistixCapabilities.SILO_REGISTRY) {
            return this.lazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128408_("frequencies", new ArrayList<Integer>(this.siloMap.keySet()));
        this.siloMap.forEach((key, value) -> {
            CompoundTag posTag = new CompoundTag();
            ArrayList silos = new ArrayList(value);
            posTag.m_128405_("size", silos.size());
            for (int i = 0; i < silos.size(); ++i) {
                posTag.m_128365_("blockpos" + i, (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)silos.get(i))));
            }
            tag.m_128365_("frequencytag" + key, (Tag)posTag);
        });
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        int[] frequencies;
        if (nbt == null) {
            return;
        }
        for (int freq : frequencies = nbt.m_128465_("frequencies")) {
            HashSet<BlockPos> poses = this.siloMap.getOrDefault(freq, new HashSet());
            CompoundTag posTag = nbt.m_128469_("frequencytag" + freq);
            int size = posTag.m_128451_("size");
            for (int i = 0; i < size; ++i) {
                poses.add(NbtUtils.m_129239_((CompoundTag)posTag.m_128469_("blockpos" + i)));
            }
            this.siloMap.put(freq, poses);
        }
    }

    public void addSilo(int freq, BlockPos silo) {
        HashSet<BlockPos> set = this.siloMap.getOrDefault(freq, new HashSet());
        set.add(silo);
        this.siloMap.put(freq, set);
    }

    public void removeSilo(int freq, BlockPos silo) {
        HashSet set = this.siloMap.getOrDefault(freq, new HashSet());
        set.remove(silo);
        this.siloMap.put(freq, set);
    }

    public HashSet<BlockPos> getSilosForFrequency(int freq) {
        return this.siloMap.getOrDefault(freq, new HashSet());
    }
}

