/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.particle;

import ballistix.client.particle.ParticleOptionsBlastSmoke;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;

public class ParticleBlastSmoke
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private boolean burning;
    private int burningTime;
    private double friction = 0.96f;
    private float startRed = 1.0f;
    private float startGreen = 0.7f;
    private float startBlue = 0.2f;
    private float endRed = 0.6f;
    private float endGreen = 0.2f;
    private float endBlue = 0.2f;
    private float endGray = 0.325f;
    private float startQuadSize;

    public static double smoothStep(double u) {
        if (u < 0.0) {
            u = 0.0;
        }
        if (u > 1.0) {
            u = 1.0;
        }
        return Math.pow((double)(1.0f - Mth.m_14089_((float)((float)(3.1415927410125732 * u)))) / 2.0, 5.0);
    }

    public static float smoothTransition(float time, float x, float y, float z, int t1, int t2) {
        if (time <= 0.0f) {
            return x;
        }
        if (time >= (float)(t1 + t2)) {
            return z;
        }
        if (time <= (float)t1) {
            double u = (double)time / (double)t1;
            double s = ParticleBlastSmoke.smoothStep(u);
            return (float)((double)x + (double)(y - x) * s);
        }
        double u = (double)(time - (float)t1) / (double)t2;
        double s = ParticleBlastSmoke.smoothStep(u);
        return (float)((double)y + (double)(z - y) * s);
    }

    public ParticleBlastSmoke(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ParticleOptionsBlastSmoke options, SpriteSet set) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_107226_ = options.gravity;
        this.f_172259_ = true;
        this.burningTime = options.burningTime;
        this.sprites = set;
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.f_107227_ = options.r;
        this.f_107228_ = options.g;
        this.f_107229_ = options.b;
        this.f_107663_ = options.scale;
        this.startQuadSize = options.scale;
        this.f_107225_ = options.lifetime;
        this.m_108337_(this.sprites.m_213979_(level.f_46441_));
        this.f_107219_ = options.hasPhysics;
        this.burning = options.burning;
        this.friction = options.friction;
        double brightnessRandom = 0.2 * level.f_46441_.m_188500_();
        this.burningTime = (int)((double)this.burningTime * (0.9 + brightnessRandom));
        this.startRed = (float)((double)this.startRed * (0.8 + brightnessRandom));
        this.startGreen = (float)((double)this.startGreen * (0.8 + brightnessRandom));
        this.startBlue = (float)((double)this.startBlue * (0.8 + brightnessRandom));
        this.endRed = (float)((double)this.endRed * (0.8 + brightnessRandom));
        this.endGreen = (float)((double)this.endGreen * (0.8 + brightnessRandom));
        this.endBlue = (float)((double)this.endBlue * (0.8 + brightnessRandom));
        this.f_107227_ = (float)((double)this.f_107227_ * (0.4 + brightnessRandom));
        this.f_107228_ = (float)((double)this.f_107228_ * (0.4 + brightnessRandom));
        this.f_107229_ = (float)((double)this.f_107229_ * (0.4 + brightnessRandom));
        this.endGray = (float)((double)this.endGray * (0.8 + brightnessRandom));
        this.f_107226_ = (float)((double)this.f_107226_ * (this.burning ? 0.75 + level.f_46441_.m_188500_() * 0.5 : 1.5 * level.f_46441_.m_188500_()));
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107215_ *= this.friction;
        this.f_107216_ *= this.friction;
        this.f_107217_ *= this.friction;
        super.m_5989_();
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float lifeProgress = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        if (lifeProgress <= 1.0f && lifeProgress >= 0.0f) {
            if (this.burning) {
                int orangeLast = (int)((double)this.burningTime / 1.4);
                this.f_107227_ = ParticleBlastSmoke.smoothTransition((float)this.f_107224_ + partialTicks, this.startRed, this.endRed, this.endGray, orangeLast, this.burningTime - orangeLast);
                this.f_107228_ = ParticleBlastSmoke.smoothTransition((float)this.f_107224_ + partialTicks, this.startGreen, this.endGreen, this.endGray, orangeLast, this.burningTime - orangeLast);
                this.f_107229_ = ParticleBlastSmoke.smoothTransition((float)this.f_107224_ + partialTicks, this.startBlue, this.endBlue, this.endGray, orangeLast, this.burningTime - orangeLast);
            }
            this.f_107663_ = this.startQuadSize * Mth.m_14089_((float)((float)(1.5707963705062866 * Math.pow(1.0f - lifeProgress - 1.0f, 5.0))));
        }
        super.m_5744_(buffer, renderInfo, partialTicks);
    }

    public static class Factory
    implements ParticleProvider<ParticleOptionsBlastSmoke>,
    ParticleEngine.SpriteParticleRegistration<ParticleOptionsBlastSmoke> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(ParticleOptionsBlastSmoke type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleBlastSmoke(level, x, y, z, xSpeed, ySpeed, zSpeed, type, this.sprites);
        }

        public ParticleProvider<ParticleOptionsBlastSmoke> m_107419_(SpriteSet sprites) {
            return new Factory(sprites);
        }
    }
}

