/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.particle;

import ballistix.registers.BallistixParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class ParticleOptionsShockwave
extends ParticleType<ParticleOptionsShockwave>
implements ParticleOptions {
    public static final Codec<ParticleOptionsShockwave> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(instance0 -> Float.valueOf(instance0.r)), (App)Codec.FLOAT.fieldOf("g").forGetter(instance0 -> Float.valueOf(instance0.g)), (App)Codec.FLOAT.fieldOf("b").forGetter(instance0 -> Float.valueOf(instance0.b)), (App)Codec.FLOAT.fieldOf("a").forGetter(instance0 -> Float.valueOf(instance0.b)), (App)Codec.FLOAT.fieldOf("scale").forGetter(instance0 -> Float.valueOf(instance0.scale)), (App)Codec.INT.fieldOf("lifetime").forGetter(instance0 -> instance0.lifetime), (App)Codec.BOOL.fieldOf("physics").forGetter(instance0 -> instance0.hasPhysics), (App)Codec.DOUBLE.fieldOf("friction").forGetter(instance0 -> instance0.friction)).apply((Applicative)instance, (r, g, b, a, scale, lifetime, physics, friction) -> new ParticleOptionsShockwave().setParameters(r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue(), scale.floatValue(), (int)lifetime, (boolean)physics, (double)friction)));
    public static final ParticleOptions.Deserializer<ParticleOptionsShockwave> DESERIALIZER = new ParticleOptions.Deserializer<ParticleOptionsShockwave>(){

        public ParticleOptionsShockwave fromCommand(ParticleType<ParticleOptionsShockwave> type, StringReader reader) throws CommandSyntaxException {
            ParticleOptionsShockwave particle = new ParticleOptionsShockwave();
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float a = reader.readFloat();
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            boolean physics = reader.readBoolean();
            reader.expect(' ');
            double friction = reader.readDouble();
            return particle.setParameters(r, g, b, a, scale, lifetime, physics, friction);
        }

        public ParticleOptionsShockwave fromNetwork(ParticleType<ParticleOptionsShockwave> type, FriendlyByteBuf buffer) {
            return new ParticleOptionsShockwave().setParameters(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readBoolean(), buffer.readDouble());
        }
    };
    public float r;
    public float g;
    public float b;
    public float a;
    public float scale;
    public int lifetime;
    public boolean hasPhysics;
    public double friction;

    public ParticleOptionsShockwave() {
        super(false, DESERIALIZER);
    }

    public ParticleOptionsShockwave setParameters(float r, float g, float b, float a, float scale, int lifetime, boolean physics, double friction) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.scale = scale;
        this.lifetime = lifetime;
        this.hasPhysics = physics;
        this.friction = friction;
        return this;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)BallistixParticles.PARTICLE_SHOCKWAVE.get();
    }

    public Codec<ParticleOptionsShockwave> m_7652_() {
        return CODEC;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.r);
        buffer.writeFloat(this.g);
        buffer.writeFloat(this.b);
        buffer.writeFloat(this.a);
        buffer.writeFloat(this.scale);
        buffer.writeInt(this.lifetime);
        buffer.writeBoolean(this.hasPhysics);
        buffer.writeDouble(this.friction);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()).toString() + ", r: " + this.r + ", g: " + this.g + ", b: " + this.b + ", a: " + this.a + ", scale: " + this.scale + ", lifetime: " + this.lifetime + ", physics: " + this.hasPhysics + ", friction: " + this.friction;
    }
}

