/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.particle;

import ballistix.client.particle.ParticleOptionsShockwave;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;

public class ParticleShockwave
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private double friction = 0.96f;
    private float startQuadSize;
    private float startAlpha;

    public ParticleShockwave(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ParticleOptionsShockwave type, SpriteSet set) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_172259_ = true;
        this.sprites = set;
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.f_107227_ = type.r;
        this.f_107228_ = type.g;
        this.f_107229_ = type.b;
        this.f_107230_ = 0.0f;
        this.startAlpha = type.a;
        this.f_107663_ = type.scale;
        this.startQuadSize = type.scale;
        this.f_107225_ = type.lifetime;
        this.m_108339_(this.sprites);
        this.f_107219_ = type.hasPhysics;
        this.friction = type.friction;
        double brightnessRandom = 0.4 * level.f_46441_.m_188500_();
        this.f_107227_ = (float)((double)this.f_107227_ * (0.6 + brightnessRandom));
        this.f_107228_ = (float)((double)this.f_107228_ * (0.6 + brightnessRandom));
        this.f_107229_ = (float)((double)this.f_107229_ * (0.6 + brightnessRandom));
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        this.f_107215_ *= this.friction;
        this.f_107216_ *= this.friction;
        this.f_107217_ *= this.friction;
        super.m_5989_();
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        super.m_5744_(buffer, renderInfo, partialTicks);
        float lifeProgress = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        if (lifeProgress <= 1.0f && lifeProgress >= 0.0f) {
            this.f_107663_ = this.startQuadSize * Mth.m_14089_((float)((float)(6.2831854820251465 * Math.pow((double)lifeProgress - 0.5, 2.0))));
            this.f_107230_ = this.startAlpha * Mth.m_14089_((float)((float)(6.2831854820251465 * Math.pow((double)lifeProgress - 0.5, 2.0))));
        }
    }

    public static class Factory
    implements ParticleProvider<ParticleOptionsShockwave>,
    ParticleEngine.SpriteParticleRegistration<ParticleOptionsShockwave> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(ParticleOptionsShockwave type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleShockwave(level, x, y, z, xSpeed, ySpeed, zSpeed, type, this.sprites);
        }

        public ParticleProvider<ParticleOptionsShockwave> m_107419_(SpriteSet sprites) {
            return new Factory(sprites);
        }
    }
}

