/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.render.entity;

import ballistix.client.render.entity.RenderExplosive;
import ballistix.common.entity.EntityMinecart;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import voltaic.Voltaic;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderMinecart
extends EntityRenderer<EntityMinecart> {
    private static final ResourceLocation MINECART_LOCATION = Voltaic.vanillarl((String)"textures/entity/minecart.png");
    protected final EntityModel<EntityMinecart> model;

    public RenderMinecart(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.7f;
        this.model = new MinecartModel(context.m_174023_(ModelLayers.f_171198_));
    }

    public void render(EntityMinecart entity, float yaw, float partial, PoseStack stack, MultiBufferSource source, int light) {
        BlockState blockstate;
        super.m_7392_((Entity)entity, yaw, partial, stack, source, light);
        stack.m_85836_();
        long i = (long)entity.m_19879_() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        stack.m_252880_(f, f1, f2);
        double d0 = Mth.m_14139_((double)partial, (double)entity.f_19790_, (double)entity.m_20185_());
        double d1 = Mth.m_14139_((double)partial, (double)entity.f_19791_, (double)entity.m_20186_());
        double d2 = Mth.m_14139_((double)partial, (double)entity.f_19792_, (double)entity.m_20189_());
        Vec3 vec3 = entity.m_38179_(d0, d1, d2);
        float f3 = Mth.m_14179_((float)partial, (float)entity.f_19860_, (float)entity.m_146909_());
        if (vec3 != null) {
            Vec3 vec31 = entity.m_38096_(d0, d1, d2, 0.3f);
            Vec3 vec32 = entity.m_38096_(d0, d1, d2, -0.3f);
            if (vec31 == null) {
                vec31 = vec3;
            }
            if (vec32 == null) {
                vec32 = vec3;
            }
            stack.m_85837_(vec3.f_82479_ - d0, (vec31.f_82480_ + vec32.f_82480_) / 2.0 - d1, vec3.f_82481_ - d2);
            Vec3 vec33 = vec32.m_82520_(-vec31.f_82479_, -vec31.f_82480_, -vec31.f_82481_);
            if (vec33.m_82553_() != 0.0) {
                vec33 = vec33.m_82541_();
                yaw = (float)(Math.atan2(vec33.f_82481_, vec33.f_82479_) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vec33.f_82480_) * 73.0);
            }
        }
        stack.m_85837_(0.0, 0.375, 0.0);
        stack.m_252781_(MathUtils.rotVectorQuaternionDeg((float)(180.0f - yaw), (Vector3f)MathUtils.YP));
        stack.m_252781_(MathUtils.rotVectorQuaternionDeg((float)(-f3), (Vector3f)MathUtils.ZP));
        float f5 = (float)entity.m_38176_() - partial;
        float f6 = entity.m_38169_() - partial;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            stack.m_252781_(MathUtils.rotVectorQuaternionRad((float)(Mth.m_14031_((float)f5) * f5 * f6 / 10.0f * (float)entity.m_38177_()), (Vector3f)MathUtils.XP));
        }
        int j = entity.m_38183_();
        if (entity.getExplosiveType() != null && (blockstate = entity.getExplosiveType().getExplosiveBlock().get().m_49966_()) != null && blockstate.m_60799_() != RenderShape.INVISIBLE) {
            stack.m_85836_();
            stack.m_85841_(0.75f, 0.75f, 0.75f);
            stack.m_85837_(-0.5, (double)((float)(j - 8) / 16.0f), 0.5);
            stack.m_252781_(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.YP));
            this.renderMinecartContents(entity, partial, blockstate, stack, source, light);
            stack.m_85849_();
        }
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.m_6973_((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = source.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        this.model.m_7695_(stack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
    }

    public ResourceLocation getTextureLocation(EntityMinecart entity) {
        return MINECART_LOCATION;
    }

    protected void renderMinecartContents(EntityMinecart entity, float p1, BlockState state, PoseStack stack, MultiBufferSource source, int p2) {
        int i = entity.getFuse();
        if (i > -1 && (float)i - p1 + 1.0f < 10.0f) {
            float f = 1.0f - ((float)i - p1 + 1.0f) / 10.0f;
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            stack.m_85841_(f1, f1, f1);
        }
        RenderExplosive.renderTntFlash(state, stack, source, p2, i > -1 && i / 5 % 2 == 0);
    }
}

