/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.screen;

import ballistix.common.inventory.container.ContainerLauncherControlPanelT2;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.silo.TileLauncherControlPanelT2;
import ballistix.prefab.utils.BallistixTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenLauncherControlPanelT2
extends GenericScreen<ContainerLauncherControlPanelT2> {
    private boolean needsUpdate = true;
    private final ScreenComponentEditBox xCoordField;
    private final ScreenComponentEditBox yCoordField;
    private final ScreenComponentEditBox zCoordField;

    public ScreenLauncherControlPanelT2(ContainerLauncherControlPanelT2 container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2).wattage(BallistixConstants.MISSILESILO_USAGE * 20.0));
        this.xCoordField = new ScreenComponentEditBox(10, 17, 48, 15, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(10).setResponder(this::setX).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.xCoordField);
        this.yCoordField = new ScreenComponentEditBox(10, 35, 48, 15, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(10).setResponder(this::setY).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.yCoordField);
        this.zCoordField = new ScreenComponentEditBox(10, 53, 48, 15, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(10).setResponder(this::setZ).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.zCoordField);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(60, 22, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("missilesilo.x", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(60, 40, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("missilesilo.y", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(60, 58, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("missilesilo.z", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(100, 25, 40, 40).setOnPress(button -> {
            TileLauncherControlPanelT2 silo = (TileLauncherControlPanelT2)((ContainerLauncherControlPanelT2)this.m_6262_()).getSafeHost();
            if (silo == null) {
                return;
            }
            silo.shouldLaunch.setValue((Object)true);
        }).setColor(new Color(255, 0, 0, 255)).onTooltip((graphics, component, mouseX, mouseY) -> graphics.m_280557_(this.getFontRenderer(), (Component)BallistixTextUtils.tooltip("silo.launch", new Object[0]), mouseX, mouseY)));
    }

    protected void initializeComponents() {
        super.initializeComponents();
    }

    private void setSiloTargetX(String coord) {
        if (coord.isEmpty()) {
            return;
        }
        TileLauncherControlPanelT2 silo = (TileLauncherControlPanelT2)((ContainerLauncherControlPanelT2)this.f_97732_).getSafeHost();
        if (silo == null) {
            return;
        }
        int x = ((BlockPos)silo.target.getValue()).m_123341_();
        try {
            x = Integer.parseInt(coord);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ScreenLauncherControlPanelT2.updateSiloCoords(x, ((BlockPos)silo.target.getValue()).m_123342_(), ((BlockPos)silo.target.getValue()).m_123343_(), silo);
    }

    private void setSiloTargetY(String coord) {
        if (coord.isEmpty()) {
            return;
        }
        TileLauncherControlPanelT2 silo = (TileLauncherControlPanelT2)((ContainerLauncherControlPanelT2)this.f_97732_).getSafeHost();
        if (silo == null) {
            return;
        }
        int y = ((BlockPos)silo.target.getValue()).m_123342_();
        try {
            y = Integer.parseInt(coord);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ScreenLauncherControlPanelT2.updateSiloCoords(((BlockPos)silo.target.getValue()).m_123341_(), y, ((BlockPos)silo.target.getValue()).m_123343_(), silo);
    }

    private void setSiloTargetZ(String coord) {
        if (coord.isEmpty()) {
            return;
        }
        TileLauncherControlPanelT2 silo = (TileLauncherControlPanelT2)((ContainerLauncherControlPanelT2)this.f_97732_).getSafeHost();
        if (silo == null) {
            return;
        }
        int z = ((BlockPos)silo.target.getValue()).m_123343_();
        try {
            z = Integer.parseInt(coord);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ScreenLauncherControlPanelT2.updateSiloCoords(((BlockPos)silo.target.getValue()).m_123341_(), ((BlockPos)silo.target.getValue()).m_123342_(), z, silo);
    }

    private static void updateSiloCoords(int x, int y, int z, TileLauncherControlPanelT2 silo) {
        silo.target.setValue((Object)new BlockPos(x, y, z));
    }

    private void setX(String val) {
        this.xCoordField.setFocus(true);
        this.yCoordField.setFocus(false);
        this.zCoordField.setFocus(false);
        this.setSiloTargetX(val);
    }

    private void setY(String val) {
        this.yCoordField.setFocus(true);
        this.xCoordField.setFocus(false);
        this.zCoordField.setFocus(false);
        this.setSiloTargetY(val);
    }

    private void setZ(String val) {
        this.zCoordField.setFocus(true);
        this.yCoordField.setFocus(false);
        this.xCoordField.setFocus(false);
        this.setSiloTargetZ(val);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            TileLauncherControlPanelT2 silo = (TileLauncherControlPanelT2)((ContainerLauncherControlPanelT2)this.f_97732_).getSafeHost();
            if (silo != null) {
                this.xCoordField.setValue("" + ((BlockPos)silo.target.getValue()).m_123341_());
                this.yCoordField.setValue("" + ((BlockPos)silo.target.getValue()).m_123342_());
                this.zCoordField.setValue("" + ((BlockPos)silo.target.getValue()).m_123343_());
            }
        }
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileLauncherControlPanelT2 silo = (TileLauncherControlPanelT2)((ContainerLauncherControlPanelT2)this.f_97732_).getSafeHost();
        if (silo == null) {
            return list;
        }
        ComponentElectrodynamic el = (ComponentElectrodynamic)silo.getComponent(IComponentType.Electrodynamic);
        list.add(BallistixTextUtils.tooltip("missilesilo.charge", ChatFormatter.getChatDisplayShort((double)el.getJoulesStored(), (IDisplayUnit)DisplayUnits.JOULES).m_130940_(ChatFormatting.GRAY), ChatFormatter.getChatDisplayShort((double)(BallistixConstants.MISSILESILO_USAGE * 20.0 * 3.0), (IDisplayUnit)DisplayUnits.JOULES).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(VoltaicTextUtils.gui((String)"machine.voltage", (Object[])new Object[]{ChatFormatter.getChatDisplayShort((double)el.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        return list;
    }
}

