/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.screen;

import ballistix.client.event.HandlerDetectorLines;
import ballistix.common.inventory.container.ContainerProximityDetector;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.TileProximityDetector;
import ballistix.common.tile.turret.GenericTileTurret;
import ballistix.prefab.BallistixIconTypes;
import ballistix.prefab.screen.WrapperPlayerWhitelistDetector;
import ballistix.prefab.utils.BallistixTextUtils;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.AABB;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.inventory.container.slot.item.SlotGeneric;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentFillArea;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.ScreenComponentVerticalSlider;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;

public class ScreenProximityDetector
extends GenericScreen<ContainerProximityDetector> {
    public final ScreenComponentVerticalSlider whitelistSlider;
    public final WrapperPlayerWhitelistDetector whitelistWrapper;
    private final ScreenComponentButton<?> toggleButton;
    private final ScreenComponentSimpleLabel whitelistLabel;
    private final ScreenComponentEditBox xMin;
    private final ScreenComponentEditBox xMax;
    private final ScreenComponentEditBox yMin;
    private final ScreenComponentEditBox yMax;
    private final ScreenComponentEditBox zMin;
    private final ScreenComponentEditBox zMax;
    private final ScreenComponentSimpleLabel coordFieldLabel;
    private final ScreenComponentSimpleLabel xCoordLabel;
    private final ScreenComponentSimpleLabel yCoordLabel;
    private final ScreenComponentSimpleLabel zCoordLabel;
    private final ScreenComponentSimpleLabel coordMinLabel;
    private final ScreenComponentSimpleLabel coordMaxLabel;
    private final ScreenComponentFillArea background;
    private final ScreenComponentSimpleLabel toggleLabel;
    private final ScreenComponentButton<?> toggleLines;
    private boolean needsUpdate = true;

    public ScreenProximityDetector(ContainerProximityDetector container, Inventory inv, Component title) {
        super((GenericContainer)container, inv, title);
        this.f_97731_ += 10;
        this.f_97727_ += 10;
        this.background = new ScreenComponentFillArea(10, 20, 157, 95, new Color(130, 130, 130, 255));
        this.addComponent((AbstractScreenComponent)this.background);
        this.whitelistWrapper = new WrapperPlayerWhitelistDetector(this, -25, 28, 0, 0);
        this.whitelistSlider = new ScreenComponentVerticalSlider(11, 80, 75).setClickConsumer(this.whitelistWrapper.getSliderClickedConsumer()).setDragConsumer(this.whitelistWrapper.getSliderDraggedConsumer());
        this.addComponent((AbstractScreenComponent)this.whitelistSlider);
        this.whitelistSlider.setVisible(false);
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(-25, 2).wattage(BallistixConstants.SAM_TURRET_USAGEPERTICK * 20.0));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, -25, 54).setOnPress(button -> {
            TileProximityDetector turret = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
            if (turret == null) {
                return;
            }
            int mode = (Integer)turret.entityTargetingMode.getValue();
            if (++mode >= GenericTileTurret.TargetingMode.values().length) {
                mode = 0;
            }
            turret.entityTargetingMode.setValue((Object)mode);
        }).onTooltip((graphics, but, xAxis, yAxis) -> {
            TileProximityDetector turret = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
            if (turret == null) {
                return;
            }
            ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
            tooltips.add(BallistixTextUtils.tooltip("turret.targetmode", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
            GenericTileTurret.TargetingMode mode = GenericTileTurret.TargetingMode.values()[(Integer)turret.entityTargetingMode.getValue()];
            if (mode == GenericTileTurret.TargetingMode.ONLY_PLAYERS) {
                tooltips.add(BallistixTextUtils.tooltip("turret.targetmodeplayers", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            } else if (mode == GenericTileTurret.TargetingMode.ALL) {
                tooltips.add(BallistixTextUtils.tooltip("turret.targetmodeliving", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            } else {
                tooltips.add(BallistixTextUtils.tooltip("turret.targetmodenone", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            graphics.m_280666_(this.getFontRenderer(), tooltips, xAxis, yAxis);
        }).setIcon((ITexture)BallistixIconTypes.TARGET_ONLY_PLAYERS));
        for (int i = 0; i < ((ContainerProximityDetector)this.f_97732_).f_38839_.size(); ++i) {
            ((SlotGeneric)((ContainerProximityDetector)this.f_97732_).f_38839_.get(i)).setActive(false);
        }
        this.coordFieldLabel = new ScreenComponentSimpleLabel(15, 25, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("proximitydetector.detectionrange", new Object[0]));
        this.addComponent((AbstractScreenComponent)this.coordFieldLabel);
        this.coordMinLabel = new ScreenComponentSimpleLabel(80, 40, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("proximitydetector.min", new Object[0]));
        this.addComponent((AbstractScreenComponent)this.coordMinLabel);
        this.coordMaxLabel = new ScreenComponentSimpleLabel(130, 40, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("proximitydetector.max", new Object[0]));
        this.addComponent((AbstractScreenComponent)this.coordMaxLabel);
        this.xMin = new ScreenComponentEditBox(80, 50, 20, 16, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(1).setFilter(ScreenComponentEditBox.POSITIVE_INTEGER).setResponder(this::setXMin);
        this.addEditBox(this.xMin);
        this.xMax = new ScreenComponentEditBox(130, 50, 20, 16, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(1).setFilter(ScreenComponentEditBox.POSITIVE_INTEGER).setResponder(this::setXMax);
        this.addEditBox(this.xMax);
        this.yMin = new ScreenComponentEditBox(80, 70, 20, 16, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(1).setFilter(ScreenComponentEditBox.POSITIVE_INTEGER).setResponder(this::setYMin);
        this.addEditBox(this.yMin);
        this.yMax = new ScreenComponentEditBox(130, 70, 20, 16, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(1).setFilter(ScreenComponentEditBox.POSITIVE_INTEGER).setResponder(this::setYMax);
        this.addEditBox(this.yMax);
        this.zMin = new ScreenComponentEditBox(80, 90, 20, 16, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(1).setFilter(ScreenComponentEditBox.POSITIVE_INTEGER).setResponder(this::setZMin);
        this.addEditBox(this.zMin);
        this.zMax = new ScreenComponentEditBox(130, 90, 20, 16, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(1).setFilter(ScreenComponentEditBox.POSITIVE_INTEGER).setResponder(this::setZMax);
        this.addEditBox(this.zMax);
        this.xCoordLabel = new ScreenComponentSimpleLabel(20, 55, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("proximitydetector.xcoord", new Object[0]));
        this.addComponent((AbstractScreenComponent)this.xCoordLabel);
        this.yCoordLabel = new ScreenComponentSimpleLabel(20, 75, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("proximitydetector.ycoord", new Object[0]));
        this.addComponent((AbstractScreenComponent)this.yCoordLabel);
        this.zCoordLabel = new ScreenComponentSimpleLabel(20, 95, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("proximitydetector.zcoord", new Object[0]));
        this.addComponent((AbstractScreenComponent)this.zCoordLabel);
        this.whitelistLabel = new ScreenComponentSimpleLabel(13, 126, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("radar.frequencywhitelist.mode", new Object[0]));
        this.addComponent((AbstractScreenComponent)this.whitelistLabel);
        this.toggleButton = new ScreenComponentButton(92, 120, 70, 20).setOnPress(button -> {
            TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.m_6262_()).getSafeHost();
            if (detector == null) {
                return;
            }
            detector.usingWhitelist.setValue((Object)((Boolean)detector.usingWhitelist.getValue() == false ? 1 : 0));
        }).setLabel(() -> {
            TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.m_6262_()).getSafeHost();
            if (detector == null) {
                return Component.m_237119_();
            }
            return (Boolean)detector.usingWhitelist.getValue() != false ? BallistixTextUtils.gui("radar.frequencywhitelist.enabled", new Object[0]) : BallistixTextUtils.gui("radar.frequencywhitelist.disabled", new Object[0]);
        });
        this.addComponent((AbstractScreenComponent)this.toggleButton);
        this.toggleLabel = new ScreenComponentSimpleLabel(13, 151, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("proximitydetector.detectionfield", new Object[0]));
        this.addComponent((AbstractScreenComponent)this.toggleLabel);
        this.toggleLines = new ScreenComponentButton(92, 145, 70, 20).setLabel(() -> {
            TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
            if (detector != null) {
                return HandlerDetectorLines.containsLines(detector.m_58899_()) ? BallistixTextUtils.gui("proximitydetector.hidefield", new Object[0]) : BallistixTextUtils.gui("proximitydetector.showfield", new Object[0]);
            }
            return Component.m_237119_();
        }).setOnPress(button -> {
            TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
            if (detector != null) {
                BlockPos pos = detector.m_58899_();
                if (HandlerDetectorLines.containsLines(pos)) {
                    HandlerDetectorLines.removeLines(pos);
                } else {
                    AABB box = new AABB(detector.m_58899_().m_121955_((Vec3i)((BlockPos)detector.minCorner.getValue()).m_142393_(-1)), detector.m_58899_().m_121955_((Vec3i)detector.maxCorner.getValue()).m_7918_(1, 1, 1));
                    HandlerDetectorLines.addLines(detector.m_58899_(), box);
                }
            }
        });
        this.addComponent((AbstractScreenComponent)this.toggleLines);
    }

    public void updateVisibility(boolean show) {
        this.toggleButton.setVisible(show);
        this.whitelistLabel.setVisible(show);
        this.xMin.setVisible(show);
        this.xMax.setVisible(show);
        this.yMin.setVisible(show);
        this.yMax.setVisible(show);
        this.zMin.setVisible(show);
        this.zMax.setVisible(show);
        this.xCoordLabel.setVisible(show);
        this.yCoordLabel.setVisible(show);
        this.zCoordLabel.setVisible(show);
        this.coordMaxLabel.setVisible(show);
        this.coordMinLabel.setVisible(show);
        this.coordFieldLabel.setVisible(show);
        this.background.setVisible(show);
        this.toggleLines.setVisible(show);
        this.toggleLabel.setVisible(show);
    }

    protected void initializeComponents() {
        super.initializeComponents();
        this.playerInvLabel.setVisible(false);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.whitelistWrapper.tick();
        TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
        if (detector != null && HandlerDetectorLines.containsLines(detector.m_58899_())) {
            HandlerDetectorLines.removeLines(detector.m_58899_());
            AABB box = new AABB(detector.m_58899_().m_121955_((Vec3i)((BlockPos)detector.minCorner.getValue()).m_142393_(-1)), detector.m_58899_().m_121955_((Vec3i)detector.maxCorner.getValue()).m_7918_(1, 1, 1));
            HandlerDetectorLines.addLines(detector.m_58899_(), box);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.whitelistWrapper != null) {
            if (scrollY > 0.0) {
                this.whitelistWrapper.handleMouseScroll(-1);
            } else if (scrollY < 0.0) {
                this.whitelistWrapper.handleMouseScroll(1);
            }
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.whitelistSlider != null && this.whitelistSlider.isVisible()) {
            this.whitelistSlider.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.whitelistSlider != null && this.whitelistSlider.isVisible()) {
            this.whitelistSlider.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.whitelistSlider.isVisible()) {
            return this.whitelistSlider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.whitelistWrapper.addEditBox.isVisible() && this.whitelistWrapper.addEditBox.m_93696_()) {
            return false;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private void setXMin(String val) {
        this.xMin.setFocus(true);
        this.xMax.setFocus(false);
        this.yMin.setFocus(false);
        this.yMax.setFocus(false);
        this.zMin.setFocus(false);
        this.zMax.setFocus(false);
        this.handleXMin(val);
    }

    private void setXMax(String val) {
        this.xMin.setFocus(false);
        this.xMax.setFocus(true);
        this.yMin.setFocus(false);
        this.yMax.setFocus(false);
        this.zMin.setFocus(false);
        this.zMax.setFocus(false);
        this.handleXMax(val);
    }

    private void setYMin(String val) {
        this.xMin.setFocus(false);
        this.xMax.setFocus(false);
        this.yMin.setFocus(true);
        this.yMax.setFocus(false);
        this.zMin.setFocus(false);
        this.zMax.setFocus(false);
        this.handleYMin(val);
    }

    private void setYMax(String val) {
        this.xMin.setFocus(false);
        this.xMax.setFocus(false);
        this.yMin.setFocus(false);
        this.yMax.setFocus(true);
        this.zMin.setFocus(false);
        this.zMax.setFocus(false);
        this.handleYMax(val);
    }

    private void setZMin(String val) {
        this.xMin.setFocus(false);
        this.xMax.setFocus(false);
        this.yMin.setFocus(false);
        this.yMax.setFocus(false);
        this.zMin.setFocus(true);
        this.zMax.setFocus(false);
        this.handleZMin(val);
    }

    private void setZMax(String val) {
        this.xMin.setFocus(false);
        this.xMax.setFocus(false);
        this.yMin.setFocus(false);
        this.yMax.setFocus(false);
        this.zMin.setFocus(false);
        this.zMax.setFocus(true);
        this.handleZMax(val);
    }

    private void handleXMin(String val) {
        if (val.isEmpty()) {
            return;
        }
        Integer xCoord = 0;
        try {
            xCoord = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
        if (detector == null) {
            return;
        }
        detector.minCorner.setValue((Object)new BlockPos(xCoord.intValue(), ((BlockPos)detector.minCorner.getValue()).m_123342_(), ((BlockPos)detector.minCorner.getValue()).m_123343_()));
    }

    private void handleXMax(String val) {
        if (val.isEmpty()) {
            return;
        }
        Integer xCoord = 0;
        try {
            xCoord = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
        if (detector == null) {
            return;
        }
        detector.maxCorner.setValue((Object)new BlockPos(xCoord.intValue(), ((BlockPos)detector.maxCorner.getValue()).m_123342_(), ((BlockPos)detector.maxCorner.getValue()).m_123343_()));
    }

    private void handleYMin(String val) {
        if (val.isEmpty()) {
            return;
        }
        Integer yCoord = 0;
        try {
            yCoord = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
        if (detector == null) {
            return;
        }
        detector.minCorner.setValue((Object)new BlockPos(((BlockPos)detector.minCorner.getValue()).m_123341_(), yCoord.intValue(), ((BlockPos)detector.minCorner.getValue()).m_123343_()));
    }

    private void handleYMax(String val) {
        if (val.isEmpty()) {
            return;
        }
        Integer yCoord = 0;
        try {
            yCoord = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
        if (detector == null) {
            return;
        }
        detector.maxCorner.setValue((Object)new BlockPos(((BlockPos)detector.maxCorner.getValue()).m_123341_(), yCoord.intValue(), ((BlockPos)detector.maxCorner.getValue()).m_123343_()));
    }

    private void handleZMin(String val) {
        if (val.isEmpty()) {
            return;
        }
        Integer zCoord = 0;
        try {
            zCoord = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
        if (detector == null) {
            return;
        }
        detector.minCorner.setValue((Object)new BlockPos(((BlockPos)detector.minCorner.getValue()).m_123341_(), ((BlockPos)detector.minCorner.getValue()).m_123342_(), zCoord.intValue()));
    }

    private void handleZMax(String val) {
        if (val.isEmpty()) {
            return;
        }
        Integer zCoord = 0;
        try {
            zCoord = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
        if (detector == null) {
            return;
        }
        detector.maxCorner.setValue((Object)new BlockPos(((BlockPos)detector.maxCorner.getValue()).m_123341_(), ((BlockPos)detector.maxCorner.getValue()).m_123342_(), zCoord.intValue()));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            TileProximityDetector detector = (TileProximityDetector)((ContainerProximityDetector)this.f_97732_).getSafeHost();
            if (detector != null) {
                this.xMin.setValue("" + ((BlockPos)detector.minCorner.getValue()).m_123341_());
                this.xMax.setValue("" + ((BlockPos)detector.maxCorner.getValue()).m_123341_());
                this.yMin.setValue("" + ((BlockPos)detector.minCorner.getValue()).m_123342_());
                this.yMax.setValue("" + ((BlockPos)detector.maxCorner.getValue()).m_123342_());
                this.zMin.setValue("" + ((BlockPos)detector.minCorner.getValue()).m_123343_());
                this.zMax.setValue("" + ((BlockPos)detector.maxCorner.getValue()).m_123343_());
            }
        }
    }
}

