/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier1;

import ballistix.api.blast.IHasCustomRender;
import ballistix.common.blast.util.Blast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.settings.BallistixConstants;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlastIncendiary
extends Blast
implements IHasCustomRender {
    public BlastIncendiary(Level world, BlockPos position, @Nullable Entity owner, @Nullable Entity blastEntity) {
        super(world, position, owner, blastEntity);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.world.m_5594_(null, this.position, SoundEvents.f_11913_, SoundSource.BLOCKS, 25.0f, 1.0f);
        }
    }

    @Override
    public boolean doExplode(int callCount) {
        super.doExplode(callCount);
        this.hasStarted = true;
        if (this.world.f_46443_) {
            this.produceParticles();
            return true;
        }
        int radius = (int)BallistixConstants.EXPLOSIVE_INCENDIARY_RADIUS;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    int zActual;
                    int yActual;
                    int xActual;
                    BlockPos pos;
                    boolean add;
                    if (x * x + y * y + z * z >= radius * radius || !(add = BlastIncendiary.canHarmBlock(pos = new BlockPos(xActual = this.position.m_123341_() + x, yActual = this.position.m_123342_() + y, zActual = this.position.m_123343_() + z))) || !this.world.m_46859_(pos) || this.world.m_46859_(pos.m_121945_(Direction.DOWN))) continue;
                    this.world.m_46597_(pos, Blocks.f_50083_.m_49966_());
                }
            }
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void produceParticles() {
    }

    @Override
    public SubtypeBlast getBlastType() {
        return SubtypeBlast.incendiary;
    }
}

