/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier1;

import ballistix.api.blast.IBlast;
import ballistix.common.blast.util.BlastLasting;
import ballistix.common.blast.util.thread.ThreadSimpleBlast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.settings.BallistixConstants;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BlastInfestive
extends BlastLasting {
    private ThreadSimpleBlast thread;
    private Iterator<BlockPos> iterator;
    private int pertick = -1;

    public BlastInfestive(Level world, BlockPos position, @Nullable Entity owner, @Nullable Entity blastEntity) {
        super(world, position, owner, blastEntity);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.thread = new ThreadSimpleBlast(this.world, this.position, (int)BallistixConstants.EXPLOSIVE_INFESTIVE_RADIUS, 2.1474836E9f, null, this.getBlastType().id());
            this.thread.start();
            this.world.m_5594_(null, this.position, SoundEvents.f_11913_, SoundSource.BLOCKS, 25.0f, 1.0f);
            this.world.m_5594_(null, this.position, SoundEvents.f_11921_, SoundSource.BLOCKS, 25.0f, 1.0f);
        }
    }

    @Override
    public boolean doExplode(int callCount) {
        this.hasStarted = true;
        super.doExplode(callCount);
        if (this.thread == null) {
            return !this.world.f_46443_;
        }
        if (this.world.f_46443_ || !this.thread.isComplete) {
            return false;
        }
        if (this.pertick == -1) {
            this.hasStarted = true;
            this.pertick = (int)((double)this.thread.results.size() * 1.5 / BallistixConstants.EXPLOSIVE_INFESTIVE_DURATION + 1.0);
            this.iterator = this.thread.results.iterator();
        }
        int finished = this.pertick;
        while (this.iterator.hasNext() && finished-- >= 0) {
            boolean shouldRepulse;
            BlockPos p = new BlockPos((Vec3i)this.iterator.next()).m_121955_((Vec3i)this.position);
            BlockState state = this.world.m_8055_(p);
            if (state.m_60795_() || !InfestedBlock.m_54195_((BlockState)state) || !(shouldRepulse = BlastInfestive.canHarmBlock(p))) continue;
            this.world.m_46597_(p, InfestedBlock.m_153430_((BlockState)state));
        }
        return !this.iterator.hasNext();
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public boolean isDoneCalculating() {
        if (this.world.f_46443_) {
            return this.shouldRenderCustomClient;
        }
        return this.thread == null || this.thread.isComplete;
    }

    @Override
    public IBlast getBlastType() {
        return SubtypeBlast.infestive;
    }
}

