/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier2;

import ballistix.api.blast.IBlast;
import ballistix.common.blast.util.BlastLasting;
import ballistix.common.blast.util.thread.ThreadSimpleBlast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.entity.EntityBallistixFallingBlock;
import ballistix.common.settings.BallistixConstants;
import ballistix.registers.BallistixSounds;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlastSonic
extends BlastLasting {
    private ThreadSimpleBlast thread;
    private Iterator<BlockPos> iterator;
    private int pertick = -1;

    public BlastSonic(Level world, BlockPos position, @Nullable Entity owner, @Nullable Entity blastEntity) {
        super(world, position, owner, blastEntity);
    }

    @Override
    public IBlast getBlastType() {
        return SubtypeBlast.sonic;
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.thread = new ThreadSimpleBlast(this.world, this.position, (int)BallistixConstants.EXPLOSIVE_SONIC_RADIUS, 2.1474836E9f, null, this.getBlastType().id(), true);
            this.thread.start();
            this.world.m_5594_(null, this.position, (SoundEvent)BallistixSounds.SOUND_SONICEXPLOSION.get(), SoundSource.BLOCKS, 25.0f, 1.0f);
        }
    }

    @Override
    public boolean doExplode(int callCount) {
        this.hasStarted = true;
        super.doExplode(callCount);
        if (this.thread == null) {
            return !this.world.f_46443_;
        }
        if (this.world.f_46443_ || !this.thread.isComplete) {
            return false;
        }
        if (this.pertick == -1) {
            this.hasStarted = true;
            this.pertick = (int)((double)this.thread.results.size() / BallistixConstants.EXPLOSIVE_SONIC_DURATION + 1.0);
            this.iterator = this.thread.results.iterator();
        }
        int finished = this.pertick;
        while (this.iterator.hasNext() && finished-- >= 0) {
            BlockPos p = new BlockPos((Vec3i)this.iterator.next()).m_121955_((Vec3i)this.position);
            BlockState state = this.world.m_8055_(p);
            if (state.m_60795_() || state.m_60800_((BlockGetter)this.world, p) < 0.0f || (double)state.m_60800_((BlockGetter)this.world, p) > BallistixConstants.EXPLOSIVE_SONIC_MAXHARDNESS || state.m_278721_() || !BlastSonic.canBreakBlockState(this.world, state, p, this.owner)) continue;
            double deltaX = p.m_123341_() - this.position.m_123341_();
            double deltaY = Math.max(p.m_123342_() - this.position.m_123342_(), 1);
            double deltaZ = p.m_123343_() - this.position.m_123343_();
            double inverseMag = Mth.m_14193_((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
            double velX = deltaX * inverseMag * BallistixConstants.EXPLOSIVE_SONIC_VELOCITY;
            double velY = Math.abs(deltaY) * inverseMag * BallistixConstants.EXPLOSIVE_SONIC_VELOCITY;
            double velZ = deltaZ * inverseMag * BallistixConstants.EXPLOSIVE_SONIC_VELOCITY;
            EntityBallistixFallingBlock movingBlock = new EntityBallistixFallingBlock(this.world, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, state, this.thread.results, this.owner);
            movingBlock.m_20334_(velX * 0.33, velY * 3.0, velZ * 0.33);
            this.world.m_7731_(p, state.m_60819_().m_76188_(), 3);
            if (!((double)this.world.f_46441_.m_188501_() < 0.3333333333333333)) continue;
            this.world.m_7967_((Entity)movingBlock);
        }
        if (this.iterator.hasNext()) {
            float x = this.position.m_123341_();
            float y = this.position.m_123342_();
            float z = this.position.m_123343_();
            float size = (float)BallistixConstants.EXPLOSIVE_SONIC_RADIUS;
            float doubleSize = size * 2.0f;
            int x0 = Mth.m_14107_((double)((double)x - (double)doubleSize - 1.0));
            int x1 = Mth.m_14107_((double)((double)x + (double)doubleSize + 1.0));
            int y0 = Mth.m_14107_((double)((double)y - (double)doubleSize - 1.0));
            int y1 = Mth.m_14107_((double)((double)y + (double)doubleSize + 1.0));
            int z0 = Mth.m_14107_((double)((double)z - (double)doubleSize - 1.0));
            int z1 = Mth.m_14107_((double)((double)z + (double)doubleSize + 1.0));
            List entities = this.world.m_45976_(LivingEntity.class, new AABB((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
            for (LivingEntity entity : entities) {
                if (!BlastSonic.canHarmEntity((Entity)entity)) continue;
                double deltaX = entity.m_20185_() - (double)this.position.m_123341_();
                double deltaY = entity.m_20186_() - (double)this.position.m_123342_();
                double deltaZ = entity.m_20189_() - (double)this.position.m_123343_();
                double inverseMag = Mth.m_14193_((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
                double velX = deltaX * inverseMag * BallistixConstants.EXPLOSIVE_SONIC_VELOCITY;
                double velY = Math.abs(deltaY) * inverseMag * BallistixConstants.EXPLOSIVE_SONIC_VELOCITY;
                double velZ = deltaZ * inverseMag * BallistixConstants.EXPLOSIVE_SONIC_VELOCITY;
                entity.m_20256_(entity.m_20184_().m_82520_(velX, velY, velZ));
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public boolean isDoneCalculating() {
        if (this.world.f_46443_) {
            return this.shouldRenderCustomClient;
        }
        return this.thread == null || this.thread.isComplete;
    }
}

