/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier2;

import ballistix.api.blast.IHasCustomRender;
import ballistix.client.particle.ParticleOptionsBlastSmoke;
import ballistix.client.shake.CameraShakeEffect;
import ballistix.client.shake.CameraShakeManager;
import ballistix.common.blast.util.BlastLasting;
import ballistix.common.blast.util.thread.raycast.ThreadDynamicRaycastBlast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.packet.NetworkHandler;
import ballistix.common.packet.type.client.particle.BlastParticleSpawnType;
import ballistix.common.packet.type.client.particle.PacketSpawnBlastParticle;
import ballistix.common.settings.BallistixConstants;
import ballistix.prefab.utils.ParticleUtilities;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import voltaic.prefab.utilities.object.Location;

public class BlastThermobaric
extends BlastLasting
implements IHasCustomRender {
    private ThreadDynamicRaycastBlast thread;
    private int pertick = -1;
    private Iterator<BlockPos> cachedIterator;
    private boolean hasShaken = false;

    public BlastThermobaric(Level world, BlockPos position, @Nullable Entity owner, @Nullable Entity blastEntity) {
        super(world, position, owner, blastEntity);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.thread = new ThreadDynamicRaycastBlast(this.world, this.position, (int)BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE, (float)BallistixConstants.EXPLOSIVE_THERMOBARIC_ENERGY, null);
            if (BallistixConstants.SHOULD_MULTITHREAD_RAYTRACING) {
                this.thread.start();
            } else {
                this.thread.run();
            }
            Explosion ex = new Explosion(this.world, null, null, null, (double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), (float)BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE, false, Explosion.BlockInteraction.DESTROY);
            this.attackEntities((float)BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE * 2.0f, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doExplode(int callCount) {
        super.doExplode(callCount);
        if (this.thread == null) {
            return !this.world.f_46443_;
        }
        if (callCount % 2 == 0) {
            Explosion ex = new Explosion(this.world, this.blastEntity, this.world.m_269111_().m_269036_(this.blastEntity, this.owner), null, (double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), (float)BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE, false, Explosion.BlockInteraction.DESTROY);
            Set<BlockPos> set = this.thread.finishedBlocks;
            synchronized (set) {
                if (this.pertick == -1) {
                    this.hasStarted = true;
                    this.attackEntities((float)BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE * 2.0f, ex);
                    this.world.m_5594_(null, this.position, SoundEvents.f_11913_, SoundSource.BLOCKS, 25.0f, 1.0f);
                    this.pertick = (int)(54000.0 / BallistixConstants.EXPLOSIVE_THERMOBARIC_DURATION);
                }
                this.cachedIterator = this.thread.finishedBlocks.iterator();
                int finished = this.pertick;
                while (this.cachedIterator.hasNext() && finished-- >= 0) {
                    Level level;
                    BlockPos offset;
                    BlockPos p = this.cachedIterator.next();
                    BlockState state = this.world.m_8055_(p);
                    if (!BlastThermobaric.canBreakBlockState(this.world, state, p, this.owner)) continue;
                    Block block = state.m_60734_();
                    BlockState toPlace = Blocks.f_50016_.m_49966_();
                    double dis = new Location((double)p.m_123341_(), 0.0, (double)p.m_123343_()).distance(new Location((double)this.position.m_123341_(), 0.0, (double)this.position.m_123343_()));
                    if ((double)this.world.f_46441_.m_188501_() < 1.0 / (3.0 * Math.sqrt(dis)) && !this.thread.results.contains(offset = p.m_121945_(Direction.DOWN))) {
                        toPlace = Blocks.f_50083_.m_49966_();
                    }
                    block.m_7592_(this.world, p, ex);
                    this.world.m_7731_(p, toPlace, 35);
                    if ((double)this.world.f_46441_.m_188501_() < 0.05 && (level = this.world) instanceof ServerLevel) {
                        ServerLevel serverlevel = (ServerLevel)level;
                        serverlevel.m_7726_().f_8325_.m_183262_(new ChunkPos(p), false).forEach(pl -> NetworkHandler.CHANNEL.sendTo((Object)new PacketSpawnBlastParticle(p, BlastParticleSpawnType.EXPLOSIVE_BLOCK_BREAK), pl.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
                    }
                    this.cachedIterator.remove();
                }
                if (!this.cachedIterator.hasNext() && this.thread.isComplete) {
                    this.attackEntities((float)BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE * 2.0f, ex);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void produceParticles() {
        double spawnSize;
        double endSize;
        int diff;
        double x = (double)this.position.m_123341_() + 0.5;
        double y = (double)this.position.m_123342_() + 0.5;
        double z = (double)this.position.m_123343_() + 0.5;
        double initialSpeed = 0.8;
        if (this.ticksSinceBlastStart <= 5) {
            ParticleOptionsBlastSmoke particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 4.0f, -0.045f, 750, true, true, 40, 0.95);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 25, 50.0, 90.0, initialSpeed, true);
            initialSpeed = 1.0;
            particle = new ParticleOptionsBlastSmoke().setParameters(0.8f, 0.8f, 0.8f, 4.0f, 0.033f, 750, true, 0.95);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 25, 0.0, 20.0, initialSpeed, true);
            initialSpeed = 1.0;
            particle = new ParticleOptionsBlastSmoke().setParameters(0.8f, 0.8f, 0.8f, 4.0f, -0.033f, 750, true, 0.95);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 25, 0.0, 20.0, initialSpeed, true);
        }
        if (this.ticksSinceBlastStart > (diff = (int)((endSize = BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE * 7.5) - (spawnSize = 3.0)))) {
            return;
        }
        double size = ParticleUtilities.progressGroundShockwave(this.world, x, z, (double)(this.ticksSinceBlastStart * 2) / (double)diff, spawnSize, endSize, 0.15);
        if (this.hasShaken) {
            return;
        }
        Vec3 pos = new Vec3(x, y, z);
        double realDistance = Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(pos);
        double dist = Mth.m_14154_((float)((float)(realDistance - size)));
        if (dist < 3.0) {
            this.hasShaken = true;
            CameraShakeEffect effect = CameraShakeManager.createBlastSourcedEffect(BallistixConstants.EXPLOSIVE_THERMOBARIC_DURATION / 1.5, endSize, this.world.m_46467_(), pos);
            CameraShakeManager.addShake(effect);
        }
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public SubtypeBlast getBlastType() {
        return SubtypeBlast.thermobaric;
    }

    @Override
    public boolean isDoneCalculating() {
        if (this.world.f_46443_) {
            return this.shouldRenderCustomClient;
        }
        return this.thread == null || this.thread.isComplete;
    }

    @Override
    public boolean shouldRender() {
        return this.pertick > 0;
    }
}

