/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier3;

import ballistix.api.blast.IBlast;
import ballistix.api.blast.IHasCustomRender;
import ballistix.client.particle.ParticleOptionsBlastSmoke;
import ballistix.client.shake.CameraShakeEffect;
import ballistix.client.shake.CameraShakeManager;
import ballistix.common.blast.util.BlastLasting;
import ballistix.common.blast.util.thread.ThreadSimpleBlast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.packet.NetworkHandler;
import ballistix.common.packet.type.client.particle.BlastParticleSpawnType;
import ballistix.common.packet.type.client.particle.PacketSpawnBlastParticle;
import ballistix.common.settings.BallistixConstants;
import ballistix.prefab.utils.ParticleUtilities;
import ballistix.registers.BallistixSounds;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;

public class BlastAntimatter
extends BlastLasting
implements IHasCustomRender {
    private ThreadSimpleBlast thread;
    private int pertick = -1;
    private Iterator<BlockPos> iterator;
    private boolean hasShaken;

    public BlastAntimatter(Level world, BlockPos position, @Nullable Entity owner, @Nullable Entity blastEntity) {
        super(world, position, owner, blastEntity);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.thread = new ThreadSimpleBlast(this.world, this.position, (int)BallistixConstants.EXPLOSIVE_ANTIMATTER_RADIUS, 2.1474836E9f, null, this.getBlastType().id());
            this.thread.start();
            this.world.m_5594_(null, this.position, (SoundEvent)BallistixSounds.SOUND_ANTIMATTEREXPLOSION.get(), SoundSource.BLOCKS, 25.0f, 1.0f);
        }
    }

    @Override
    public boolean shouldRender() {
        return this.pertick > 0;
    }

    @Override
    public boolean doExplode(int callCount) {
        super.doExplode(callCount);
        if (this.thread == null) {
            return !this.world.f_46443_;
        }
        if (this.world.f_46443_ || !this.thread.isComplete) {
            return false;
        }
        Explosion ex = new Explosion(this.world, this.blastEntity, this.world.m_269111_().m_269036_(this.blastEntity, this.owner), null, (double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), (float)BallistixConstants.EXPLOSIVE_ANTIMATTER_RADIUS, false, Explosion.BlockInteraction.DESTROY);
        if (this.pertick == -1) {
            this.hasStarted = true;
            this.pertick = (int)((double)this.thread.results.size() * 1.5 / BallistixConstants.EXPLOSIVE_ANTIMATTER_DURATION + 1.0);
            this.iterator = this.thread.results.iterator();
        }
        int finished = this.pertick;
        while (this.iterator.hasNext() && finished-- >= 0) {
            Level level;
            BlockPos p = new BlockPos((Vec3i)this.iterator.next()).m_121955_((Vec3i)this.position);
            BlockState state = this.world.m_8055_(p);
            Block block = state.m_60734_();
            if (state.m_60795_() || !(state.m_60800_((BlockGetter)this.world, p) >= 0.0f)) continue;
            if (BlastAntimatter.canBreakBlockState(this.world, state, p, this.owner)) {
                block.m_7592_(this.world, p, ex);
                this.world.m_7731_(p, Blocks.f_50016_.m_49966_(), 35);
            }
            if (!((double)this.world.f_46441_.m_188501_() < 0.013333333333333334) || !((level = this.world) instanceof ServerLevel)) continue;
            ServerLevel serverlevel = (ServerLevel)level;
            serverlevel.m_7726_().f_8325_.m_183262_(new ChunkPos(p), false).forEach(pl -> NetworkHandler.CHANNEL.sendTo((Object)new PacketSpawnBlastParticle(p, BlastParticleSpawnType.EXPLOSIVE_BLOCK_BREAK), pl.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
        }
        if (!this.iterator.hasNext()) {
            this.position = this.position.m_7494_().m_7494_();
            this.attackEntities((float)BallistixConstants.EXPLOSIVE_ANTIMATTER_RADIUS * 2.0f, ex);
            return true;
        }
        return false;
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void produceParticles() {
        double spawnSize;
        double endSize;
        int diff;
        if (this.ticksSinceBlastStart < 2) {
            return;
        }
        double x = (double)this.position.m_123341_() + 0.5;
        double y = (double)this.position.m_123342_() + 0.5;
        double z = (double)this.position.m_123343_() + 0.5;
        if (this.ticksSinceBlastStart < 10) {
            ParticleOptionsBlastSmoke particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 15.0f, 0.015f, 750, true, true, 120, 0.999);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 50, -90.0, 90.0, BallistixConstants.EXPLOSIVE_ANTIMATTER_RADIUS / BallistixConstants.EXPLOSIVE_ANTIMATTER_DURATION * 2.5, true);
        }
        if (this.ticksSinceBlastStart > (diff = (int)((endSize = BallistixConstants.EXPLOSIVE_NUCLEAR_SIZE * 5.0) - (spawnSize = 3.0)))) {
            return;
        }
        double size = ParticleUtilities.progressGroundShockwave(this.world, x, z, (double)(this.ticksSinceBlastStart * 5) / (double)diff, spawnSize, endSize, 0.25);
        if (this.hasShaken) {
            return;
        }
        Vec3 pos = new Vec3(x, y, z);
        double realDistance = Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(pos);
        double dist = Mth.m_14154_((float)((float)(realDistance - size)));
        if (dist < 3.0) {
            this.hasShaken = true;
            CameraShakeEffect effect = CameraShakeManager.createBlastSourcedEffect(BallistixConstants.EXPLOSIVE_ANTIMATTER_DURATION, endSize, this.world.m_46467_(), pos);
            CameraShakeManager.addShake(effect);
        }
    }

    @Override
    public IBlast getBlastType() {
        return SubtypeBlast.antimatter;
    }

    @Override
    public boolean isDoneCalculating() {
        if (this.world.f_46443_) {
            return this.shouldRenderCustomClient;
        }
        return this.thread == null || this.thread.isComplete;
    }
}

