/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier3;

import ballistix.api.blast.IBlast;
import ballistix.api.blast.IHasCustomRender;
import ballistix.common.blast.util.BlastLasting;
import ballistix.common.blast.util.thread.ThreadSimpleBlast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.settings.BallistixConstants;
import ballistix.registers.BallistixSounds;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlastExothermic
extends BlastLasting
implements IHasCustomRender {
    private ThreadSimpleBlast thread;
    private Iterator<BlockPos> iterator;
    private int pertick = -1;

    public BlastExothermic(Level world, BlockPos position, @Nullable Entity owner, @Nullable Entity blastEntity) {
        super(world, position, owner, blastEntity);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.thread = new ThreadSimpleBlast(this.world, this.position, (int)BallistixConstants.EXPLOSIVE_EXOTHERMIC_RADIUS, 2.1474836E9f, null, this.getBlastType().id());
            this.thread.start();
            this.world.m_5594_(null, this.position, (SoundEvent)BallistixSounds.SOUND_ENDOTHERMICBEAM.get(), SoundSource.BLOCKS, 25.0f, 1.0f);
        }
    }

    @Override
    public boolean doExplode(int callCount) {
        this.hasStarted = true;
        super.doExplode(callCount);
        if (this.thread == null) {
            return !this.world.f_46443_;
        }
        if (this.world.f_46443_ || !this.thread.isComplete || this.ticksSinceBlastStart < 20) {
            return false;
        }
        if (this.pertick == -1) {
            this.hasStarted = true;
            this.pertick = (int)((double)this.thread.results.size() * 1.5 / BallistixConstants.EXPLOSIVE_EXOTHERMIC_DURATION + 1.0);
            this.iterator = this.thread.results.iterator();
            this.world.m_5594_(null, this.position, SoundEvents.f_11913_, SoundSource.BLOCKS, 25.0f, 1.0f);
            this.world.m_254849_(null, (double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), (float)BallistixConstants.EXPLOSIVE_EXOTHERMIC_RADIUS * 0.85f, Level.ExplosionInteraction.BLOCK);
        }
        int finished = this.pertick;
        while (this.iterator.hasNext() && finished-- >= 0) {
            BlockPos p = new BlockPos((Vec3i)this.iterator.next()).m_121955_((Vec3i)this.position);
            BlockState state = this.world.m_8055_(p);
            if (state.m_60795_() || !(state.m_60734_() instanceof LiquidBlock) && (state.m_60800_((BlockGetter)this.world, p) < 0.0f || (double)state.m_60800_((BlockGetter)this.world, p) > BallistixConstants.EXPLOSIVE_EXOTHERMIC_MAXHARDNESS) || !BlastExothermic.canBreakBlockState(this.world, state, p, this.owner)) continue;
            if (state.m_60734_() instanceof LiquidBlock) {
                this.world.m_46597_(p, Blocks.f_50016_.m_49966_());
                continue;
            }
            double chance = this.world.f_46441_.m_188500_();
            if (chance <= BallistixConstants.EXPLOSIVE_EXOTHERMIC_CHANCE_FOR_LAVA) {
                this.world.m_46597_(p, Blocks.f_49991_.m_49966_());
                continue;
            }
            if (!(chance <= BallistixConstants.EXPLOSIVE_EXOTHERMIC_CHANCE_TO_BURN)) continue;
            int selection = this.world.f_46441_.m_216332_(0, 5);
            BlockState newState = null;
            switch (selection) {
                case 1: {
                    newState = Blocks.f_50134_.m_49966_();
                    break;
                }
                case 2: {
                    newState = Blocks.f_50197_.m_49966_();
                    break;
                }
                case 3: {
                    newState = Blocks.f_50135_.m_49966_();
                    break;
                }
                case 4: {
                    newState = Blocks.f_50136_.m_49966_();
                    break;
                }
                case 5: {
                    newState = Blocks.f_50080_.m_49966_();
                }
            }
            if (newState == null) continue;
            this.world.m_46597_(p, newState);
        }
        if (!this.iterator.hasNext()) {
            float x = this.position.m_123341_();
            float y = this.position.m_123342_();
            float z = this.position.m_123343_();
            float size = (float)BallistixConstants.EXPLOSIVE_SONIC_RADIUS;
            float doubleSize = size * 2.0f;
            int x0 = Mth.m_14107_((double)((double)x - (double)doubleSize - 1.0));
            int x1 = Mth.m_14107_((double)((double)x + (double)doubleSize + 1.0));
            int y0 = Mth.m_14107_((double)((double)y - (double)doubleSize - 1.0));
            int y1 = Mth.m_14107_((double)((double)y + (double)doubleSize + 1.0));
            int z0 = Mth.m_14107_((double)((double)z - (double)doubleSize - 1.0));
            int z1 = Mth.m_14107_((double)((double)z + (double)doubleSize + 1.0));
            List entities = this.world.m_45976_(LivingEntity.class, new AABB((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
            for (LivingEntity entity : entities) {
                if (!BlastExothermic.canHarmEntity((Entity)entity)) continue;
                double deltaX = entity.m_20185_() - (double)this.position.m_123341_();
                double deltaY = entity.m_20186_() - (double)this.position.m_123342_();
                double deltaZ = entity.m_20189_() - (double)this.position.m_123343_();
                double inverseMag = Mth.m_14193_((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
                double velX = deltaX * inverseMag * BallistixConstants.EXPLOSIVE_ENDOTHERMIC_VELOCITY;
                double velY = deltaY * inverseMag * BallistixConstants.EXPLOSIVE_ENDOTHERMIC_VELOCITY;
                double velZ = deltaZ * inverseMag * BallistixConstants.EXPLOSIVE_ENDOTHERMIC_VELOCITY;
                entity.m_147207_(new MobEffectInstance(MobEffects.f_19604_, 10000), this.owner);
                entity.m_7311_(10000);
                entity.m_20256_(entity.m_20184_().m_82520_(velX, velY, velZ));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public boolean isDoneCalculating() {
        if (this.world.f_46443_) {
            return this.shouldRenderCustomClient;
        }
        return this.thread == null || this.thread.isComplete;
    }

    @Override
    public boolean shouldRender() {
        return this.ticksSinceBlastStart < 20;
    }

    @Override
    public void produceParticles() {
    }

    @Override
    public IBlast getBlastType() {
        return SubtypeBlast.exothermic;
    }
}

