/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier3;

import ballistix.api.blast.IBlast;
import ballistix.common.blast.util.Blast;
import ballistix.common.block.subtype.SubtypeBlast;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import org.apache.commons.io.FileUtils;
import voltaic.Voltaic;

public class BlastRejuvination
extends Blast {
    public BlastRejuvination(Level world, BlockPos position, @Nullable Entity owner, @Nullable Entity blastEntity) {
        super(world, position, owner, blastEntity);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.world.m_5594_(null, this.position, SoundEvents.f_12563_, SoundSource.BLOCKS, 25.0f, 1.0f);
        }
    }

    @Override
    public IBlast getBlastType() {
        return SubtypeBlast.rejuvination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doExplode(int callCount) {
        if (this.world.f_46443_) {
            return true;
        }
        try {
            Path tempDir = Paths.get("BallistixRejuvinationBlast", new String[0]);
            LevelStorageSource levelStorage = LevelStorageSource.m_78242_((Path)tempDir);
            try {
                LevelStorageSource.LevelStorageAccess session = levelStorage.m_78260_("BallistixRejuvinationBlast");
                ServerLevel currentWorld = (ServerLevel)this.world;
                PrimaryLevelData levelProperties = (PrimaryLevelData)currentWorld.m_7654_().m_129910_().m_5996_();
                try {
                    ServerLevel newWorld = new ServerLevel(currentWorld.m_7654_(), (Executor)Util.m_183991_(), session, (ServerLevelData)currentWorld.m_6106_(), currentWorld.m_46472_(), new LevelStem(currentWorld.m_204156_(), currentWorld.m_7726_().m_8481_()), (ChunkProgressListener)new LoggerChunkProgressListener(32), currentWorld.m_46659_(), levelProperties.m_246337_().m_245499_(), (List)ImmutableList.of(), false, currentWorld.m_288231_());
                    ChunkPos pos = new ChunkPos(this.position);
                    CompletionStage loadedChunk = newWorld.m_7726_().m_8431_(pos.f_45578_, pos.f_45579_, ChunkStatus.f_62322_, true).thenApply(either -> (ChunkAccess)either.orThrow());
                    ServerChunkCache.MainThreadExecutor executor = newWorld.m_7726_().f_8332_;
                    executor.m_18701_(() -> BlastRejuvination.lambda$doExplode$1((CompletableFuture)loadedChunk));
                    ChunkAccess newChunk = ((CompletableFuture)loadedChunk).getNow(null);
                    LevelChunk currChunk = currentWorld.m_6325_(pos.f_45578_, pos.f_45579_);
                    BlockPos start = new BlockPos(pos.m_45604_(), newWorld.m_141937_(), pos.m_45605_());
                    BlockPos end = new BlockPos(pos.m_45608_(), newWorld.m_151558_(), pos.m_45609_());
                    BlockPos.m_121990_((BlockPos)start, (BlockPos)end).forEach(arg_0 -> BlastRejuvination.lambda$doExplode$2(newChunk, (ChunkAccess)currChunk, currentWorld, arg_0));
                    while (currentWorld.m_7654_().m_7245_()) {
                        Thread.yield();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Voltaic.LOGGER.info("Rejuvenation Blast at " + this.position + " has failed.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Voltaic.LOGGER.info("Rejuvenation Blast at " + this.position + " has failed.");
            }
            finally {
                FileUtils.deleteDirectory((File)new File(tempDir.toUri()));
                if (Files.exists(tempDir, new LinkOption[0])) {
                    Voltaic.LOGGER.info(tempDir + " still exists!");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Voltaic.LOGGER.info("Rejuvenation Blast at " + this.position + " has failed.");
        }
        return true;
    }

    private static /* synthetic */ void lambda$doExplode$2(ChunkAccess newChunk, ChunkAccess currChunk, ServerLevel currentWorld, BlockPos blockPos) {
        BlockState currState;
        BlockState newState = newChunk.m_8055_(blockPos);
        if (newState == (currState = currChunk.m_8055_(blockPos))) {
            return;
        }
        currentWorld.m_46597_(blockPos, newState);
    }

    private static /* synthetic */ boolean lambda$doExplode$1(CompletableFuture loadedChunk) {
        if (loadedChunk.isDone() && Futures.getUnchecked((Future)loadedChunk) == null) {
            return false;
        }
        return loadedChunk.isDone();
    }
}

