/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.entity;

import ballistix.api.blast.IBlast;
import ballistix.api.entity.IDefusable;
import ballistix.common.blast.util.Blast;
import ballistix.registers.BallistixEntities;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class EntityGrenade
extends ThrowableProjectile
implements IDefusable {
    private static final EntityDataAccessor<Integer> FUSE = SynchedEntityData.m_135353_(EntityGrenade.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(EntityGrenade.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private ResourceLocation blastId = null;
    private int fuse = 80;

    public EntityGrenade(EntityType<? extends EntityGrenade> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityGrenade(Level worldIn, @Nullable LivingEntity owner) {
        this((EntityType<? extends EntityGrenade>)((EntityType)BallistixEntities.ENTITY_GRENADE.get()), worldIn);
        this.m_5602_((Entity)owner);
    }

    public void setExplosiveType(IBlast explosive) {
        this.blastId = explosive.id();
        this.fuse = explosive.fuse();
    }

    @Nullable
    public IBlast getExplosiveType() {
        return this.blastId == null ? null : Blast.BLAST_MAP.get(this.blastId);
    }

    @Override
    public void defuse() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        if (this.blastId != null) {
            IBlast explosive = Blast.BLAST_MAP.get(this.blastId);
            ItemEntity item = new ItemEntity(this.m_9236_(), (double)this.m_146903_() + 0.5, (double)this.m_146904_() + 0.5, (double)this.m_146907_() + 0.5, new ItemStack((ItemLike)explosive.getExplosiveItem().get()));
            this.m_9236_().m_7967_((Entity)item);
        }
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(FUSE, (Object)80);
        this.f_19804_.m_135372_(TYPE, (Object)"");
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            if (this.blastId != null) {
                this.f_19804_.m_135381_(TYPE, (Object)this.blastId.toString());
            }
            this.f_19804_.m_135381_(FUSE, (Object)this.fuse);
        } else {
            String str = (String)this.f_19804_.m_135370_(TYPE);
            if (!str.isEmpty()) {
                this.blastId = new ResourceLocation(str);
            }
            this.fuse = (Integer)this.f_19804_.m_135370_(FUSE);
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        --this.fuse;
        if (this.fuse <= 0) {
            IBlast explosive;
            Blast b;
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            if (this.blastId != null && (b = (explosive = Blast.BLAST_MAP.get(this.blastId)).createBlast(this.m_9236_(), this.m_20183_(), this.m_19749_(), (Entity)this)) != null) {
                b.performExplosion();
            }
        } else {
            this.m_20073_();
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Fuse", this.fuse);
        ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.blastId).result().ifPresent(tag -> compound.m_128365_("type", tag));
    }

    protected void m_7378_(CompoundTag compound) {
        this.fuse = compound.m_128451_("Fuse");
        ResourceLocation.f_135803_.decode((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("type")).result().ifPresent(pair -> {
            this.blastId = (ResourceLocation)pair.getFirst();
        });
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

