/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.entity;

import ballistix.api.blast.IBlast;
import ballistix.api.entity.IDefusable;
import ballistix.common.blast.util.Blast;
import ballistix.registers.BallistixEntities;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.network.NetworkHooks;

public class EntityMinecart
extends AbstractMinecart
implements IDefusable,
TraceableEntity {
    private static final EntityDataAccessor<Integer> FUSE = SynchedEntityData.m_135353_(EntityMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(EntityMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private ResourceLocation blastId = null;
    private int fuse = -1;
    private boolean exploded;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;

    public void setOwner(@Nullable Entity cachedOwner) {
        if (cachedOwner != null) {
            this.ownerUUID = cachedOwner.m_20148_();
            this.cachedOwner = cachedOwner;
        }
    }

    @Nullable
    public Entity m_19749_() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.cachedOwner = serverlevel.m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    protected boolean ownedBy(Entity entity) {
        return entity.m_20148_().equals(this.ownerUUID);
    }

    public EntityMinecart(EntityType<? extends EntityMinecart> type, Level worldIn) {
        super(type, worldIn);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.TNT;
    }

    public EntityMinecart(Level worldIn, @Nullable Entity owner) {
        this((EntityType<? extends EntityMinecart>)((EntityType)BallistixEntities.ENTITY_MINECART.get()), worldIn);
        this.setOwner(owner);
    }

    public void setExplosiveType(IBlast explosive) {
        this.blastId = explosive.id();
    }

    @Nullable
    public IBlast getExplosiveType() {
        return this.blastId == null ? null : Blast.BLAST_MAP.get(this.blastId);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FUSE, (Object)-1);
        this.f_19804_.m_135372_(TYPE, (Object)"");
    }

    public void m_8119_() {
        double d0;
        if (!this.m_9236_().f_46443_) {
            if (this.blastId != null) {
                this.f_19804_.m_135381_(TYPE, (Object)this.blastId.toString());
            }
            this.f_19804_.m_135381_(FUSE, (Object)this.fuse);
        } else {
            String str = (String)this.f_19804_.m_135370_(TYPE);
            if (!str.isEmpty()) {
                this.blastId = new ResourceLocation(str);
            }
            this.fuse = (Integer)this.f_19804_.m_135370_(FUSE);
        }
        super.m_8119_();
        if (this.fuse > 0) {
            --this.fuse;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.explode(this.m_20184_().m_165925_());
        }
        if (this.f_19862_ && (d0 = this.m_20184_().m_165925_()) >= (double)0.01f) {
            this.explode(d0);
        }
    }

    public boolean m_6469_(DamageSource source, float damage) {
        AbstractArrow abstractarrow;
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow && (abstractarrow = (AbstractArrow)entity).m_6060_()) {
            this.explode(abstractarrow.m_20184_().m_82556_());
        }
        return super.m_6469_(source, damage);
    }

    public void m_7617_(DamageSource source) {
        double d0 = this.m_20184_().m_165925_();
        if (!source.m_269533_(DamageTypeTags.f_268745_) && !source.m_269533_(DamageTypeTags.f_268415_) && d0 < (double)0.01f) {
            super.m_7617_(source);
            if (!source.m_269533_(DamageTypeTags.f_268415_) && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                this.m_19998_((ItemLike)Blocks.f_50077_);
            }
        } else if (this.fuse < 0) {
            this.primeFuse();
            this.fuse = this.f_19796_.m_188503_(20) + this.f_19796_.m_188503_(20);
        }
    }

    protected void explode(double val) {
        if (!this.m_9236_().f_46443_) {
            IBlast explosive;
            Blast b;
            this.exploded = true;
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            if (this.blastId != null && (b = (explosive = Blast.BLAST_MAP.get(this.blastId)).createBlast(this.m_9236_(), this.m_20183_(), this.m_19749_(), (Entity)this)) != null) {
                b.performExplosion();
            }
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (!this.exploded && this.blastId != null) {
            ItemEntity item = new ItemEntity(this.m_9236_(), (double)this.m_146903_() + 0.5, (double)this.m_146904_() + 0.5, (double)this.m_146907_() + 0.5, new ItemStack((ItemLike)Blast.BLAST_TO_MINECART_MAP.get(Blast.BLAST_MAP.get(this.blastId))));
            this.m_9236_().m_7967_((Entity)item);
        }
    }

    @Override
    public void defuse() {
        if (!this.exploded) {
            this.fuse = -1;
            this.f_19804_.m_135381_(FUSE, (Object)this.fuse);
        }
    }

    public boolean m_142535_(float par1, float par2, DamageSource source) {
        if (par1 >= 3.0f) {
            float f = par1 / 10.0f;
            this.explode(f * f);
        }
        return super.m_142535_(par1, par2, source);
    }

    protected Item m_213728_() {
        if (this.blastId != null) {
            return Blast.BLAST_TO_MINECART_MAP.get(Blast.BLAST_MAP.get(this.blastId));
        }
        return Items.f_42449_;
    }

    public void m_6025_(int par1, int par2, int par3, boolean toggle) {
        if (toggle && this.fuse < 0) {
            this.primeFuse();
        }
    }

    public void m_7822_(byte b) {
        if (b == 10) {
            this.primeFuse();
        } else {
            super.m_7822_(b);
        }
    }

    public void primeFuse() {
        this.fuse = 80;
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)10);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isPrimed() {
        return this.fuse > -1;
    }

    public float m_7077_(Explosion ex, BlockGetter getter, BlockPos pos, BlockState state, FluidState fluidState, float val) {
        return !this.isPrimed() || !state.m_204336_(BlockTags.f_13034_) && !getter.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_13034_) ? super.m_7077_(ex, getter, pos, state, fluidState, val) : 0.0f;
    }

    public boolean m_7349_(Explosion ex, BlockGetter getter, BlockPos pos, BlockState state, float val) {
        return !this.isPrimed() || !state.m_204336_(BlockTags.f_13034_) && !getter.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_13034_) && super.m_7349_(ex, getter, pos, state, val);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Fuse", this.fuse);
        if (this.ownerUUID != null) {
            compound.m_128362_("Owner", this.ownerUUID);
        }
        ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.blastId).result().ifPresent(tag -> compound.m_128365_("type", tag));
    }

    protected void m_7378_(CompoundTag compound) {
        this.fuse = compound.m_128451_("Fuse");
        if (compound.m_128403_("Owner")) {
            this.ownerUUID = compound.m_128342_("Owner");
            this.cachedOwner = null;
        }
        ResourceLocation.f_135803_.decode((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("type")).result().ifPresent(pair -> {
            this.blastId = (ResourceLocation)pair.getFirst();
        });
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

