/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.entity;

import ballistix.api.missile.MissileManager;
import ballistix.api.missile.virtual.VirtualProjectile;
import ballistix.registers.BallistixEntities;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EntityRailgunRound
extends Entity {
    private static final float RAD2DEG = 57.29578f;
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(EntityRailgunRound.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Nullable
    public UUID id;
    public float speed = 0.0f;

    public EntityRailgunRound(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public EntityRailgunRound(Level level) {
        this((EntityType)BallistixEntities.ENTITY_RAILGUNROUND.get(), level);
    }

    public void m_8119_() {
        boolean isServer;
        Level level = this.m_9236_();
        boolean isClient = level.m_5776_();
        boolean bl = isServer = !isClient;
        if (this.f_19797_ > 30 && this.m_20184_().m_82553_() <= 0.0) {
            if (isServer) {
                this.m_6089_();
            }
            return;
        }
        if (isServer) {
            if (this.id == null) {
                this.m_6089_();
                return;
            }
            VirtualProjectile.VirtualRailgunRound railgunround = MissileManager.getRailgunRound((ResourceKey<Level>)level.m_46472_(), this.id);
            if (railgunround == null) {
                this.m_6089_();
                return;
            }
            if (railgunround.hasExploded()) {
                this.m_6089_();
                return;
            }
            if (!this.m_20183_().equals((Object)railgunround.blockPosition())) {
                this.m_146884_(railgunround.position);
                this.m_20256_(railgunround.deltaMovement);
                this.speed = railgunround.speed;
            }
        }
        if (isServer) {
            this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(this.speed));
        } else {
            this.speed = ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
        }
        this.m_146884_(new Vec3(this.m_20185_() + this.m_20184_().f_82479_ * (double)this.speed, this.m_20186_() + this.m_20184_().f_82480_ * (double)this.speed, this.m_20189_() + this.m_20184_().f_82481_ * (double)this.speed));
        this.m_146926_((float)(Math.atan(this.m_20184_().m_7098_() / Math.sqrt(this.m_20184_().m_7096_() * this.m_20184_().m_7096_() + this.m_20184_().m_7094_() * this.m_20184_().m_7094_())) * (double)57.29578f));
        this.m_146922_((float)(Math.atan2(this.m_20184_().m_7096_(), this.m_20184_().m_7094_()) * (double)57.29578f));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        UUIDUtil.f_235867_.decode((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128469_("id")).result().ifPresent(pair -> {
            this.id = (UUID)pair.getFirst();
        });
        compound.m_128350_("speed", this.speed);
    }

    protected void m_7380_(CompoundTag compound) {
        ServerLevel server;
        Level level = this.m_9236_();
        if (!(!(level instanceof ServerLevel) || (server = (ServerLevel)level).m_143340_(this.m_20183_()) && server.m_46805_(this.m_20183_()))) {
            this.m_142467_(Entity.RemovalReason.DISCARDED);
        }
        if (this.id != null) {
            UUIDUtil.f_235867_.encode((Object)this.id, (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).result().ifPresent(tag -> compound.m_128365_("id", tag));
        }
        this.speed = compound.m_128457_("speed");
    }

    public void m_142687_(Entity.RemovalReason reason) {
        VirtualProjectile.VirtualRailgunRound missile;
        if (!this.m_9236_().f_46443_ && this.id != null && (missile = MissileManager.getRailgunRound((ResourceKey<Level>)this.m_9236_().m_46472_(), this.id)) != null) {
            missile.setSpawned(false, -1);
        }
        super.m_142687_(reason);
    }

    public boolean m_142389_() {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

