/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.item;

import ballistix.api.blast.IBlast;
import ballistix.api.missile.MissileManager;
import ballistix.api.missile.virtual.VirtualMissile;
import ballistix.common.blast.util.Blast;
import ballistix.common.block.subtype.SubtypeMissile;
import ballistix.common.item.ItemMissile;
import ballistix.common.settings.BallistixConstants;
import ballistix.registers.BallistixCreativeTabs;
import ballistix.registers.BallistixItems;
import ballistix.registers.BallistixSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import voltaic.common.item.ItemVoltaic;

public class ItemRocketLauncher
extends ItemVoltaic {
    public ItemRocketLauncher() {
        super(new Item.Properties().m_41487_(1), BallistixCreativeTabs.MAIN);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (level.f_46443_) {
            return;
        }
        int timeRemaining = stack.m_41784_().m_128451_("timer");
        if (timeRemaining > 0) {
            stack.m_41784_().m_128405_("timer", --timeRemaining);
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entityLiving, int timeLeft) {
        ItemStack ex;
        if (world.f_46443_ || !(entityLiving instanceof Player)) {
            return;
        }
        if (stack.m_41784_().m_128451_("timer") > 0) {
            return;
        }
        Player player = (Player)entityLiving;
        if (!player.m_7500_()) {
            stack.m_41784_().m_128405_("timer", BallistixConstants.ROCKET_LAUNCHER_COOLDOWN_TICKS);
        }
        IBlast blast = null;
        boolean hasExplosive = false;
        boolean hasRange = false;
        ItemStack missile = ex = ItemStack.f_41583_;
        for (ItemStack st : player.m_150109_().f_35974_) {
            Item it = st.m_41720_();
            IBlast bl = Blast.ITEM_TO_BLAST_MAP.get(it);
            if (!hasExplosive && bl != null && (player.m_7500_() || bl.tier() <= 1)) {
                blast = bl;
                hasExplosive = true;
                ex = st;
            }
            if (!hasRange && (it == BallistixItems.ITEMS_MISSILE.getValue((Object)SubtypeMissile.tier1) || player.m_7500_() && (it == BallistixItems.ITEMS_MISSILE.getValue((Object)SubtypeMissile.tier1) || it == BallistixItems.ITEMS_MISSILE.getValue((Object)SubtypeMissile.tier2) || it == BallistixItems.ITEMS_MISSILE.getValue((Object)SubtypeMissile.tier3)))) {
                hasRange = true;
                missile = st;
            }
            if (!hasRange || !hasExplosive) continue;
            break;
        }
        if (hasExplosive && hasRange) {
            VirtualMissile virtualMissile = new VirtualMissile(new Vec3(entityLiving.m_20185_(), entityLiving.m_20186_() + (double)entityLiving.m_20192_() * 0.8, entityLiving.m_20189_()), new Vec3(entityLiving.m_20154_().f_82479_, entityLiving.m_20154_().f_82480_, entityLiving.m_20154_().f_82481_), 1.333f, VirtualMissile.FlightPath.ROCKET_LAUNCHER, 0.0f, 0.0f, BlockPos.f_121853_, ((ItemMissile)missile.m_41720_()).missile.ordinal() + 1, blast, 0, false);
            ex.m_41774_(1);
            missile.m_41774_(1);
            MissileManager.addMissile((ResourceKey<Level>)world.m_46472_(), virtualMissile);
            world.m_5594_(null, player.m_20183_().m_7494_(), (SoundEvent)BallistixSounds.SOUND_MISSILE_ROCKETLAUNCHER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

