/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.item;

import ballistix.api.silo.ILauncherControlPanel;
import ballistix.prefab.utils.BallistixTextUtils;
import ballistix.registers.BallistixCreativeTabs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.api.codec.StreamCodec;
import voltaic.api.multiblock.subnodebased.TileMultiSubnode;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.item.ItemElectric;
import voltaic.prefab.utilities.object.TransferPack;

@Mod.EventBusSubscriber(modid="ballistix", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemTracker
extends ItemElectric {
    public static final double USAGE = 150.0;
    public static final String X = "target_x";
    public static final String Z = "target_z";
    public static final String UUID = "uuid";
    public static HashMap<ServerLevel, HashSet<Integer>> validuuids = new HashMap();

    public ItemTracker() {
        super((ElectricItemProperties)new ElectricItemProperties().capacity(1666666.66667).receive(TransferPack.joulesVoltage((double)694.4444444458333, (double)120.0)).extract(TransferPack.joulesVoltage((double)694.4444444458333, (double)120.0)).m_41487_(1), BallistixCreativeTabs.MAIN, item -> Items.f_41852_);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        TileMultiSubnode subnode;
        BlockEntity blockEntity;
        if (context.m_43725_().f_46443_ || !ItemTracker.hasTarget(stack)) {
            return super.onItemUseFirst(stack, context);
        }
        Entity entity = context.m_43725_().m_6815_(ItemTracker.getUUID(stack));
        BlockEntity tile = context.m_43725_().m_7702_(context.m_8083_());
        if (tile instanceof ILauncherControlPanel) {
            ILauncherControlPanel silo = (ILauncherControlPanel)tile;
            silo.setTarget(new BlockPos((int)entity.m_20185_(), 0, (int)entity.m_20189_()));
        } else if (tile instanceof TileMultiSubnode && (blockEntity = (subnode = (TileMultiSubnode)tile).m_58904_().m_7702_((BlockPos)subnode.parentPos.getValue())) instanceof ILauncherControlPanel) {
            ILauncherControlPanel silo = (ILauncherControlPanel)blockEntity;
            silo.setTarget(new BlockPos((int)entity.m_20185_(), 0, (int)entity.m_20189_()));
        }
        return super.onItemUseFirst(stack, context);
    }

    public void m_7373_(ItemStack stack, Level context, List<Component> tooltip, TooltipFlag flagIn) {
        Entity entity;
        MutableComponent name = BallistixTextUtils.tooltip("tracker.none", new Object[0]);
        if (ItemTracker.hasTarget(stack) && (entity = context.m_6815_(ItemTracker.getUUID(stack))) != null) {
            name = entity.m_7755_();
        }
        tooltip.add((Component)BallistixTextUtils.tooltip("tracker.tracking", name.m_6881_().m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        super.m_7373_(stack, context, tooltip, flagIn);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (level instanceof ServerLevel) {
            Player player;
            ServerLevel slevel = (ServerLevel)level;
            if ((selected || entity instanceof Player && (player = (Player)entity).m_21206_() == stack) && ItemTracker.hasTarget(stack)) {
                int uuid = ItemTracker.getUUID(stack);
                if (validuuids.containsKey(level) && validuuids.get(level).contains(uuid)) {
                    Entity ent = slevel.m_6815_(uuid);
                    if (ent != null) {
                        ItemTracker.setX(stack, ent.m_20182_().f_82479_);
                        ItemTracker.setZ(stack, ent.m_20182_().f_82481_);
                    }
                } else {
                    ItemTracker.wipeData(stack);
                }
            }
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        Level level;
        if (player != null && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.getJoulesStored(stack) >= 150.0) {
                Inventory inv = player.m_150109_();
                inv.m_36057_(stack);
                ItemTracker.setUUID(stack, entity.m_19879_());
                HashSet<Integer> set = validuuids.getOrDefault(server, new HashSet());
                set.add(entity.m_19879_());
                validuuids.put(server, set);
                if (hand == InteractionHand.MAIN_HAND) {
                    inv.m_6836_(inv.f_35977_, stack);
                } else {
                    inv.f_35976_.set(0, (Object)stack);
                }
                this.extractPower(stack, 150.0, false);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    public static double getX(ItemStack stack) {
        return stack.m_41784_().m_128459_(X);
    }

    public static double getZ(ItemStack stack) {
        return stack.m_41784_().m_128459_(Z);
    }

    public static int getUUID(ItemStack stack) {
        return stack.m_41784_().m_128451_(UUID);
    }

    public static void setX(ItemStack stack, double x) {
        stack.m_41784_().m_128347_(X, x);
    }

    public static void setZ(ItemStack stack, double z) {
        stack.m_41784_().m_128347_(Z, z);
    }

    public static void setUUID(ItemStack stack, int uuid) {
        stack.m_41784_().m_128405_(UUID, uuid);
    }

    public static void wipeData(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(X);
        tag.m_128473_(Z);
        tag.m_128473_(UUID);
    }

    public static boolean hasTargetCoords(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(X) && tag.m_128441_(Z);
    }

    public static boolean hasTarget(ItemStack stack) {
        return stack.m_41784_().m_128441_(UUID);
    }

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        for (Map.Entry<ServerLevel, HashSet<Integer>> en : validuuids.entrySet()) {
            Iterator<Integer> it = en.getValue().iterator();
            while (it.hasNext()) {
                int uuid = it.next();
                Entity ent = en.getKey().m_6815_(uuid);
                if (ent != null && !ent.m_213877_()) continue;
                it.remove();
            }
        }
    }

    public record Target(double x, double z) {
        public static final Codec<Target> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(Target::x), (App)Codec.DOUBLE.fieldOf("z").forGetter(Target::z)).apply((Applicative)instance, Target::new));
        public static final StreamCodec<ByteBuf, Target> STREAM_CODEC = new StreamCodec<ByteBuf, Target>(){

            public void encode(ByteBuf buf, Target data) {
                buf.writeDouble(data.x);
                buf.writeDouble(data.z);
            }

            public Target decode(ByteBuf buf) {
                return new Target(buf.readDouble(), buf.readDouble());
            }
        };
    }
}

