/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile;

import ballistix.common.inventory.container.ContainerAirRaidSiren;
import ballistix.prefab.sound.SoundBarrierMethods;
import ballistix.registers.BallistixSounds;
import ballistix.registers.BallistixTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileAirRaidSiren
extends GenericTile
implements ITickableSound {
    public static final double MIN_VOLUME = 0.0;
    public static final double MAX_VOLUME = 1.0;
    public static final double MIN_PITCH = 0.5;
    public static final double MAX_PITCH = 2.0;
    public static final int MIN_RANGE = 1;
    public static final int MAX_RANGE = 256;
    public final SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasredstone", (Object)false));
    public final SingleProperty<Double> volume = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "volume", (Object)0.5));
    public final SingleProperty<Double> pitch = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "pitch", (Object)1.0));
    public final SingleProperty<Integer> range = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "range", (Object)32));
    private boolean isPlaying = false;

    public TileAirRaidSiren(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)BallistixTiles.TILE_AIRRAIDSIREN.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentContainerProvider("airraidsiren", (GenericTile)this).createMenu((id, player) -> new ContainerAirRaidSiren((int)id, (Inventory)player, (Container)new SimpleContainer(0), (ContainerData)this.getCoordsArray())));
    }

    public void tickClient(ComponentTickable componentTickable) {
        if (!this.isPlaying && this.shouldPlaySound()) {
            this.isPlaying = true;
            SoundBarrierMethods.playAirRaidSirenSound((SoundEvent)BallistixSounds.SOUND_AIRRAIDSIREN.get(), this, 32.0);
        }
    }

    public void setNotPlaying() {
        this.isPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.hasRedstoneSignal.getValue();
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (!this.f_58857_.f_46443_) {
            boolean currVal = (Boolean)this.hasRedstoneSignal.getValue();
            this.hasRedstoneSignal.setValue((Object)(this.f_58857_.m_277086_(this.m_58899_()) > 0 ? 1 : 0));
            boolean newVal = (Boolean)this.hasRedstoneSignal.getValue();
            if (currVal ^ newVal) {
                BlockEntityUtils.updateLit((GenericTile)this, (Boolean)newVal);
            }
        }
    }
}

