/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile;

import ballistix.api.blast.IBlast;
import ballistix.api.missile.MissileManager;
import ballistix.api.missile.virtual.VirtualMissile;
import ballistix.api.silo.ILauncherControlPanel;
import ballistix.api.silo.ILauncherPlatform;
import ballistix.api.silo.ILauncherSupportFrame;
import ballistix.api.silo.SiloRegistry;
import ballistix.common.blast.util.Blast;
import ballistix.common.block.subtype.SubtypeBallistixMachine;
import ballistix.common.inventory.container.ContainerVLS;
import ballistix.common.item.ItemMissile;
import ballistix.common.item.ItemRadarGun;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.silo.TileLauncherControlPanelT1;
import ballistix.registers.BallistixItems;
import ballistix.registers.BallistixSounds;
import ballistix.registers.BallistixTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;
import voltaic.api.multiblock.subnodebased.TileMultiSubnode;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentBlock;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentTile;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileVerticalLaunchSilo
extends GenericTile
implements ILauncherControlPanel,
ILauncherPlatform,
ILauncherSupportFrame,
IMultiblockParentTile {
    public static final int COOLDOWN = 100;
    public static final int MISSILE_SLOT = 0;
    public static final int EXPLOSIVE_SLOT = 1;
    public SingleProperty<Integer> frequency = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "frequency", (Object)0).onChange((prop, prevFreq) -> {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        int newFreq = (Integer)prop.getValue();
        SiloRegistry.unregisterSilo(prevFreq, this);
        SiloRegistry.registerSilo(newFreq, this);
    }));
    public SingleProperty<BlockPos> target = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "target", (Object)BlockPos.f_121853_));
    public SingleProperty<Boolean> hasExplosive = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasexplosive", (Object)false));
    public SingleProperty<Boolean> hasMissile = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasmissile", (Object)false));
    private int cooldown = 100;
    public final SingleProperty<Boolean> shouldLaunch = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "shouldlaunch", (Object)false));

    public TileVerticalLaunchSilo(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)BallistixTiles.TILE_VLS.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(120.0).maxJoules(BallistixConstants.MISSILESILO_USAGE).setInputDirections(BlockEntityUtils.MachineDirection.values()));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(3)).setDirectionsBySlot(Integer.valueOf(0), BlockEntityUtils.MachineDirection.values()).setDirectionsBySlot(Integer.valueOf(1), BlockEntityUtils.MachineDirection.values()).valid(this::isItemValidForSlot));
        this.addComponent((IComponent)new ComponentContainerProvider("vls", (GenericTile)this).createMenu((id, player) -> new ContainerVLS((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
    }

    protected void tickServer(ComponentTickable tickable) {
        if (this.target.getValue() == null) {
            this.target.setValue((Object)this.m_58899_());
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (this.cooldown > 0 || electro.getJoulesStored() < BallistixConstants.MISSILESILO_USAGE * (double)this.getTier()) {
            --this.cooldown;
            return;
        }
        boolean hasRedstone = this.f_58857_.m_276867_(this.m_58899_());
        TileVerticalLaunchSilo platform = this;
        if (!platform.hasMissile() || platform.hasExplosive() && platform.hasSAM() || !platform.hasExplosive() && !platform.hasSAM() || !hasRedstone && !((Boolean)this.shouldLaunch.getValue()).booleanValue()) {
            return;
        }
        int inaccuracy = 10;
        this.shouldLaunch.setValue((Object)false);
        double dist = TileLauncherControlPanelT1.calculateDistance(this.f_58858_, (BlockPos)this.target.getValue());
        if ((double)platform.getRange() < dist) {
            return;
        }
        int newCool = platform.launch(this, hasRedstone, inaccuracy);
        if (newCool != -1) {
            this.cooldown = newCool;
        }
        electro.joules(electro.getJoulesStored() - BallistixConstants.MISSILESILO_USAGE * (double)this.getTier());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isItemValidForSlot(int index, ItemStack stack, ComponentInventory inv) {
        Item item = stack.m_41720_();
        if (index == 0) {
            if (item instanceof ItemMissile) {
                ItemMissile missile = (ItemMissile)item;
                if (missile.missile.tier() <= this.getTier()) return true;
            }
            if (!stack.m_150930_((Item)BallistixItems.ITEM_AAMISSILEMK2.get())) return false;
            return true;
        }
        if (index == 1) {
            IBlast blast = Blast.ITEM_TO_BLAST_MAP.get(item);
            if (blast == null) return false;
            if (blast.tier() > this.getTier()) return false;
            if (blast.tier() <= -1) return false;
            return true;
        }
        if (index != 2) return false;
        if (stack.m_150930_((Item)BallistixItems.ITEM_RADARGUN.get())) return true;
        if (!stack.m_150930_((Item)BallistixItems.ITEM_LASERDESIGNATOR.get())) return false;
        return true;
    }

    public void onBlockDestroyed() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        SiloRegistry.unregisterSilo((Integer)this.frequency.getValue(), this);
        ChunkPos pos = this.f_58857_.m_46865_(this.f_58858_).m_7697_();
        ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"ballistix", (BlockPos)this.m_58899_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)false, (boolean)true);
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (this.f_58857_.f_46443_) {
            return;
        }
        ChunkPos pos = this.f_58857_.m_46865_(this.f_58858_).m_7697_();
        ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"ballistix", (BlockPos)this.m_58899_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)true, (boolean)true);
    }

    public void onInventoryChange(ComponentInventory inv, int index) {
        this.handleMissile(inv, index);
        this.handleExplosive(inv, index);
        this.handleSync(inv, index);
    }

    private void handleMissile(ComponentInventory inv, int index) {
        if (index == 0 || index == -1) {
            ItemStack missile = inv.m_8020_(0);
            if (missile.m_41619_()) {
                this.hasMissile.setValue((Object)false);
                return;
            }
            if (missile.m_41720_() instanceof ItemMissile) {
                this.hasMissile.setValue((Object)true);
            } else {
                this.hasMissile.setValue((Object)false);
            }
        }
    }

    private void handleExplosive(ComponentInventory inv, int index) {
        if (index == 1 || index == -1) {
            ItemStack explosive = inv.m_8020_(1);
            if (!explosive.m_41619_() && Blast.ITEM_TO_BLAST_MAP.get(explosive.m_41720_()) != null || explosive.m_41619_() && inv.m_8020_(0).m_150930_((Item)BallistixItems.ITEM_AAMISSILEMK2.get())) {
                this.hasExplosive.setValue((Object)true);
            } else {
                this.hasExplosive.setValue((Object)false);
            }
        }
    }

    private void handleSync(ComponentInventory inv, int index) {
        if (index == 2 || index == -1) {
            ItemStack sync = inv.m_8020_(0);
            if (sync.m_41619_()) {
                return;
            }
            if (sync.m_41720_() == BallistixItems.ITEM_LASERDESIGNATOR.get()) {
                CompoundTag nbt = sync.m_41784_();
                nbt.m_128405_("freq", ((Integer)this.frequency.getValue()).intValue());
            } else if (sync.m_41720_() == BallistixItems.ITEM_RADARGUN.get() && sync.m_41784_().m_128441_("loc")) {
                this.target.setValue((Object)ItemRadarGun.getCoordiantes(sync));
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            SiloRegistry.registerSilo((Integer)this.frequency.getValue(), this);
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("silocooldown", this.cooldown);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.cooldown = compound.m_128451_("silocooldown");
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack handStack = player.m_21120_(hand);
        if (handStack.m_41720_() == BallistixItems.ITEM_RADARGUN.get() || handStack.m_41720_() == BallistixItems.ITEM_LASERDESIGNATOR.get()) {
            return InteractionResult.FAIL;
        }
        return super.use(player, hand, hit);
    }

    @Override
    public int getRange() {
        return BallistixConstants.VLS_RANGE;
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public boolean hasMissile() {
        return (Boolean)this.hasMissile.getValue();
    }

    @Override
    public boolean hasExplosive() {
        return (Boolean)this.hasMissile.getValue();
    }

    @Override
    public boolean hasSAM() {
        return false;
    }

    @Override
    public int launch(ILauncherControlPanel panel, boolean redstoneTriggered, int inaccuracy) {
        double length = (double)inaccuracy * this.f_58857_.f_46441_.m_188500_();
        double angle = this.f_58857_.f_46441_.m_188500_() * 2.0 * Math.PI;
        int offsetX = (int)(length * Math.cos(angle));
        int offsetZ = (int)(length * Math.sin(angle));
        BlockPos pos = panel.getTarget().m_7918_(offsetX, 0, offsetZ);
        if (this.launchMissile(pos, panel.getFrequency())) {
            this.cooldown = 100;
        }
        if (this.cooldown > 0) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)BallistixSounds.SOUND_VLSLAUNCH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return this.cooldown;
    }

    public boolean launchMissile(BlockPos target, int frequency) {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack mis = inv.m_8020_(0);
        ItemStack explosive = inv.m_8020_(1);
        Item item = mis.m_41720_();
        if (item instanceof ItemMissile) {
            ItemMissile itmissile = (ItemMissile)item;
            if (Blast.ITEM_TO_BLAST_MAP.get(explosive.m_41720_()) != null) {
                IBlast blast = Blast.ITEM_TO_BLAST_MAP.get(explosive.m_41720_());
                if (blast.tier() > itmissile.missile.tier() || itmissile.missile.tier() > this.getTier() || blast.tier() > this.getTier()) {
                    return false;
                }
                VirtualMissile missile = new VirtualMissile(new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5), new Vec3(0.0, 1.0, 0.0), 0.45f, VirtualMissile.FlightPath.VLS, (float)this.m_58899_().m_123341_() + 0.5f, (float)this.m_58899_().m_123343_() + 0.5f, target, itmissile.missile.ordinal() + 1, blast, frequency, this.getTier() > 1);
                MissileManager.addMissile((ResourceKey<Level>)this.f_58857_.m_46472_(), missile);
                inv.m_7407_(0, 1);
                inv.m_7407_(1, 1);
                return true;
            }
        }
        return false;
    }

    @Override
    public BlockPos getTarget() {
        return (BlockPos)this.target.getValue();
    }

    @Override
    public int getFrequency() {
        return (Integer)this.frequency.getValue();
    }

    @Override
    public BlockPos getPos() {
        return this.m_58899_();
    }

    @Override
    public ILauncherPlatform getPlatform() {
        return this;
    }

    @Override
    public ILauncherSupportFrame getSupportFrame() {
        return this;
    }

    @Override
    public void launch() {
        this.shouldLaunch.setValue((Object)true);
    }

    @Override
    public void setTarget(BlockPos blockPos) {
        this.target.setValue((Object)blockPos);
    }

    @Override
    public void setTargetFromDesignator(BlockPos target) {
        this.setTarget(target);
    }

    public IMultiblockParentBlock.SubnodeWrapper getSubNodes() {
        return SubtypeBallistixMachine.Subnodes.VLS;
    }

    public InteractionResult onSubnodeUse(Player player, InteractionHand hand, BlockHitResult hit, TileMultiSubnode subnode) {
        return this.use(player, hand, hit);
    }

    public void onSubnodeDestroyed(TileMultiSubnode subnode) {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public Direction getFacingDirection() {
        return this.getFacing();
    }

    @Override
    public int getInaccuracy() {
        return 10;
    }
}

