/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile.silo;

import ballistix.api.silo.ILauncherControlPanel;
import ballistix.api.silo.ILauncherPlatform;
import ballistix.api.silo.ILauncherSupportFrame;
import ballistix.api.silo.SiloRegistry;
import ballistix.common.inventory.container.ContainerLauncherControlPanelT1;
import ballistix.common.inventory.container.ContainerLauncherControlPanelT2;
import ballistix.common.inventory.container.ContainerLauncherControlPanelT3;
import ballistix.common.item.ItemRadarGun;
import ballistix.common.settings.BallistixConstants;
import ballistix.registers.BallistixItems;
import ballistix.registers.BallistixTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.world.ForgeChunkManager;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;

public class TileLauncherControlPanelT1
extends GenericTile
implements ILauncherControlPanel {
    public SingleProperty<Integer> frequency = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "frequency", (Object)0).onChange((prop, prevFreq) -> {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        int newFreq = (Integer)prop.getValue();
        SiloRegistry.unregisterSilo(prevFreq, this);
        SiloRegistry.registerSilo(newFreq, this);
    }));
    public SingleProperty<BlockPos> target = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "target", (Object)BlockPos.f_121853_));
    private int cooldown = 100;
    public final SingleProperty<Boolean> shouldLaunch = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "shouldlaunch", (Object)false));
    public CachedTileOutput launcherPlatform;
    public CachedTileOutput supportFrame;

    public TileLauncherControlPanelT1(BlockPos pos, BlockState state) {
        this((BlockEntityType)BallistixTiles.TILE_LAUNCHER_CONTROL_PANEL_TIER1.get(), pos, state);
    }

    public TileLauncherControlPanelT1(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        int tier = this.getTier();
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(120.0 * Math.pow(2.0, tier - 1)).maxJoules(BallistixConstants.MISSILESILO_USAGE * 20.0 * (double)tier).setInputDirections(BlockEntityUtils.MachineDirection.values()));
        if (tier == 3) {
            this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(2)).setDirectionsBySlot(Integer.valueOf(0), BlockEntityUtils.MachineDirection.values()).setDirectionsBySlot(Integer.valueOf(1), BlockEntityUtils.MachineDirection.values()).valid(this::isItemValidForSlot));
        } else {
            this.addComponent((IComponent)new ComponentInventory((GenericTile)this));
        }
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        if (tier == 1) {
            this.addComponent((IComponent)new ComponentContainerProvider("launchercontrolpaneltier" + tier, (GenericTile)this).createMenu((id, player) -> new ContainerLauncherControlPanelT1((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        } else if (tier == 2) {
            this.addComponent((IComponent)new ComponentContainerProvider("launchercontrolpaneltier" + tier, (GenericTile)this).createMenu((id, player) -> new ContainerLauncherControlPanelT2((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        } else if (tier == 3) {
            this.addComponent((IComponent)new ComponentContainerProvider("launchercontrolpaneltier" + tier, (GenericTile)this).createMenu((id, player) -> new ContainerLauncherControlPanelT3((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        }
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
    }

    protected void tickServer(ComponentTickable tickable) {
        Object object;
        Direction facing = this.getFacing();
        if (this.launcherPlatform == null) {
            this.launcherPlatform = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(facing.m_122424_()));
        }
        if (this.supportFrame == null) {
            this.supportFrame = new CachedTileOutput(this.f_58857_, this.f_58858_.m_5484_(facing.m_122424_(), 2));
        }
        if (tickable.getTicks() % 20L == 0L) {
            this.launcherPlatform.update(this.f_58858_.m_121945_(facing.m_122424_()));
            this.supportFrame.update(this.f_58858_.m_5484_(facing.m_122424_(), 2));
        }
        if (this.target.getValue() == null) {
            this.target.setValue((Object)this.m_58899_());
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (this.cooldown > 0 || electro.getJoulesStored() < BallistixConstants.MISSILESILO_USAGE * (double)this.getTier()) {
            --this.cooldown;
            return;
        }
        boolean hasRedstone = this.f_58857_.m_276867_(this.m_58899_());
        if (!this.launcherPlatform.valid()) {
            return;
        }
        if (!(this.launcherPlatform.getSafe() instanceof ILauncherPlatform)) {
            return;
        }
        ILauncherPlatform platform = (ILauncherPlatform)this.launcherPlatform.getSafe();
        if (platform == null) {
            return;
        }
        if (!platform.hasMissile() || platform.hasExplosive() && platform.hasSAM() || !platform.hasExplosive() && !platform.hasSAM() || !hasRedstone && !((Boolean)this.shouldLaunch.getValue()).booleanValue()) {
            return;
        }
        int inaccuracy = BallistixConstants.LAUNCH_PLATFORM_DEFAULT_INACCURACY;
        if (this.supportFrame.valid() && (object = this.supportFrame.getSafe()) instanceof ILauncherSupportFrame) {
            ILauncherSupportFrame frame = (ILauncherSupportFrame)object;
            inaccuracy = frame.getInaccuracy();
        }
        this.shouldLaunch.setValue((Object)false);
        double dist = TileLauncherControlPanelT1.calculateDistance(this.f_58858_, (BlockPos)this.target.getValue());
        if ((double)platform.getRange() < dist) {
            return;
        }
        int newCool = platform.launch(this, hasRedstone, inaccuracy);
        if (newCool != -1) {
            this.cooldown = newCool;
        }
        electro.joules(electro.getJoulesStored() - BallistixConstants.MISSILESILO_USAGE * (double)this.getTier());
    }

    protected boolean isItemValidForSlot(int index, ItemStack stack, ComponentInventory inv) {
        return stack.m_41720_() == BallistixItems.ITEM_RADARGUN.get() || stack.m_41720_() == BallistixItems.ITEM_LASERDESIGNATOR.get();
    }

    public void onBlockDestroyed() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        SiloRegistry.unregisterSilo((Integer)this.frequency.getValue(), this);
        ChunkPos pos = this.f_58857_.m_46865_(this.f_58858_).m_7697_();
        ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"ballistix", (BlockPos)this.m_58899_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)false, (boolean)true);
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (this.f_58857_.f_46443_) {
            return;
        }
        ChunkPos pos = this.f_58857_.m_46865_(this.f_58858_).m_7697_();
        ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"ballistix", (BlockPos)this.m_58899_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)true, (boolean)true);
    }

    public void onInventoryChange(ComponentInventory inv, int index) {
        this.handleSync(inv, index);
    }

    private void handleSync(ComponentInventory inv, int index) {
        ItemStack sync = inv.m_8020_(0);
        if (sync.m_41619_()) {
            return;
        }
        if (sync.m_41720_() == BallistixItems.ITEM_LASERDESIGNATOR.get()) {
            CompoundTag nbt = sync.m_41784_();
            nbt.m_128405_("freq", ((Integer)this.frequency.getValue()).intValue());
        } else if (sync.m_41720_() == BallistixItems.ITEM_RADARGUN.get() && sync.m_41784_().m_128441_("loc")) {
            this.target.setValue((Object)ItemRadarGun.getCoordiantes(sync));
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            SiloRegistry.registerSilo((Integer)this.frequency.getValue(), this);
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("silocooldown", this.cooldown);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.cooldown = compound.m_128451_("silocooldown");
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack handStack = player.m_21120_(hand);
        if (handStack.m_41720_() == BallistixItems.ITEM_RADARGUN.get() || handStack.m_41720_() == BallistixItems.ITEM_LASERDESIGNATOR.get()) {
            return InteractionResult.FAIL;
        }
        return super.use(player, hand, hit);
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public BlockPos getPos() {
        return this.m_58899_();
    }

    @Override
    public void launch() {
        this.shouldLaunch.setValue((Object)true);
    }

    @Override
    public void setTarget(BlockPos blockPos) {
        this.target.setValue((Object)blockPos);
    }

    @Override
    public void setTargetFromDesignator(BlockPos target) {
        this.setTarget(new BlockPos(target.m_123341_(), ((BlockPos)this.target.getValue()).m_123342_(), target.m_123343_()));
    }

    @Override
    public BlockPos getTarget() {
        return (BlockPos)this.target.getValue();
    }

    @Override
    public int getFrequency() {
        return (Integer)this.frequency.getValue();
    }

    @Override
    public ILauncherPlatform getPlatform() {
        BlockEntity tile = (BlockEntity)this.launcherPlatform.getSafe();
        if (tile instanceof ILauncherPlatform) {
            return (ILauncherPlatform)tile;
        }
        return null;
    }

    @Override
    public ILauncherSupportFrame getSupportFrame() {
        BlockEntity tile = (BlockEntity)this.supportFrame.getSafe();
        if (tile instanceof ILauncherSupportFrame) {
            return (ILauncherSupportFrame)tile;
        }
        return null;
    }

    public static double calculateDistance(BlockPos fromPos, BlockPos toPos) {
        double deltaX = fromPos.m_123341_() - toPos.m_123341_();
        double deltaY = fromPos.m_123342_() - toPos.m_123342_();
        double deltaZ = fromPos.m_123343_() - toPos.m_123343_();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }
}

