/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile.turret;

import ballistix.api.turret.ITarget;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tags.BallistixTags;
import ballistix.common.tile.radar.TileFireControlRadar;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;
import voltaic.common.item.ItemUpgrade;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.ListProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public abstract class GenericTileTurret
extends GenericTile {
    public final SingleProperty<Vec3> turretRotation = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.VEC3, "turrot", (Object)this.getDefaultOrientation()));
    public final SingleProperty<Vec3> desiredRotation = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.VEC3, "currot", (Object)this.getDefaultOrientation()));
    public final SingleProperty<Vec3> targetMovement = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.VEC3, "movevec", (Object)Vec3.f_82478_));
    public final SingleProperty<Boolean> hasTarget = ((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hastarget", (Object)false))).onChange((prop, val) -> {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (((Boolean)prop.getValue()).booleanValue() && val != prop.getValue()) {
            this.movementCooldown = 0;
        } else if (prop.getValue() != val) {
            this.movementCooldown = 20;
        }
    });
    public final SingleProperty<Boolean> hasNoPower = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "haspower", (Object)false));
    public final SingleProperty<Boolean> inRange = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isrange", (Object)false));
    public final SingleProperty<Double> currentRange;
    public final SingleProperty<Double> inaccuracyMultiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "inaccuracymultiplier", (Object)1.0));
    public final SingleProperty<Boolean> canFire = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "canfire", (Object)false));
    public final ListProperty<String> whitelistedPlayers = (ListProperty)this.property((AbstractProperty)new ListProperty(PropertyTypes.STRING_LIST, "whitelistedplayers", new ArrayList()));
    public final SingleProperty<Integer> entityTargetingMode = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "entitytargetingmode", (Object)0));
    public final double baseRange;
    public final double rotationSpeedRadians;
    public final double usage;
    public final double minimumRange;
    public final double inaccuracy;
    @Nullable
    public ITarget target;
    private int movementCooldown = 0;

    public GenericTileTurret(BlockEntityType<?> tileEntityTypeIn, BlockPos worldPos, BlockState blockState, double baseRange, double minimumRange, double usage, double rotationSpeedRadians, double inaccuracy) {
        super(tileEntityTypeIn, worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(120.0).maxJoules(usage * 20.0));
        this.addComponent((IComponent)this.getInventory().validUpgrades(new SubtypeItemUpgrade[]{SubtypeItemUpgrade.range}));
        this.addComponent((IComponent)this.getContainer());
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
        this.usage = usage;
        this.baseRange = baseRange;
        this.minimumRange = minimumRange;
        this.rotationSpeedRadians = rotationSpeedRadians;
        this.inaccuracy = inaccuracy;
        this.currentRange = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "currentrange", (Object)baseRange));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        this.hasNoPower.setValue((Object)(electro.getJoulesStored() < this.usage ? 1 : 0));
        if (((Boolean)this.hasNoPower.getValue()).booleanValue()) {
            return;
        }
        electro.setJoulesStored(electro.getJoulesStored() - this.usage);
        this.tickServerActive(tickable);
        this.target = this.getTarget(tickable.getTicks());
        if (!this.isValidPlacement()) {
            return;
        }
        this.hasTarget.setValue((Object)(this.target != null ? 1 : 0));
        double distanceToTarget = 0.0;
        if (((Boolean)this.hasTarget.getValue()).booleanValue()) {
            Vec3 interceptionPos = this.getTargetPosition(this.target);
            if (interceptionPos != null) {
                Vec3 launchPos = this.getProjectileLaunchPosition();
                distanceToTarget = TileFireControlRadar.getDistanceToMissile(launchPos, interceptionPos);
                double deltaX = interceptionPos.f_82479_ - launchPos.f_82479_;
                double deltaY = interceptionPos.f_82480_ - launchPos.f_82480_;
                double deltaZ = interceptionPos.f_82481_ - launchPos.f_82481_;
                double sumXZ = deltaX * deltaX + deltaZ * deltaZ;
                double magXZ = Math.sqrt(sumXZ);
                if (magXZ <= 0.0) {
                    magXZ = 1.0;
                }
                double thetaY = Math.atan(deltaY / magXZ);
                this.targetMovement.setValue((Object)new Vec3(deltaX, deltaY, deltaZ).m_82541_());
                this.desiredRotation.setValue((Object)new Vec3(deltaX / magXZ, Math.sin(thetaY), deltaZ / magXZ));
            }
        } else if (this.movementCooldown <= 0) {
            this.desiredRotation.setValue((Object)this.getDefaultOrientation());
        } else {
            --this.movementCooldown;
        }
        this.inRange.setValue((Object)(distanceToTarget >= this.minimumRange && distanceToTarget <= (Double)this.currentRange.getValue() ? 1 : 0));
        if (((Vec3)this.turretRotation.getValue()).equals(this.desiredRotation.getValue())) {
            this.canFire.setValue((Object)((Boolean)this.hasTarget.getValue() != false && (Boolean)this.inRange.getValue() != false ? 1 : 0));
        } else if (this.movementCooldown <= 0) {
            double thetaDesiredXZ = GenericTileTurret.getXZAngleRadians((Vec3)this.desiredRotation.getValue());
            double thetaCurrXZ = GenericTileTurret.getXZAngleRadians((Vec3)this.turretRotation.getValue());
            double angleDifXZ = thetaDesiredXZ - thetaCurrXZ;
            double deltaY = ((Vec3)this.desiredRotation.getValue()).f_82480_ - ((Vec3)this.turretRotation.getValue()).f_82480_;
            if (deltaY < 0.0) {
                this.turretRotation.setValue((Object)((Vec3)this.turretRotation.getValue()).m_82520_(0.0, -Math.cos(this.rotationSpeedRadians) * 0.125, 0.0));
                if (((Vec3)this.turretRotation.getValue()).f_82480_ < this.getMinElevation()) {
                    this.turretRotation.setValue((Object)new Vec3(((Vec3)this.turretRotation.getValue()).f_82479_, Math.max(this.getMinElevation(), ((Vec3)this.desiredRotation.getValue()).f_82480_), ((Vec3)this.turretRotation.getValue()).f_82481_));
                } else if (((Vec3)this.turretRotation.getValue()).f_82480_ < ((Vec3)this.desiredRotation.getValue()).f_82480_) {
                    this.turretRotation.setValue((Object)new Vec3(((Vec3)this.turretRotation.getValue()).f_82479_, ((Vec3)this.desiredRotation.getValue()).f_82480_, ((Vec3)this.turretRotation.getValue()).f_82481_));
                }
            } else if (deltaY > 0.0) {
                this.turretRotation.setValue((Object)((Vec3)this.turretRotation.getValue()).m_82520_(0.0, Math.cos(this.rotationSpeedRadians) * 0.125, 0.0));
                if (((Vec3)this.turretRotation.getValue()).f_82480_ > this.getMaxElevation()) {
                    this.turretRotation.setValue((Object)new Vec3(((Vec3)this.turretRotation.getValue()).f_82479_, Math.min(this.getMaxElevation(), ((Vec3)this.desiredRotation.getValue()).f_82480_), ((Vec3)this.turretRotation.getValue()).f_82481_));
                } else if (((Vec3)this.turretRotation.getValue()).f_82480_ > ((Vec3)this.desiredRotation.getValue()).f_82480_) {
                    this.turretRotation.setValue((Object)new Vec3(((Vec3)this.turretRotation.getValue()).f_82479_, ((Vec3)this.desiredRotation.getValue()).f_82480_, ((Vec3)this.turretRotation.getValue()).f_82481_));
                }
            }
            thetaCurrXZ = angleDifXZ >= 0.0 ? (thetaCurrXZ += this.rotationSpeedRadians) : (thetaCurrXZ -= this.rotationSpeedRadians);
            if (angleDifXZ >= 0.0 && thetaCurrXZ > thetaDesiredXZ) {
                this.turretRotation.setValue((Object)new Vec3(((Vec3)this.desiredRotation.getValue()).f_82479_, ((Vec3)this.turretRotation.getValue()).f_82480_, ((Vec3)this.desiredRotation.getValue()).f_82481_));
            } else if (angleDifXZ < 0.0 && thetaCurrXZ < thetaDesiredXZ) {
                this.turretRotation.setValue((Object)new Vec3(((Vec3)this.desiredRotation.getValue()).f_82479_, ((Vec3)this.turretRotation.getValue()).f_82480_, ((Vec3)this.desiredRotation.getValue()).f_82481_));
            } else {
                this.turretRotation.setValue((Object)new Vec3(Math.cos(thetaCurrXZ), ((Vec3)this.turretRotation.getValue()).f_82480_, Math.sin(thetaCurrXZ)));
            }
            this.canFire.setValue((Object)((Boolean)this.hasTarget.getValue() != false && ((Vec3)this.turretRotation.getValue()).equals(this.desiredRotation.getValue()) && (Boolean)this.inRange.getValue() != false ? 1 : 0));
        } else {
            this.canFire.setValue((Object)false);
        }
        if (((Boolean)this.canFire.getValue()).booleanValue()) {
            this.fireTickServer(tickable.getTicks());
        }
    }

    public void tickClient(ComponentTickable tickable) {
    }

    public abstract ComponentInventory getInventory();

    public abstract ComponentContainerProvider getContainer();

    public abstract void tickServerActive(ComponentTickable var1);

    public abstract void fireTickServer(long var1);

    public abstract Vec3 getDefaultOrientation();

    public abstract Vec3 getProjectileLaunchPosition();

    @Nullable
    public abstract Vec3 getTargetPosition(@Nonnull ITarget var1);

    public abstract double getMinElevation();

    public abstract double getMaxElevation();

    @Nullable
    public abstract ITarget getTarget(long var1);

    public abstract boolean isValidPlacement();

    public void onInventoryChange(ComponentInventory inv, int slot) {
        super.onInventoryChange(inv, slot);
        if (slot >= inv.getUpgradeSlotStartIndex() || slot == -1) {
            int rangeUpgrades = 0;
            for (ItemStack stack : inv.getUpgradeContents()) {
                Item item = stack.m_41720_();
                if (!(item instanceof ItemUpgrade)) continue;
                ItemUpgrade upgrade = (ItemUpgrade)item;
                if (upgrade.subtype != SubtypeItemUpgrade.range) continue;
                rangeUpgrades += stack.m_41613_();
            }
            double inaccuracyMulitplier = 1.0;
            double range = this.baseRange;
            for (int i = 0; i < rangeUpgrades; ++i) {
                inaccuracyMulitplier *= BallistixConstants.RANGE_INCREASE_INACCURACY_MULTIPLIER;
                range += 5.55;
            }
            range = Math.min(range, (double)BallistixConstants.FIRE_CONTROL_RADAR_RANGE);
            this.currentRange.setValue((Object)range);
            this.inaccuracyMultiplier.setValue((Object)inaccuracyMulitplier);
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("turncooldown", this.movementCooldown);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.movementCooldown = compound.m_128451_("turncooldown");
    }

    public static double getXZAngleRadians(Vec3 vector) {
        return Math.atan2(vector.f_82481_, vector.f_82479_);
    }

    public static List<Block> raycastToBlockPos(Level world, Vec3 start, Vec3 end) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Vec3 delta = end.m_82546_(start);
        int maxChecks = (int)Math.ceil(delta.m_82553_());
        delta = delta.m_82541_();
        for (int i = 0; i < maxChecks; ++i) {
            BlockState state;
            start = start.m_82549_(delta);
            BlockPos toCheck = new BlockPos((int)Math.ceil(start.f_82479_), (int)Math.ceil(start.f_82480_), (int)Math.ceil(start.f_82481_));
            if (!toCheck.equals((Object)start) && !toCheck.equals((Object)end) && GenericTileTurret.willStopTurrret(state = world.m_8055_(toCheck))) {
                blocks.add(state.m_60734_());
            }
            if (!(toCheck = new BlockPos((int)Math.ceil(start.f_82479_), (int)Math.ceil(start.f_82480_), (int)Math.floor(start.f_82481_))).equals((Object)start) && !toCheck.equals((Object)end) && GenericTileTurret.willStopTurrret(state = world.m_8055_(toCheck))) {
                blocks.add(state.m_60734_());
            }
            if (!(toCheck = new BlockPos((int)Math.floor(start.f_82479_), (int)Math.ceil(start.f_82480_), (int)Math.ceil(start.f_82481_))).equals((Object)start) && !toCheck.equals((Object)end) && GenericTileTurret.willStopTurrret(state = world.m_8055_(toCheck))) {
                blocks.add(state.m_60734_());
            }
            if (!(toCheck = new BlockPos((int)Math.floor(start.f_82479_), (int)Math.ceil(start.f_82480_), (int)Math.floor(start.f_82481_))).equals((Object)start) && !toCheck.equals((Object)end) && GenericTileTurret.willStopTurrret(state = world.m_8055_(toCheck))) {
                blocks.add(state.m_60734_());
            }
            if (!(toCheck = new BlockPos((int)Math.ceil(start.f_82479_), (int)Math.floor(start.f_82480_), (int)Math.ceil(start.f_82481_))).equals((Object)start) && !toCheck.equals((Object)end) && GenericTileTurret.willStopTurrret(state = world.m_8055_(toCheck))) {
                blocks.add(state.m_60734_());
            }
            if (!(toCheck = new BlockPos((int)Math.ceil(start.f_82479_), (int)Math.floor(start.f_82480_), (int)Math.floor(start.f_82481_))).equals((Object)start) && !toCheck.equals((Object)end) && GenericTileTurret.willStopTurrret(state = world.m_8055_(toCheck))) {
                blocks.add(state.m_60734_());
            }
            if (!(toCheck = new BlockPos((int)Math.floor(start.f_82479_), (int)Math.floor(start.f_82480_), (int)Math.ceil(start.f_82481_))).equals((Object)start) && !toCheck.equals((Object)end) && GenericTileTurret.willStopTurrret(state = world.m_8055_(toCheck))) {
                blocks.add(state.m_60734_());
            }
            if ((toCheck = new BlockPos((int)Math.floor(start.f_82479_), (int)Math.floor(start.f_82480_), (int)Math.floor(start.f_82481_))).equals((Object)start) || toCheck.equals((Object)end) || !GenericTileTurret.willStopTurrret(state = world.m_8055_(toCheck))) continue;
            blocks.add(state.m_60734_());
        }
        return blocks;
    }

    public void setPlacedBy(LivingEntity player, ItemStack stack) {
        super.setPlacedBy(player, stack);
        if (player instanceof Player) {
            Player pl = (Player)player;
            this.whitelistedPlayers.addValue((Object)pl.m_7755_().getString());
        }
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.f_58857_.f_46443_) {
            ChunkPos pos = this.f_58857_.m_46865_(this.m_58899_()).m_7697_();
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"ballistix", (BlockPos)this.m_58899_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)false, (boolean)true);
        }
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (!this.f_58857_.f_46443_) {
            ChunkPos pos = this.f_58857_.m_46865_(this.m_58899_()).m_7697_();
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"ballistix", (BlockPos)this.m_58899_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)true, (boolean)true);
        }
    }

    public static boolean willStopTurrret(BlockState state) {
        if (state.m_60795_()) {
            return false;
        }
        if (state.m_60713_(Blocks.f_50125_) && (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) < 4) {
            return false;
        }
        return !state.m_204336_(BallistixTags.Blocks.WHITELISTED_TURRET_BLOCKS);
    }

    public static enum TargetingMode {
        ALL,
        ONLY_PLAYERS,
        NONE;

    }
}

