/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile.turret.antimissile;

import ballistix.api.missile.MissileManager;
import ballistix.api.missile.virtual.VirtualProjectile;
import ballistix.api.turret.ITarget;
import ballistix.common.inventory.container.ContainerCIWSTurret;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.turret.GenericTileTurret;
import ballistix.common.tile.turret.antimissile.util.TileTurretAntimissileProjectile;
import ballistix.registers.BallistixItems;
import ballistix.registers.BallistixSounds;
import ballistix.registers.BallistixTiles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import voltaic.common.item.ItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileTurretCIWS
extends TileTurretAntimissileProjectile
implements ITickableSound {
    public final SingleProperty<Boolean> outOfAmmo = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "noammo", (Object)false));
    public final SingleProperty<Boolean> firing = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isfiring", (Object)false));
    public final SingleProperty<Boolean> targetingEntity = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "targetingentity", (Object)false));
    private boolean isPlaying = false;
    private LivingEntity livingTarget = null;

    public TileTurretCIWS(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)BallistixTiles.TILE_CIWSTURRET.get(), worldPos, blockState, BallistixConstants.CIWS_TURRET_BASE_RANGE, 0.0, BallistixConstants.CIWS_TURRET_USAGEPERTICK, BallistixConstants.CIWS_TURRET_ROTATIONSPEEDRADIANS, BallistixConstants.CIWS_INNACCURACY);
    }

    @Override
    public ComponentInventory getInventory() {
        return new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(2).upgrades(3)).setDirectionsBySlot(Integer.valueOf(0), BlockEntityUtils.MachineDirection.values()).valid((index, stack, inv) -> {
            if (index < 2) {
                if (stack.m_41720_() != BallistixItems.ITEM_BULLET.get()) return false;
                return true;
            }
            if (index < inv.getUpgradeSlotStartIndex()) return false;
            Item patt2902$temp = stack.m_41720_();
            if (!(patt2902$temp instanceof ItemUpgrade)) return false;
            ItemUpgrade upgrade = (ItemUpgrade)patt2902$temp;
            if (!inv.isUpgradeValid(upgrade.subtype)) return false;
            return true;
        });
    }

    @Override
    public ComponentContainerProvider getContainer() {
        return new ComponentContainerProvider("ciwsturret", (GenericTile)this).createMenu((id, player) -> new ContainerCIWSTurret((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray()));
    }

    @Override
    public void tickServerActive(ComponentTickable tickable) {
        if (!((Boolean)this.canFire.getValue()).booleanValue()) {
            this.firing.setValue((Object)false);
        }
    }

    @Override
    public void fireTickServer(long ticks) {
        int slot;
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack bul = inv.m_8020_(slot = 0);
        if (bul.m_41619_()) {
            slot = 1;
            bul = inv.m_8020_(slot);
        }
        if (bul.m_41619_()) {
            this.outOfAmmo.setValue((Object)true);
            this.firing.setValue((Object)false);
            return;
        }
        this.outOfAmmo.setValue((Object)false);
        this.firing.setValue((Object)true);
        Vec3 trajectory = this.getProjectileTrajectoryFromInaccuracy(this.inaccuracy, this.baseRange, (Double)this.inaccuracyMultiplier.getValue(), this.getProjectileLaunchPosition(), this.getTargetPosition(this.getTarget(ticks)));
        VirtualProjectile.VirtualBullet bullet = new VirtualProjectile.VirtualBullet(this.getProjectileSpeed(), this.getProjectileLaunchPosition(), trajectory, ((Double)this.currentRange.getValue()).floatValue());
        MissileManager.addBullet((ResourceKey<Level>)this.f_58857_.m_46472_(), bullet);
        inv.m_7407_(slot, 1);
    }

    @Override
    public void tickClient(ComponentTickable tickable) {
        if (this.shouldPlaySound() && !this.isPlaying) {
            this.isPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)BallistixSounds.SOUND_CIWS_TURRETFIRING.get()), (SoundSource)SoundSource.BLOCKS, (BlockEntity)this, (float)1.0f, (float)1.0f, (boolean)true);
        }
    }

    @Override
    public Vec3 getProjectileLaunchPosition() {
        BlockPos above = this.m_58899_();
        return new Vec3((double)above.m_123341_() + 0.5, (double)above.m_123342_() + 0.8, (double)above.m_123343_() + 0.5);
    }

    @Override
    public double getMinElevation() {
        return -0.5;
    }

    @Override
    public double getMaxElevation() {
        return 1.0;
    }

    @Override
    public float getProjectileSpeed() {
        return 5.0f;
    }

    public void setNotPlaying() {
        this.isPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.firing.getValue();
    }

    @Override
    @Nullable
    public ITarget getTarget(long ticks) {
        this.targetingEntity.setValue((Object)false);
        ITarget target = super.getTarget(ticks);
        GenericTileTurret.TargetingMode mode = GenericTileTurret.TargetingMode.values()[(Integer)this.entityTargetingMode.getValue()];
        if (target != null || mode == GenericTileTurret.TargetingMode.NONE) {
            this.livingTarget = null;
            return target;
        }
        if (this.livingTarget != null && (this.livingTarget.m_213877_() || this.livingTarget.m_21224_())) {
            this.livingTarget = null;
        }
        if (ticks % 5L == 0L) {
            LivingEntity selected = null;
            double lastMag = 0.0;
            Class type = mode == GenericTileTurret.TargetingMode.ONLY_PLAYERS ? Player.class : LivingEntity.class;
            for (LivingEntity entity : this.f_58857_.m_45976_(type, new AABB(this.m_58899_()).m_82400_((Double)this.currentRange.getValue() / 4.0))) {
                Player player;
                if (!TileTurretCIWS.raycastToBlockPos(this.f_58857_, this.getProjectileLaunchPosition(), entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0)).isEmpty() || entity instanceof Player && ((player = (Player)entity).m_7500_() || ((List)this.whitelistedPlayers.getValue()).contains(player.m_7755_().getString())) || entity.m_21224_() || entity.m_213877_()) continue;
                double deltaX = entity.m_20185_() - (double)this.m_58899_().m_123341_();
                double deltaY = entity.m_20186_() - (double)this.m_58899_().m_123342_();
                double deltaZ = entity.m_20189_() - (double)this.m_58899_().m_123343_();
                double mag = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
                if (selected == null) {
                    selected = entity;
                    lastMag = mag;
                    continue;
                }
                if (!(mag < lastMag)) continue;
                selected = entity;
            }
            this.livingTarget = selected;
        }
        if (this.livingTarget != null) {
            this.targetingEntity.setValue((Object)true);
            return new ITarget.TargetLivingEntity(this.livingTarget);
        }
        return null;
    }

    @Override
    public boolean isValidPlacement() {
        return (Boolean)this.targetingEntity.getValue() != false || super.isValidPlacement();
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(3.0);
    }
}

