/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile.turret.antimissile;

import ballistix.api.missile.virtual.VirtualMissile;
import ballistix.api.turret.ITarget;
import ballistix.common.inventory.container.ContainerLaserTurret;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.radar.TileFireControlRadar;
import ballistix.common.tile.turret.GenericTileTurret;
import ballistix.common.tile.turret.antimissile.util.TileTurretAntimissile;
import ballistix.registers.BallistixDamageTypes;
import ballistix.registers.BallistixSounds;
import ballistix.registers.BallistixTiles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileTurretLaser
extends TileTurretAntimissile
implements ITickableSound {
    public final SingleProperty<Vec3> targetPos = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.VEC3, "targetposition", (Object)TileFireControlRadar.OUT_OF_REACH));
    public final SingleProperty<Boolean> targetingEntity = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "targetingentity", (Object)false));
    public final SingleProperty<Double> heat = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "heat", (Object)0.0));
    public final SingleProperty<Boolean> overheated = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "overheated", (Object)false));
    public final SingleProperty<Boolean> firing = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isfiring", (Object)false));
    private LivingEntity livingTarget = null;
    private boolean isPlaying = false;

    public TileTurretLaser(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)BallistixTiles.TILE_LASERTURRET.get(), worldPos, blockState, BallistixConstants.LASER_TURRET_BASE_RANGE, 0.0, BallistixConstants.LASER_TURRET_USAGEPERTICK, BallistixConstants.LASER_TURRET_ROTATIONSPEEDRADIANS, 0.0);
    }

    @Override
    public ComponentInventory getInventory() {
        return new ComponentInventory((GenericTile)this);
    }

    @Override
    public ComponentContainerProvider getContainer() {
        return new ComponentContainerProvider("laserturret", (GenericTile)this).createMenu((id, player) -> new ContainerLaserTurret((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray()));
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        if ((Double)this.heat.getValue() > 0.0) {
            this.heat.setValue((Object)((Double)this.heat.getValue() - 1.0));
        }
        if (!((Boolean)this.canFire.getValue()).booleanValue()) {
            this.firing.setValue((Object)false);
        }
        if ((Double)this.heat.getValue() < BallistixConstants.LASER_TURRET_COOLTHRESHHOLD) {
            this.overheated.setValue((Object)false);
            this.firing.setValue((Object)false);
        }
        super.tickServer(tickable);
    }

    @Override
    public void tickServerActive(ComponentTickable tickable) {
    }

    @Override
    public void fireTickServer(long ticks) {
        if (((Boolean)this.overheated.getValue()).booleanValue()) {
            this.firing.setValue((Object)false);
            return;
        }
        this.firing.setValue((Object)true);
        double distanceToTarget = TileFireControlRadar.getDistanceToMissile(this.getProjectileLaunchPosition(), this.target.getTargetLocation());
        double multiplier = 1.0 - distanceToTarget / (Double)this.currentRange.getValue();
        float damage = (float)(multiplier * BallistixConstants.LASER_TURRET_BASE_DAMAGE);
        if (this.livingTarget == null) {
            VirtualMissile missile = (VirtualMissile)this.target.getTarget();
            missile.health -= damage;
        } else {
            this.livingTarget.m_6469_(this.livingTarget.m_269291_().m_269079_(BallistixDamageTypes.LASER_TURRET), damage);
            this.livingTarget.m_20254_(10);
        }
        this.heat.setValue((Object)((Double)this.heat.getValue() + 2.0));
        if ((Double)this.heat.getValue() > BallistixConstants.LASER_TURRET_MAXHEAT) {
            this.overheated.setValue((Object)true);
        }
    }

    @Override
    public void tickClient(ComponentTickable tickable) {
        if (this.shouldPlaySound() && !this.isPlaying) {
            this.isPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)BallistixSounds.SOUND_LASER_TURRETFIRING.get()), (SoundSource)SoundSource.BLOCKS, (BlockEntity)this, (float)1.0f, (float)1.0f, (boolean)true);
        }
        if (((Boolean)this.overheated.getValue()).booleanValue() && this.f_58857_.f_46441_.m_188500_() < 0.5) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)this.m_58899_().m_123341_() + this.f_58857_.f_46441_.m_188500_(), (double)this.m_58899_().m_123342_() + this.f_58857_.f_46441_.m_188500_(), (double)this.m_58899_().m_123343_() + this.f_58857_.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public Vec3 getProjectileLaunchPosition() {
        BlockPos above = this.m_58899_();
        return new Vec3((double)above.m_123341_() + 0.5, (double)above.m_123342_() + 1.03125, (double)above.m_123343_() + 0.5);
    }

    @Override
    @Nullable
    public Vec3 getTargetPosition(@NotNull ITarget target) {
        return target.getTargetLocation();
    }

    @Override
    public double getMinElevation() {
        return -0.5;
    }

    @Override
    public double getMaxElevation() {
        return 1.0;
    }

    @Override
    @Nullable
    public ITarget getTarget(long ticks) {
        this.targetingEntity.setValue((Object)false);
        ITarget target = super.getTarget(ticks);
        GenericTileTurret.TargetingMode mode = GenericTileTurret.TargetingMode.values()[(Integer)this.entityTargetingMode.getValue()];
        if (target != null && TileTurretLaser.raycastToBlockPos(this.f_58857_, this.getProjectileLaunchPosition(), target.getTargetLocation()).isEmpty()) {
            this.livingTarget = null;
            this.targetPos.setValue((Object)target.getTargetLocation());
            return target;
        }
        if (mode == GenericTileTurret.TargetingMode.NONE) {
            this.livingTarget = null;
            this.targetPos.setValue((Object)TileFireControlRadar.OUT_OF_REACH);
            return null;
        }
        if (this.livingTarget != null && (this.livingTarget.m_213877_() || this.livingTarget.m_21224_())) {
            this.livingTarget = null;
        }
        if (ticks % 5L == 0L) {
            LivingEntity selected = null;
            double lastMag = 0.0;
            Class type = mode == GenericTileTurret.TargetingMode.ONLY_PLAYERS ? Player.class : LivingEntity.class;
            for (LivingEntity entity : this.f_58857_.m_45976_(type, new AABB(this.m_58899_()).m_82400_((Double)this.currentRange.getValue() / 4.0))) {
                Player player;
                if (!TileTurretLaser.raycastToBlockPos(this.f_58857_, this.getProjectileLaunchPosition(), entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0)).isEmpty() || entity instanceof Player && ((player = (Player)entity).m_7500_() || ((List)this.whitelistedPlayers.getValue()).contains(player.m_7755_().getString())) || entity.m_21224_() || entity.m_213877_()) continue;
                double deltaX = entity.m_20185_() - (double)this.m_58899_().m_123341_();
                double deltaY = entity.m_20186_() - (double)this.m_58899_().m_123342_();
                double deltaZ = entity.m_20189_() - (double)this.m_58899_().m_123343_();
                double mag = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
                if (selected == null) {
                    selected = entity;
                    lastMag = mag;
                    continue;
                }
                if (!(mag < lastMag)) continue;
                selected = entity;
            }
            this.livingTarget = selected;
        }
        if (this.livingTarget != null) {
            target = new ITarget.TargetLivingEntity(this.livingTarget);
            this.targetingEntity.setValue((Object)true);
            this.targetPos.setValue((Object)target.getTargetLocation());
            return target;
        }
        this.targetPos.setValue((Object)TileFireControlRadar.OUT_OF_REACH);
        return null;
    }

    @Override
    public boolean isValidPlacement() {
        return (Boolean)this.targetingEntity.getValue() != false || super.isValidPlacement();
    }

    public void setNotPlaying() {
        this.isPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.firing.getValue() != false && (Boolean)this.hasNoPower.getValue() == false;
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

