/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile.turret.antimissile;

import ballistix.api.missile.MissileManager;
import ballistix.api.missile.virtual.VirtualProjectile;
import ballistix.common.inventory.container.ContainerSAMTurret;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.turret.antimissile.util.TileTurretAntimissileProjectile;
import ballistix.registers.BallistixItems;
import ballistix.registers.BallistixSounds;
import ballistix.registers.BallistixTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import voltaic.common.item.ItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileTurretSAM
extends TileTurretAntimissileProjectile {
    public final SingleProperty<Integer> cooldown = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "cooldown", (Object)0));
    public final SingleProperty<Boolean> outOfAmmo = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "noammo", (Object)false));

    public TileTurretSAM(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)BallistixTiles.TILE_SAMTURRET.get(), worldPos, blockState, BallistixConstants.SAM_TURRET_BASE_RANGE, 100.0, BallistixConstants.SAM_TURRET_USAGEPERTICK, BallistixConstants.SAM_TURRET_ROTATIONSPEEDRADIANS, 1.0);
    }

    @Override
    public ComponentInventory getInventory() {
        return new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1).upgrades(3)).setDirectionsBySlot(Integer.valueOf(0), BlockEntityUtils.MachineDirection.values()).valid((index, stack, inv) -> {
            if (index == 0) {
                if (stack.m_41720_() != BallistixItems.ITEM_AAMISSILE.get()) return false;
                return true;
            }
            if (index < inv.getUpgradeSlotStartIndex()) return false;
            Item patt2331$temp = stack.m_41720_();
            if (!(patt2331$temp instanceof ItemUpgrade)) return false;
            ItemUpgrade upgrade = (ItemUpgrade)patt2331$temp;
            if (!inv.isUpgradeValid(upgrade.subtype)) return false;
            return true;
        });
    }

    @Override
    public ComponentContainerProvider getContainer() {
        return new ComponentContainerProvider("samturret", (GenericTile)this).createMenu((id, player) -> new ContainerSAMTurret((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray()));
    }

    @Override
    public void tickServerActive(ComponentTickable tickable) {
        if ((Integer)this.cooldown.getValue() > 0) {
            this.cooldown.setValue((Object)((Integer)this.cooldown.getValue() - 1));
        }
    }

    @Override
    public void fireTickServer(long ticks) {
        if ((Integer)this.cooldown.getValue() > 0) {
            return;
        }
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack missile = inv.m_8020_(0);
        if (missile.m_41619_()) {
            this.outOfAmmo.setValue((Object)true);
            return;
        }
        this.outOfAmmo.setValue((Object)false);
        VirtualProjectile.VirtualSAM sam = new VirtualProjectile.VirtualSAM(0.0f, this.getProjectileLaunchPosition(), (Vec3)this.targetMovement.getValue(), ((Double)this.currentRange.getValue()).floatValue(), (BlockPos)this.boundFireControl.getValue(), 0);
        MissileManager.addSAM((ResourceKey<Level>)this.f_58857_.m_46472_(), sam);
        this.f_58857_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)BallistixSounds.SOUND_MISSILE_ROCKETLAUNCHER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.cooldown.setValue((Object)BallistixConstants.SAM_TURRET_COOLDOWN);
        inv.m_7407_(0, 1);
    }

    @Override
    public Vec3 getProjectileLaunchPosition() {
        BlockPos above = this.m_58899_().m_7494_();
        return new Vec3((double)above.m_123341_() + 0.5, (double)above.m_123342_() + 0.5, (double)above.m_123343_() + 0.5);
    }

    @Override
    public float getProjectileSpeed() {
        return BallistixConstants.SAM_TOP_SPEED;
    }

    @Override
    public double getMinElevation() {
        return -0.5;
    }

    @Override
    public double getMaxElevation() {
        return 1.0;
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(3.0);
    }
}

