/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile.turret.antimissile.util;

import ballistix.api.turret.ITarget;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.radar.TileFireControlRadar;
import ballistix.common.tile.turret.GenericTileTurret;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.utilities.BlockEntityUtils;

public abstract class TileTurretAntimissile
extends GenericTileTurret {
    public final SingleProperty<Boolean> isNotLinked = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "islinked", (Object)false));
    public final SingleProperty<BlockPos> boundFireControl = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "bound", (Object)BlockEntityUtils.OUT_OF_REACH));
    @javax.annotation.Nullable
    private TileFireControlRadar radar;

    public TileTurretAntimissile(BlockEntityType<?> tileEntityTypeIn, BlockPos worldPos, BlockState blockState, double range, double minRange, double usage, double rotationSpeedRadians, double inaccuracy) {
        super(tileEntityTypeIn, worldPos, blockState, range, minRange, usage, rotationSpeedRadians, inaccuracy);
    }

    public boolean bindFireControlRadar(BlockPos pos) {
        double distance = TileTurretAntimissile.getDistanceToPos(this.m_58899_(), pos);
        if (distance > BallistixConstants.MAX_DISTANCE_FROM_RADAR) {
            return false;
        }
        this.boundFireControl.setValue((Object)pos);
        return true;
    }

    @Override
    public boolean isValidPlacement() {
        return this.f_58857_.m_45517_(LightLayer.SKY, this.m_58899_()) > 0;
    }

    @Override
    public Vec3 getDefaultOrientation() {
        Direction facing = this.getFacing();
        double mag = Math.sqrt(facing.m_122429_() * facing.m_122429_() + facing.m_122431_() * facing.m_122431_());
        if (mag <= 0.0) {
            mag = 1.0;
        }
        return new Vec3((double)facing.m_122429_() / mag, 0.0, (double)facing.m_122431_() / mag);
    }

    @Override
    @Nullable
    public ITarget getTarget(long ticks) {
        if (ticks % 10L == 0L) {
            BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)this.boundFireControl.getValue());
            if (blockEntity instanceof TileFireControlRadar) {
                TileFireControlRadar fire;
                this.radar = fire = (TileFireControlRadar)blockEntity;
            } else {
                this.radar = null;
                this.boundFireControl.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
            }
        }
        this.isNotLinked.setValue((Object)(this.radar == null ? 1 : 0));
        if (((Boolean)this.isNotLinked.getValue()).booleanValue()) {
            return null;
        }
        if (this.radar.tracking == null || this.radar.tracking.hasExploded()) {
            return null;
        }
        return new ITarget.TargetMissile(this.radar.tracking);
    }

    public static double getDistanceToPos(BlockPos start, BlockPos end) {
        double deltaX = end.m_123341_() - start.m_123341_();
        double deltaY = end.m_123342_() - start.m_123342_();
        double deltaZ = end.m_123343_() - start.m_123343_();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }
}

