/*
 * Decompiled with CFR 0.152.
 */
package ballistix.prefab.screen;

import ballistix.client.screen.ScreenProximityDetector;
import ballistix.common.inventory.container.ContainerProximityDetector;
import ballistix.common.tile.TileProximityDetector;
import ballistix.prefab.BallistixIconTypes;
import ballistix.prefab.screen.ScreenComponentWhitelistedPlayer;
import ballistix.prefab.utils.BallistixTextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.ScreenComponentVerticalSlider;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class WrapperPlayerWhitelistDetector {
    private final ScreenProximityDetector screen;
    public ScreenComponentButton<?> button;
    private ScreenComponentButton<?> add;
    private ScreenComponentSimpleLabel whitelistLabel;
    private ScreenComponentButton[] deleteButtons = new ScreenComponentButton[5];
    private ScreenComponentWhitelistedPlayer[] players = new ScreenComponentWhitelistedPlayer[5];
    public ScreenComponentEditBox addEditBox;
    private int topRowIndex = 0;
    private int lastRowCount = 0;
    private static final int BUTTON_COUNT = 5;

    public WrapperPlayerWhitelistDetector(ScreenProximityDetector screen, int tabX, int tabY, int x, int y) {
        int i;
        this.screen = screen;
        this.button = (ScreenComponentButton)new ScreenComponentButton((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, tabX, tabY).setOnPress(button -> {
            boolean bl = button.isPressed = !button.isPressed;
            if (button.isPressed) {
                this.updateVisibility(true);
                screen.whitelistSlider.setVisible(true);
                screen.updateVisibility(false);
            } else {
                this.updateVisibility(false);
                screen.whitelistSlider.setVisible(false);
                screen.updateVisibility(true);
            }
        }).onTooltip((graphics, but, xAxis, yAxis) -> {
            ScreenComponentButton button = (ScreenComponentButton)but;
            ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
            tooltips.add(BallistixTextUtils.tooltip("turret.whitelistmanager", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
            if (!button.isPressed) {
                tooltips.add(VoltaicTextUtils.tooltip((String)"inventoryio.presstoshow", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            } else {
                tooltips.add(VoltaicTextUtils.tooltip((String)"inventoryio.presstohide", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            graphics.m_280666_(screen.getFontRenderer(), tooltips, xAxis, yAxis);
        }).setIcon((ITexture)BallistixIconTypes.PLAYER_WHITELIST);
        screen.addComponent((AbstractScreenComponent)this.button);
        this.whitelistLabel = new ScreenComponentSimpleLabel(x + 10, y + 23, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("turret.playerwhitelist.newplayer", new Object[0]));
        screen.addComponent((AbstractScreenComponent)this.whitelistLabel);
        this.add = new ScreenComponentButton(x + 10, y + 52, 156, 20).setOnPress(button -> {
            TileProximityDetector turret = (TileProximityDetector)((ContainerProximityDetector)screen.m_6262_()).getSafeHost();
            if (turret == null) {
                return;
            }
            turret.whitelistedPlayers.addValue((Object)this.addEditBox.getValue());
        }).setLabel((Component)BallistixTextUtils.gui("turret.playerwhitelist.add", new Object[0]));
        screen.addComponent((AbstractScreenComponent)this.add);
        this.addEditBox = new ScreenComponentEditBox(x + 10, y + 35, 156, 15, screen.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(50);
        screen.addEditBox(this.addEditBox);
        int butOffX = 25;
        int butOffY = 80;
        for (i = 0; i < 5; ++i) {
            this.players[i] = new ScreenComponentWhitelistedPlayer(x + butOffX, y + butOffY + 15 * i, 125, 15);
        }
        for (i = 0; i < 5; ++i) {
            int index = i;
            this.deleteButtons[i] = (ScreenComponentButton)new ScreenComponentButton(x + butOffX + 125, y + butOffY + 15 * i, 15, 15).setOnPress(but -> {
                ScreenComponentWhitelistedPlayer player = this.players[index];
                TileProximityDetector tile = (TileProximityDetector)((ContainerProximityDetector)screen.m_6262_()).getSafeHost();
                if (player.getName() == null) {
                    return;
                }
                tile.whitelistedPlayers.removeValue((Object)player.getName());
            }).onTooltip((graphics, button, xAxis, yAxis) -> graphics.m_280557_(screen.getFontRenderer(), (Component)BallistixTextUtils.tooltip("radar.frequencymanager.delete", new Object[0]), xAxis, yAxis)).setIcon((ITexture)BallistixIconTypes.DELETE);
        }
        screen.addComponent((AbstractScreenComponent)this.button);
        screen.addComponent((AbstractScreenComponent)this.add);
        screen.addComponent((AbstractScreenComponent)this.whitelistLabel);
        screen.addComponent((AbstractScreenComponent)this.addEditBox);
        for (i = 0; i < 5; ++i) {
            screen.addComponent((AbstractScreenComponent)this.players[i]);
        }
        for (i = 0; i < 5; ++i) {
            screen.addComponent((AbstractScreenComponent)this.deleteButtons[i]);
        }
        this.updateVisibility(false);
    }

    public void tick() {
        TileProximityDetector tile = (TileProximityDetector)((ContainerProximityDetector)this.screen.m_6262_()).getSafeHost();
        if (tile == null) {
            return;
        }
        List frequencyList = (List)tile.whitelistedPlayers.getValue();
        this.lastRowCount = frequencyList.size();
        for (int i = 0; i < 5; ++i) {
            ScreenComponentWhitelistedPlayer button = this.players[i];
            int index = this.topRowIndex + i;
            if (index < frequencyList.size()) {
                button.setFrequency((String)frequencyList.get(index));
                continue;
            }
            button.setFrequency(null);
        }
        ScreenComponentVerticalSlider slider = this.screen.whitelistSlider;
        if (this.lastRowCount > 5) {
            slider.updateActive(true);
            if (!slider.isSliderHeld()) {
                int moveRoom = this.screen.whitelistSlider.height - 15 - 2;
                double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                slider.setSliderYOffset((int)((double)moveRoom * moved));
            }
        } else {
            slider.updateActive(false);
            slider.setSliderYOffset(0);
            this.topRowIndex = 0;
        }
    }

    public void handleMouseScroll(int dir) {
        if (Screen.m_96637_()) {
            dir *= 4;
        }
        int lastRowIndex = this.lastRowCount - 1;
        if (this.lastRowCount > 5) {
            if (this.topRowIndex >= this.lastRowCount) {
                this.topRowIndex = lastRowIndex - 4;
            }
            this.topRowIndex = Mth.m_14045_((int)(this.topRowIndex += dir), (int)0, (int)(lastRowIndex - 4));
        } else {
            this.topRowIndex = 0;
        }
    }

    public Consumer<Integer> getSliderClickedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.whitelistSlider;
            if (slider.isSliderActive()) {
                int sliderY = slider.yLocation;
                int sliderHeight = slider.height;
                int mouseHeight = mouseY - sliderY;
                if (mouseHeight >= sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else if (mouseHeight <= 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else {
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                    int moveRoom = slider.height - 15 - 2;
                    double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                    slider.setSliderYOffset((int)((double)moveRoom * moved));
                }
            }
        };
    }

    public Consumer<Integer> getSliderDraggedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.whitelistSlider;
            if (slider.isSliderActive()) {
                int sliderY = slider.yLocation;
                int sliderHeight = slider.height;
                if (mouseY <= sliderY + 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else if (mouseY >= sliderY + sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else {
                    int mouseHeight = mouseY - sliderY;
                    slider.setSliderYOffset(mouseHeight);
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                }
            }
        };
    }

    public void updateVisibility(boolean show) {
        this.add.setVisible(show);
        this.whitelistLabel.setVisible(show);
        for (ScreenComponentWhitelistedPlayer screenComponentWhitelistedPlayer : this.players) {
            screenComponentWhitelistedPlayer.setVisible(show);
        }
        for (ScreenComponentWhitelistedPlayer screenComponentWhitelistedPlayer : this.deleteButtons) {
            screenComponentWhitelistedPlayer.setVisible(show);
        }
        this.addEditBox.setVisible(show);
        this.addEditBox.setValue("");
    }
}

