/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.RedstoneControl;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.NasaWorkbenchMenu;
import earth.terrarium.adastra.common.recipes.machines.NasaWorkbenchRecipe;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import earth.terrarium.adastra.common.utils.ModUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NasaWorkbenchBlockEntity
extends ContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS));
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    protected final RecipeManager.CachedCheck<Container, NasaWorkbenchRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)ModRecipeTypes.NASA_WORKBENCH.get()));
    @Nullable
    protected NasaWorkbenchRecipe recipe;

    public NasaWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, 15);
        this.setRedstoneControl(RedstoneControl.NEVER_ON);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new NasaWorkbenchMenu(id, inventory, this);
    }

    @Override
    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        for (int i = 0; i < 14; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            this.spawnWorkingParticles(level, pos);
            break;
        }
        if (this.recipe != null && this.canCraft()) {
            this.m_6836_(14, this.recipe.result());
        } else {
            this.m_6836_(14, ItemStack.f_41583_);
        }
        if (time % 30L == 0L && this.canFunction() && this.canCraft()) {
            this.craft();
        }
    }

    @Override
    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pushItemsNearby(this, pos, INPUT_SLOTS, sideConfig.get(0), filter);
        TransferUtils.pullItemsNearby(this, pos, INPUT_SLOTS, sideConfig.get(0), filter);
    }

    @Override
    public void update() {
        if (this.level().m_5776_()) {
            return;
        }
        this.recipe = this.quickCheck.m_213657_((Container)this, this.level()).orElse(null);
    }

    public boolean canCraft() {
        return this.recipe != null && this.recipe.m_5818_(this, this.level());
    }

    public void craft() {
        if (this.recipe == null) {
            return;
        }
        this.spawnResultParticles();
        Containers.m_18992_((Level)this.level(), (double)this.m_58899_().m_123341_(), (double)(this.m_58899_().m_123342_() + 1), (double)this.m_58899_().m_123343_(), (ItemStack)this.m_8020_(14).m_41777_());
        this.m_6836_(14, ItemStack.f_41583_);
        for (int i = 0; i < 14; ++i) {
            this.m_8020_(i).m_41774_(1);
        }
        this.recipe = null;
    }

    public void spawnWorkingParticles(ServerLevel level, BlockPos pos) {
        ModUtils.sendParticles(level, ParticleTypes.f_175830_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 3, 0.12, 0.12, 0.12, 0.15);
    }

    public void spawnResultParticles() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            ModUtils.sendParticles(serverLevel, ParticleTypes.f_123767_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 100, 0.1, 0.1, 0.1, 0.7);
            serverLevel.m_5594_(null, pos, SoundEvents.f_12513_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return INPUT_SLOTS;
    }
}

