/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.recipe.CodecRecipe;
import earth.terrarium.adastra.common.recipes.base.IngredientHolder;
import earth.terrarium.adastra.common.registry.ModRecipeSerializers;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record SpaceStationRecipe(ResourceLocation id, List<IngredientHolder> ingredients, ResourceKey<Level> dimension, ResourceLocation structure) implements CodecRecipe<Container>
{
    public static Codec<SpaceStationRecipe> codec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)id), (App)IngredientHolder.CODEC.listOf().fieldOf("ingredients").forGetter(SpaceStationRecipe::ingredients), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("dimension").forGetter(SpaceStationRecipe::dimension), (App)ResourceLocation.f_135803_.fieldOf("structure").forGetter(SpaceStationRecipe::structure)).apply((Applicative)instance, SpaceStationRecipe::new));
    }

    public static Codec<SpaceStationRecipe> netCodec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)id), (App)IngredientHolder.NETWORK_CODEC.listOf().fieldOf("ingredients").forGetter(SpaceStationRecipe::ingredients), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("dimension").forGetter(SpaceStationRecipe::dimension), (App)ResourceLocation.f_135803_.fieldOf("structure").forGetter(SpaceStationRecipe::structure)).apply((Applicative)instance, SpaceStationRecipe::new));
    }

    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        for (IngredientHolder holder : this.ingredients) {
            int count = 0;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!holder.ingredient().test(stack)) continue;
                count += stack.m_41613_();
            }
            if (count >= holder.count()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SPACE_STATION_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.SPACE_STATION_RECIPE.get();
    }

    public static Optional<SpaceStationRecipe> getSpaceStation(Level level, ResourceKey<Level> dimension) {
        return level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.SPACE_STATION_RECIPE.get()).stream().filter(r -> dimension.equals(r.dimension())).findFirst();
    }

    public static boolean hasIngredients(Player player, Level level, SpaceStationRecipe recipe) {
        if (player.m_7500_() || player.m_5833_()) {
            return true;
        }
        return recipe.m_5818_((Container)player.m_150109_(), level);
    }

    public static void consumeIngredients(Player player, Level level) {
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        SpaceStationRecipe recipe = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.SPACE_STATION_RECIPE.get()).stream().filter(r -> level.m_46472_().equals(r.dimension())).findFirst().orElse(null);
        if (recipe == null) {
            return;
        }
        if (!recipe.m_5818_((Container)player.m_150109_(), level)) {
            return;
        }
        Inventory inventory = player.m_150109_();
        block0: for (IngredientHolder holder : recipe.ingredients()) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                if (!holder.ingredient().test(inventory.m_8020_(i))) continue;
                inventory.m_7407_(i, holder.count());
                continue block0;
            }
        }
    }
}

