/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.electricity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.object.TransferPack;

public interface ICapabilityElectrodynamic {
    public double getJoulesStored();

    public double getMaxJoulesStored();

    public void setJoulesStored(double var1);

    default public double getVoltage() {
        return 120.0;
    }

    default public double getMinimumVoltage() {
        return this.getVoltage();
    }

    default public double getMaximumVoltage() {
        return this.getVoltage();
    }

    default public double getAmpacity() {
        return -1.0;
    }

    public boolean isEnergyReceiver();

    public boolean isEnergyProducer();

    default public TransferPack extractPower(TransferPack transfer, boolean debug) {
        if (!this.isEnergyProducer()) {
            return TransferPack.EMPTY;
        }
        double taken = Math.min(transfer.getJoules(), this.getJoulesStored());
        if (!debug && taken > 0.0) {
            if (transfer.getVoltage() == this.getVoltage()) {
                this.setJoulesStored(this.getJoulesStored() - taken);
                this.onChange();
            }
            if (transfer.getVoltage() > this.getVoltage()) {
                this.overVoltage(transfer);
                return TransferPack.EMPTY;
            }
        }
        return TransferPack.joulesVoltage(taken, transfer.getVoltage());
    }

    default public TransferPack receivePower(TransferPack transfer, boolean debug) {
        if (!this.isEnergyReceiver()) {
            return TransferPack.EMPTY;
        }
        double received = Math.max(0.0, Math.min(transfer.getJoules(), this.getMaxJoulesStored() - this.getJoulesStored()));
        if (!debug && received > 0.0) {
            if (transfer.getVoltage() == this.getVoltage() || this.getVoltage() == -1.0) {
                this.setJoulesStored(this.getJoulesStored() + received);
                this.onChange();
            }
            if (transfer.getVoltage() > this.getVoltage() && this.getVoltage() != -1.0) {
                this.overVoltage(transfer);
                return TransferPack.EMPTY;
            }
        }
        return TransferPack.joulesVoltage(received, transfer.getVoltage());
    }

    default public void overVoltage(TransferPack transfer) {
        ICapabilityElectrodynamic iCapabilityElectrodynamic = this;
        if (iCapabilityElectrodynamic instanceof BlockEntity) {
            BlockEntity tile = (BlockEntity)iCapabilityElectrodynamic;
            world = tile.m_58904_();
            BlockPos pos = tile.m_58899_();
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            world.m_254849_(null, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), (float)Math.log10(10.0 + transfer.getVoltage() / this.getVoltage()), Level.ExplosionInteraction.BLOCK);
        } else {
            ComponentElectrodynamic electro;
            GenericTile tile;
            world = this;
            if (world instanceof ComponentElectrodynamic && (tile = (electro = (ComponentElectrodynamic)world).getHolder()) != null) {
                Level world = tile.m_58904_();
                BlockPos pos = tile.m_58899_();
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                world.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (float)Math.log10(10.0 + transfer.getVoltage() / this.getVoltage()), Level.ExplosionInteraction.BLOCK);
            }
        }
    }

    public void onChange();

    public TransferPack getConnectedLoad(LoadProfile var1, Direction var2);

    public record LoadProfile(TransferPack lastUsage, TransferPack maximumAvailable) {
    }
}

