/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.gas;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import voltaic.prefab.utilities.math.Color;
import voltaic.registers.VoltaicGases;
import voltaic.registers.VoltaicRegistries;

public class Gas {
    public static final int ROOM_TEMPERATURE = 293;
    public static final int PRESSURE_AT_SEA_LEVEL = 1;
    public static final int MINIMUM_HEAT_BURN_TEMP = 327;
    public static final int MINIMUM_FREEZE_TEMP = 260;
    private final Supplier<Item> container;
    private final Component description;
    private final int condensationTemp;
    @Nullable
    private final Supplier<Fluid> condensedFluid;
    private final Color color;

    public Gas(Supplier<Item> container, Component description, Color color) {
        this.container = container;
        this.description = description;
        this.condensationTemp = 0;
        this.condensedFluid = () -> Fluids.f_76191_;
        this.color = color;
    }

    public Gas(Supplier<Item> container, Component description, int condensationTemp, Color color, Supplier<Fluid> condensedFluid) {
        this.container = container;
        this.description = description;
        this.condensationTemp = condensationTemp;
        this.condensedFluid = condensedFluid;
        this.color = color;
    }

    public Component getDescription() {
        return this.description;
    }

    public Item getContainer() {
        return this.container.get();
    }

    public Holder<Gas> getBuiltInRegistry() {
        return (Holder)VoltaicRegistries.gasRegistry().getHolder((Object)this).get();
    }

    public boolean isEmpty() {
        return this == VoltaicGases.EMPTY.get();
    }

    public int getCondensationTemp() {
        return this.condensationTemp;
    }

    public boolean noCondensedFluid() {
        return this.condensedFluid == null || this.condensedFluid.get() == Fluids.f_76191_;
    }

    public Fluid getCondensedFluid() {
        return this.condensedFluid.get();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Gas) {
            Gas other = (Gas)obj;
            return other == this;
        }
        return false;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.description.getString() + ",\tcondensation temp : " + this.condensationTemp + " K,\tcondensed fluid: " + this.getCondensedFluid().getFluidType().getDescription().getString();
    }

    public boolean doesCondense() {
        return this.condensationTemp > 0;
    }
}

