/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.gas;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Nullable;
import voltaic.api.codec.StreamCodec;
import voltaic.api.gas.Gas;
import voltaic.registers.VoltaicGases;
import voltaic.registers.VoltaicRegistries;

public class GasStack {
    public static final Codec<GasStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VoltaicRegistries.gasRegistry().getCodec().fieldOf("gas").forGetter(instance0 -> instance0.getGas() == null ? (Gas)VoltaicGases.EMPTY.get() : instance0.getGas()), (App)Codec.INT.fieldOf("amount").forGetter(instance0 -> instance0.amount), (App)Codec.INT.fieldOf("temp").forGetter(instance0 -> instance0.temperature), (App)Codec.INT.fieldOf("pressure").forGetter(instance0 -> instance0.pressure)).apply((Applicative)instance, GasStack::new));
    public static final StreamCodec<FriendlyByteBuf, GasStack> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, GasStack>(){

        @Override
        public GasStack decode(FriendlyByteBuf buffer) {
            Gas gas = (Gas)buffer.readRegistryId();
            int amount = buffer.readInt();
            int temperature = buffer.readInt();
            int pressure = buffer.readInt();
            return new GasStack(gas, amount, temperature, pressure);
        }

        @Override
        public void encode(FriendlyByteBuf buffer, GasStack value) {
            buffer.writeRegistryId(VoltaicRegistries.gasRegistry(), (Object)(value.gas == null ? (Gas)VoltaicGases.EMPTY.get() : value.gas));
            buffer.writeInt(value.amount);
            buffer.writeInt(value.temperature);
            buffer.writeInt(value.pressure);
        }
    };
    public static final GasStack EMPTY = new GasStack(null);
    public static final int ABSOLUTE_ZERO = 1;
    public static final int VACUUM = 1;
    private final Gas gas;
    private int amount = 0;
    private int temperature = 293;
    private int pressure = 1;

    private GasStack(@Nullable Void unused) {
        this.gas = null;
    }

    public GasStack(@NonNull Gas gas, int amount, int temperature, int pressure) {
        this.gas = gas;
        this.amount = amount;
        this.temperature = temperature;
        this.pressure = pressure;
    }

    public GasStack(@NonNull Holder<Gas> gas, int amount, int temperature, int pressure) {
        this((Gas)gas.m_203334_(), amount, temperature, pressure);
    }

    public Gas getGas() {
        return this.isEmpty() ? (Gas)VoltaicGases.EMPTY.get() : this.gas;
    }

    public Holder<Gas> getGasHolder() {
        return this.getGas().getBuiltInRegistry();
    }

    public int getAmount() {
        return this.isEmpty() ? 0 : this.amount;
    }

    public int getTemperature() {
        return this.isEmpty() ? 293 : this.temperature;
    }

    public int getPressure() {
        return this.isEmpty() ? 1 : this.pressure;
    }

    public GasStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new GasStack(this.gas, this.amount, this.temperature, this.pressure);
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void shrink(int amount) {
        this.amount -= Math.min(Math.abs(amount), this.amount);
    }

    public void grow(int amount) {
        this.amount += Math.abs(amount);
    }

    public void heat(int deltaTemp) {
        this.amount = this.getVolumeChangeFromHeating(deltaTemp);
        this.temperature += deltaTemp;
    }

    public void bringPressureTo(int atm) {
        this.amount = this.getVolumeChangeFromPressurizing(atm);
        this.pressure = atm;
    }

    public int getVolumeChangeFromHeating(int deltaTemp) {
        if (this.isAbsoluteZero() && deltaTemp < 0 || this.temperature + deltaTemp < 1) {
            throw new UnsupportedOperationException("The temperature cannot drop below absolute zero");
        }
        double change = ((double)deltaTemp + (double)this.temperature) / (double)this.temperature;
        return (int)Math.ceil((double)this.amount * change);
    }

    public int getVolumeChangeFromPressurizing(int atm) {
        if (this.isVacuum() || atm < 1) {
            throw new UnsupportedOperationException("You cannot have a pressure less than 1");
        }
        double change = (double)atm / (double)this.pressure;
        return (int)Math.ceil((double)this.amount / change);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.gas == VoltaicGases.EMPTY.get() || this.amount <= 0;
    }

    public boolean is(TagKey<Gas> tag) {
        return this.getGas().getBuiltInRegistry().m_203656_(tag);
    }

    public boolean is(Gas fluid) {
        return this.getGas() == fluid;
    }

    public boolean is(Predicate<Holder<Gas>> holderPredicate) {
        return holderPredicate.test(this.getGasHolder());
    }

    public boolean is(Holder<Gas> holder) {
        return this.is((Gas)holder.m_203334_());
    }

    public boolean is(HolderSet<Gas> holderSet) {
        return holderSet.m_203333_(this.getGasHolder());
    }

    public boolean isSameGas(GasStack other) {
        return this.gas.equals(other.gas);
    }

    public boolean isSameAmount(GasStack other) {
        return this.amount == other.amount;
    }

    public boolean isSameTemperature(GasStack other) {
        return this.temperature == other.temperature;
    }

    public boolean isSamePressure(GasStack other) {
        return this.pressure == other.pressure;
    }

    public boolean isAbsoluteZero() {
        return this.temperature == 1;
    }

    public boolean isVacuum() {
        return this.pressure < 1;
    }

    public boolean isCondensed() {
        return this.temperature <= this.gas.getCondensationTemp();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GasStack) {
            GasStack other = (GasStack)obj;
            boolean empty = this.isEmpty();
            boolean otherEmpty = other.isEmpty();
            if (empty && !otherEmpty || !empty && otherEmpty) {
                return false;
            }
            return empty && otherEmpty || other.getGas().equals(this.getGas()) && other.amount == this.amount && other.temperature == this.temperature && other.pressure == this.pressure;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.gas, this.amount, this.temperature, this.pressure);
    }

    public String toString() {
        return this.gas.toString() + ", amount: " + this.amount + " mB, temp: " + this.temperature + " K, pressure: " + this.pressure + " ATM";
    }

    public CompoundTag writeToNbt() {
        CompoundTag tag = new CompoundTag();
        if (this.isEmpty()) {
            tag.m_128405_("amount", 0);
        } else {
            tag.m_128359_("name", VoltaicRegistries.gasRegistry().getKey((Object)this.getGas()).toString());
            tag.m_128405_("amount", this.amount);
            tag.m_128405_("temperature", this.temperature);
            tag.m_128405_("pressure", this.pressure);
        }
        return tag;
    }

    public static GasStack readFromNbt(CompoundTag tag) {
        int amount = tag.m_128451_("amount");
        if (amount <= 0) {
            return EMPTY;
        }
        Gas gas = (Gas)VoltaicRegistries.gasRegistry().getValue(new ResourceLocation(tag.m_128461_("name")));
        int temperature = tag.m_128451_("temperature");
        int pressure = tag.m_128451_("pressure");
        return new GasStack(gas, amount, temperature, pressure);
    }

    public static GasStack equalizePresrsureAndTemperature(GasStack stack1, GasStack stack2) {
        int newPressure = stack1.getAmount() > stack2.getAmount() ? stack1.getPressure() : stack2.getPressure();
        int medianTemperature = (int)((double)(stack1.temperature + stack2.temperature) / 2.0);
        int deltaT1 = medianTemperature - stack1.temperature;
        int deltaT2 = medianTemperature - stack2.temperature;
        stack1.bringPressureTo(newPressure);
        stack2.bringPressureTo(newPressure);
        stack1.heat(deltaT1);
        stack2.heat(deltaT2);
        return new GasStack(stack1.getGas(), stack1.getAmount() + stack2.getAmount(), medianTemperature, stack1.getPressure());
    }

    public static int getMaximumAcceptance(GasStack stack1, GasStack stack2, int maximumAccept) {
        int rulingPressure = stack1.getAmount() > stack2.getAmount() ? stack1.getPressure() : stack2.getPressure();
        double medianTemperature = (double)(stack1.temperature + stack2.temperature) / 2.0;
        double deltaT1 = medianTemperature - (double)stack1.temperature;
        double deltaT2 = medianTemperature - (double)stack2.temperature;
        double deltaP1Factor = (double)rulingPressure / (double)stack1.getPressure();
        double deltaT1Factor = (deltaT1 + (double)stack1.getTemperature()) / (double)stack1.getTemperature();
        double newStack1Volume = (double)stack1.getAmount() * deltaT1Factor / deltaP1Factor;
        double remaining = (double)maximumAccept - newStack1Volume;
        if (remaining <= 0.0) {
            return 0;
        }
        double deltaP2Factor = (double)rulingPressure / (double)stack2.getPressure();
        double deltaT2Factor = (deltaT2 + (double)stack2.getTemperature()) / (double)stack2.getTemperature();
        double newStack2Volume = (double)stack2.getAmount() * deltaT2Factor / deltaP2Factor;
        if (newStack2Volume <= remaining) {
            return stack2.getAmount();
        }
        return (int)Math.ceil(remaining / deltaT2Factor * deltaP2Factor);
    }
}

