/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.multiblock.subnodebased.parent;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.multiblock.subnodebased.Subnode;

public interface IMultiblockParentBlock {
    public boolean hasMultiBlock();

    default public boolean isValidMultiblockPlacement(BlockState state, LevelReader worldIn, BlockPos pos, Subnode[] nodes) {
        for (Subnode sub : nodes) {
            BlockPos check = pos.m_121955_((Vec3i)sub.pos());
            if (worldIn.m_8055_(check).m_247087_()) continue;
            return false;
        }
        return true;
    }

    public static class SubnodeWrapper {
        public static final SubnodeWrapper EMPTY = new SubnodeWrapper(new Subnode[0]);
        private HashMap<Direction, Subnode[]> subnodeMap = new HashMap();
        private Subnode[] omni = null;

        private SubnodeWrapper(Subnode[] omni) {
            this.omni = omni;
        }

        private SubnodeWrapper(Subnode[] north, Subnode[] east, Subnode[] south, Subnode[] west) {
            this.subnodeMap.put(Direction.NORTH, north);
            this.subnodeMap.put(Direction.EAST, east);
            this.subnodeMap.put(Direction.SOUTH, south);
            this.subnodeMap.put(Direction.WEST, west);
        }

        public Subnode[] getSubnodes(@Nullable Direction dir) {
            if (this.omni != null) {
                return this.omni;
            }
            return this.subnodeMap.getOrDefault(dir, new Subnode[0]);
        }

        public static SubnodeWrapper createOmni(Subnode[] omni) {
            return new SubnodeWrapper(omni);
        }

        public static SubnodeWrapper createDirectional(Subnode[] north, Subnode[] east, Subnode[] south, Subnode[] west) {
            return new SubnodeWrapper(north, east, south, west);
        }
    }
}

