/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.multiblock.subnodebased.parent;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import voltaic.api.multiblock.subnodebased.Subnode;
import voltaic.api.multiblock.subnodebased.TileMultiSubnode;
import voltaic.api.multiblock.subnodebased.child.IMultiblockChildBlock;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentBlock;
import voltaic.common.block.BlockMultiSubnode;
import voltaic.registers.VoltaicBlocks;

public interface IMultiblockParentTile {
    default public void onNodeReplaced(Level world, BlockPos pos, boolean update) {
        Subnode[] subnodes = this.getSubNodes().getSubnodes(this.getFacingDirection());
        for (int i = 0; i < subnodes.length; ++i) {
            TileMultiSubnode subnodeTile;
            Subnode subnode = subnodes[i];
            BlockPos subnodePos = subnode.pos();
            BlockPos offset = pos.m_121955_((Vec3i)subnodePos);
            BlockState subnodeState = world.m_8055_(offset);
            Block subnodeBlock = subnodeState.m_60734_();
            if (update) {
                if (subnodeState.m_247087_()) {
                    world.m_46597_(offset, ((BlockMultiSubnode)VoltaicBlocks.BLOCK_MULTISUBNODE.get()).m_49966_());
                }
                if ((subnodeTile = (TileMultiSubnode)world.m_7702_(offset)) == null) continue;
                subnodeTile.setData(pos, i);
                continue;
            }
            if (!(subnodeBlock instanceof IMultiblockChildBlock) || (subnodeTile = (TileMultiSubnode)world.m_7702_(offset)) == null || !((BlockPos)subnodeTile.parentPos.getValue()).equals((Object)pos)) continue;
            world.m_46597_(offset, Blocks.f_50016_.m_49966_());
        }
    }

    default public void onNodePlaced(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.onNodeReplaced(world, pos, true);
    }

    public IMultiblockParentBlock.SubnodeWrapper getSubNodes();

    default public void onSubnodeNeighborChange(TileMultiSubnode subnode, BlockPos subnodeChangingNeighbor, boolean blockStateTrigger) {
    }

    default public InteractionResult onSubnodeUse(Player player, InteractionHand hand, BlockHitResult hit, TileMultiSubnode subnode) {
        return InteractionResult.FAIL;
    }

    default public void onSubnodePlace(TileMultiSubnode subnode, BlockState oldSubnodeState, boolean isSubnodeMoving) {
    }

    default public int getSubdnodeComparatorSignal(TileMultiSubnode subnode) {
        return 0;
    }

    public void onSubnodeDestroyed(TileMultiSubnode var1);

    public Direction getFacingDirection();

    default public int getDirectSignal(TileMultiSubnode subnode, Direction dir) {
        return 0;
    }

    default public int getSignal(TileMultiSubnode subnode, Direction dir) {
        return 0;
    }

    @NotNull
    default public <T> LazyOptional<T> getSubnodeCapability(@NotNull Capability<T> cap, Direction side) {
        return LazyOptional.empty();
    }
}

