/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.network.cable.type;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import voltaic.prefab.utilities.math.Color;

public interface IWire {
    public double getResistance();

    public long getAmpacity();

    public IWireClass getWireClass();

    public IInsulationMaterial getInsulation();

    public IWireMaterial getWireMaterial();

    public IWireColor getWireColor();

    public IWireColor getDefaultColor();

    @Nullable
    public TagKey<Item> getItemTag();

    public boolean isDefaultColor();

    public static interface IWireColor {
        @Nonnull
        public Color getColor();

        @Nonnull
        public TagKey<Item> getDyeTag();
    }

    public static interface IWireMaterial {
        @Nonnegative
        public double resistance();

        @Nonnegative
        public long ampacity();

        @Nonnegative
        public double materialResistivity();
    }

    public static interface IWireClass {
        public boolean conductsRedstone();
    }

    public static interface IInsulationMaterial {
        public boolean insulated();

        public boolean fireproof();

        public int shockVoltage();

        public double wireRadius();

        public BlockBehaviour.Properties getProperties();

        public SoundType getSoundType();
    }
}

