/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.tile;

import net.minecraft.world.level.block.RenderShape;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentBlock;
import voltaic.common.block.voxelshapes.VoxelShapeProvider;

public class MachineProperties {
    public boolean isMultiblock = false;
    public int litBrightness = 0;
    public boolean usesLit = false;
    public RenderShape renderShape = RenderShape.MODEL;
    public boolean propegatesLightDown = false;
    public boolean isPlayerStorable = false;
    public IMultiblockParentBlock.SubnodeWrapper wrapper = IMultiblockParentBlock.SubnodeWrapper.EMPTY;
    public VoxelShapeProvider provider = VoxelShapeProvider.DEFAULT;
    public static final MachineProperties DEFAULT = new MachineProperties();

    private MachineProperties() {
    }

    public MachineProperties setLitBrightness(int brightness) {
        this.litBrightness = brightness;
        return this.setUsesLit();
    }

    public MachineProperties setPropegateLightDown() {
        this.propegatesLightDown = true;
        return this;
    }

    public MachineProperties setRenderShape(RenderShape shape) {
        this.renderShape = shape;
        return this;
    }

    public MachineProperties setPlayerStorable() {
        this.isPlayerStorable = true;
        return this;
    }

    public MachineProperties setSubnodes(IMultiblockParentBlock.SubnodeWrapper wrapper) {
        this.isMultiblock = true;
        this.wrapper = wrapper;
        return this;
    }

    public MachineProperties setShapeProvider(VoxelShapeProvider provider) {
        this.provider = provider;
        return this;
    }

    public MachineProperties setUsesLit() {
        this.usesLit = true;
        return this;
    }

    public static MachineProperties builder() {
        return new MachineProperties();
    }
}

