/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.guidebook;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import voltaic.Voltaic;
import voltaic.client.guidebook.utils.components.Chapter;
import voltaic.client.guidebook.utils.components.Module;
import voltaic.client.guidebook.utils.components.Page;
import voltaic.client.guidebook.utils.pagedata.AbstractWrapperObject;
import voltaic.client.guidebook.utils.pagedata.OnClick;
import voltaic.client.guidebook.utils.pagedata.OnKeyPress;
import voltaic.client.guidebook.utils.pagedata.OnTooltip;
import voltaic.client.guidebook.utils.pagedata.graphics.AbstractGraphicWrapper;
import voltaic.client.guidebook.utils.pagedata.graphics.ImageWrapperObject;
import voltaic.client.guidebook.utils.pagedata.text.TextWrapperObject;
import voltaic.common.inventory.container.ContainerGuidebook;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.button.type.ButtonGuidebook;
import voltaic.prefab.screen.component.button.type.ButtonModuleSelector;
import voltaic.prefab.screen.component.button.type.ButtonSearchedText;
import voltaic.prefab.screen.component.button.type.ButtonSpecificPage;
import voltaic.prefab.screen.component.editbox.type.EditBoxSpecificPage;
import voltaic.prefab.screen.component.types.ScreenComponentGuidebookArrow;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenGuidebook
extends GenericScreen<ContainerGuidebook> {
    public static final List<Module> GUIDEBOOK_MODULES = new ArrayList<Module>();
    public static final int GUIDEBOOK_STARTING_PAGE = 0;
    public static final int MODULES_PER_PAGE = 4;
    public static final int CHAPTERS_PER_PAGE = 4;
    public static final int LEFT_TEXTURE_WIDTH = 171;
    public static final int LEFT_TEXTURE_HEIGHT = 224;
    public static final int RIGHT_TEXTURE_WIDTH = 171;
    public static final int RIGHT_TEXTURE_HEIGHT = 224;
    public static final int OLD_TEXTURE_WIDTH = 171;
    public static final int LEFT_X_SHIFT = -83;
    public static final int RIGHT_X_SHIFT = 88;
    public static final int TEXT_START_Y = 40;
    public static final int TEXT_END_Y = 180;
    public static final int LINE_HEIGHT = 10;
    public static final int TEXT_START_X = 12;
    public static final int TEXT_END_X = 166;
    public static final int TEXT_WIDTH = 154;
    public static final int LINES_PER_PAGE = 15;
    public static final int Y_PIXELS_PER_PAGE = 150;
    private static final int MODULE_SEPERATION = 40;
    private static final int CHAPTER_SEPERATION = 35;
    public static int currPageNumber = 0;
    private int nextPageNumber = 0;
    private static final List<Page> PAGES = new ArrayList<Page>();
    public static final HashSet<Object> JEI_INGREDIENTS = new HashSet();
    private static final ResourceLocation PAGE_TEXTURE_LEFT = Voltaic.rl("textures/screen/guidebook/resources/guidebookpageleft.png");
    private static final ResourceLocation PAGE_TEXTURE_RIGHT = Voltaic.rl("textures/screen/guidebook/resources/guidebookpageright.png");
    private static ButtonGuidebook forward;
    private static ButtonGuidebook back;
    private static ButtonGuidebook home;
    private static ButtonGuidebook chapters;
    private static ButtonGuidebook search;
    private static EditBoxSpecificPage searchBox;
    private static ScreenComponentGuidebookArrow down;
    private static ScreenComponentGuidebookArrow up;
    private static ButtonModuleSelector caseSensitive;
    private static final List<ButtonModuleSelector> MODULE_PARAMETERS;
    private static final List<SearchHit> SEARCHES;
    private static final List<ButtonSearchedText> SEARCH_BUTTONS;
    private int lineY = 40;
    private int lineX = 12;
    private int graphicPixelHeightLeft = 150;
    private int graphicPixelWidthLeft = 154;
    private int previousHeight = 0;
    private Color color = Color.BLACK;
    private boolean centered = false;
    private MutableComponent mergedText = Component.m_237119_();
    private OnTooltip textOnTooltip = null;
    private OnClick textOnClick = null;
    private OnKeyPress textOnKeyPress = null;
    private boolean previousWasText = false;
    private static boolean hasInitHappened;
    private static final List<ScreenComponentButton<?>> BUTTONS;
    private final int minScroll = 0;
    private int maxScroll = 0;
    private int scrollIndex = 0;
    private static final int SEARCH_BUTTON_COUNT = 5;

    public ScreenGuidebook(ContainerGuidebook screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.f_97727_ += 58;
        this.f_97731_ += 58;
    }

    @Override
    protected void m_7856_() {
        if (!hasInitHappened) {
            BUTTONS.clear();
            MODULE_PARAMETERS.clear();
            SEARCH_BUTTONS.clear();
            SEARCHES.clear();
            PAGES.clear();
            this.initPageButtons();
            ScreenGuidebook.sortModules();
            PAGES.add(this.getCoverPage());
            ++this.nextPageNumber;
            this.genModulePages();
            this.genPages();
            this.genSearchPages();
            hasInitHappened = true;
        }
        this.addButtons();
        super.m_7856_();
    }

    private void addButtons() {
        this.addComponent(forward);
        this.addComponent(back);
        this.addComponent(home);
        this.addComponent(chapters);
        this.addComponent(search);
        for (ScreenComponentButton<?> screenComponentButton : BUTTONS) {
            this.addComponent(screenComponentButton);
        }
        for (ButtonModuleSelector buttonModuleSelector : MODULE_PARAMETERS) {
            this.addComponent(buttonModuleSelector);
        }
        for (ButtonSearchedText buttonSearchedText : SEARCH_BUTTONS) {
            this.addComponent(buttonSearchedText);
        }
        this.addComponent(caseSensitive);
        this.addEditBox(searchBox);
        this.addComponent(up);
        this.addComponent(down);
    }

    private static void sortModules() {
        if (GUIDEBOOK_MODULES.isEmpty()) {
            return;
        }
        ArrayList<Module> temp = new ArrayList<Module>(GUIDEBOOK_MODULES);
        GUIDEBOOK_MODULES.clear();
        GUIDEBOOK_MODULES.add((Module)temp.get(0));
        temp.remove(0);
        ArrayList<MutableComponent> cats = new ArrayList<MutableComponent>();
        for (Module mod : temp) {
            cats.add(mod.getTitle());
        }
        cats.sort((component1, component2) -> component1.toString().compareToIgnoreCase(component2.toString()));
        block1: for (MutableComponent cat : cats) {
            for (int i = 0; i < temp.size(); ++i) {
                Module mod = (Module)temp.get(i);
                if (!mod.isCat(cat)) continue;
                GUIDEBOOK_MODULES.add(mod);
                temp.remove(i);
                continue block1;
            }
        }
        for (Module module : GUIDEBOOK_MODULES) {
            module.chapters.clear();
            module.addChapters();
        }
    }

    private void initPageButtons() {
        forward = (ButtonGuidebook)new ButtonGuidebook(ButtonGuidebook.GuidebookButtonType.RIGHT, 97, 200).setOnPress(button -> this.pageForward());
        back = (ButtonGuidebook)new ButtonGuidebook(ButtonGuidebook.GuidebookButtonType.LEFT, 54, 200).setOnPress(button -> this.pageBackward());
        home = (ButtonGuidebook)new ButtonGuidebook(ButtonGuidebook.GuidebookButtonType.HOME, -71, 202).setOnPress(button -> this.goToModulePage());
        chapters = (ButtonGuidebook)new ButtonGuidebook(ButtonGuidebook.GuidebookButtonType.CHAPTERS, -50, 202).setOnPress(button -> this.goToChapterPage());
        search = (ButtonGuidebook)new ButtonGuidebook(ButtonGuidebook.GuidebookButtonType.SEARCH, 235, 202).setOnPress(button -> this.goToSearchPage());
    }

    private void genModulePages() {
        int numPages = (int)Math.ceil((double)GUIDEBOOK_MODULES.size() / 4.0);
        int index = 0;
        for (int i = 0; i < numPages; ++i) {
            Page.ModulePage page = new Page.ModulePage(this.nextPageNumber);
            for (int j = 0; j < 4 && index < GUIDEBOOK_MODULES.size(); ++index, ++j) {
                Module module = GUIDEBOOK_MODULES.get(index);
                Page.GraphicWrapper wrapper = new Page.GraphicWrapper(12, j * 40 + 40 - 2, module.getLogo(), module.onTooltip(), module.onClick(), module.onKeyPress());
                page.graphics.add(wrapper);
                if (module.onTooltip() != null) {
                    page.tooltipGraphics.add(wrapper);
                }
                if (module.onClick() != null) {
                    page.clickGraphics.add(wrapper);
                }
                if (module.onKeyPress() != null) {
                    page.keyPressGraphics.add(wrapper);
                }
                int xShift = this.nextPageNumber % 2 == 0 ? -83 : 80;
                BUTTONS.add((ScreenComponentButton<?>)((ButtonSpecificPage)new ButtonSpecificPage(45 + xShift, 43 + j * 40, 120, 20, this.nextPageNumber).setLabel((Component)module.getTitle())).setOnPress(button -> ScreenGuidebook.setPageNumber(module.getPage())));
            }
            PAGES.add(page);
            ++this.nextPageNumber;
        }
    }

    private void genPages() {
        for (Module module : GUIDEBOOK_MODULES) {
            module.setStartPage(this.nextPageNumber);
            int numPages = (int)Math.ceil((double)module.chapters.size() / 4.0);
            int index = 0;
            for (int i = 0; i < numPages; ++i) {
                Page.ChapterPage chapterPage = new Page.ChapterPage(this.nextPageNumber, module);
                for (int j = 0; j < 4 && index < module.chapters.size(); ++index, ++j) {
                    Chapter chapter = module.chapters.get(index);
                    Page.GraphicWrapper wrapper = new Page.GraphicWrapper(12, j * 35 + 40 + 10, chapter.getLogo(), chapter.onTooltip(), chapter.onClick(), chapter.onKeyPress());
                    chapterPage.graphics.add(wrapper);
                    if (chapter.onTooltip() != null) {
                        chapterPage.tooltipGraphics.add(wrapper);
                    }
                    if (chapter.onClick() != null) {
                        chapterPage.clickGraphics.add(wrapper);
                    }
                    if (chapter.onKeyPress() != null) {
                        chapterPage.keyPressGraphics.add(wrapper);
                    }
                    int xShift = this.nextPageNumber % 2 == 0 ? -83 : 80;
                    BUTTONS.add((ScreenComponentButton<?>)((ButtonSpecificPage)new ButtonSpecificPage(45 + xShift, 56 + j * 35, 120, 20, this.nextPageNumber).setLabel((Component)chapter.getTitle())).setOnPress(button -> ScreenGuidebook.setPageNumber(chapter.getStartPage())));
                }
                PAGES.add(chapterPage);
                ++this.nextPageNumber;
            }
            for (Chapter chapter : module.chapters) {
                chapter.setStartPage(this.nextPageNumber);
                Page currentPage = new Page(this.nextPageNumber);
                currentPage.associatedChapter = chapter;
                ++this.nextPageNumber;
                int counter = 0;
                for (AbstractWrapperObject<?> data : chapter.pageData) {
                    if (data instanceof TextWrapperObject) {
                        TextWrapperObject textWrapper = (TextWrapperObject)data;
                        this.previousWasText = true;
                        this.lineX = 12;
                        this.graphicPixelWidthLeft = 154;
                        this.previousHeight = 0;
                        if (textWrapper == TextWrapperObject.BLANK_LINE) {
                            currentPage = this.writeCurrentTextToPage(currentPage, chapter);
                            this.graphicPixelHeightLeft -= 10;
                            if (this.graphicPixelHeightLeft <= 0) {
                                currentPage = this.resetToNewPage(currentPage, chapter);
                            } else {
                                this.lineY += 10;
                            }
                        } else {
                            if (textWrapper.newPage || textWrapper.isSeparateStart) {
                                currentPage = this.writeCurrentTextToPage(currentPage, chapter);
                            }
                            this.centered = textWrapper.center;
                            this.color = textWrapper.color;
                            this.textOnTooltip = textWrapper.onTooltip;
                            this.textOnClick = textWrapper.onClick;
                            this.textOnKeyPress = textWrapper.onKeyPress;
                            MutableComponent indentions = Component.m_237119_();
                            for (int i = 0; i < textWrapper.numberOfIndentions; ++i) {
                                indentions = indentions.m_130946_("    ");
                            }
                            this.mergedText = this.mergedText.m_7220_((Component)indentions.m_7220_(textWrapper.text));
                            if (textWrapper.newPage) {
                                currentPage = this.resetToNewPage(currentPage, chapter);
                            }
                        }
                    } else if (data instanceof AbstractGraphicWrapper) {
                        int trueHeight;
                        AbstractGraphicWrapper graphicWrapper = (AbstractGraphicWrapper)data;
                        if (this.previousWasText) {
                            currentPage = this.writeCurrentTextToPage(currentPage, chapter);
                            this.centered = false;
                            this.previousWasText = false;
                        }
                        if (graphicWrapper.newPage) {
                            currentPage = this.resetToNewPage(currentPage, chapter);
                            this.previousHeight = 0;
                        }
                        if ((trueHeight = graphicWrapper.trueHeight - graphicWrapper.descriptorTopOffset + graphicWrapper.descriptorBottomOffset) > 150) {
                            throw new UnsupportedOperationException("The image cannot be more than 150 pixels tall!");
                        }
                        if (graphicWrapper.allowNextToOthers && graphicWrapper.width <= this.graphicPixelWidthLeft) {
                            this.graphicPixelWidthLeft -= graphicWrapper.width;
                            wrapper = new Page.GraphicWrapper(this.lineX, this.lineY, graphicWrapper, graphicWrapper.onTooltip, graphicWrapper.onClick, graphicWrapper.onKeyPress);
                            currentPage.graphics.add(wrapper);
                            if (graphicWrapper.onTooltip != null) {
                                currentPage.tooltipGraphics.add(wrapper);
                            }
                            if (graphicWrapper.onClick != null) {
                                currentPage.clickGraphics.add(wrapper);
                            }
                            if (graphicWrapper.onKeyPress != null) {
                                currentPage.keyPressGraphics.add(wrapper);
                            }
                            this.lineX += graphicWrapper.width;
                            if (trueHeight > this.previousHeight) {
                                this.lineY += this.previousHeight;
                                this.previousHeight = trueHeight;
                                this.lineY -= trueHeight;
                            }
                        } else {
                            this.lineX = 12;
                            this.graphicPixelWidthLeft = 154;
                            this.previousHeight = 0;
                            if (trueHeight > this.graphicPixelHeightLeft) {
                                currentPage = this.resetToNewPage(currentPage, chapter);
                                this.previousHeight = trueHeight;
                            }
                            wrapper = new Page.GraphicWrapper(this.lineX, this.lineY, graphicWrapper, graphicWrapper.onTooltip, graphicWrapper.onClick, graphicWrapper.onKeyPress);
                            currentPage.graphics.add(wrapper);
                            if (graphicWrapper.onTooltip != null) {
                                currentPage.tooltipGraphics.add(wrapper);
                            }
                            if (graphicWrapper.onClick != null) {
                                currentPage.clickGraphics.add(wrapper);
                            }
                            if (graphicWrapper.onKeyPress != null) {
                                currentPage.keyPressGraphics.add(wrapper);
                            }
                            this.lineY += trueHeight;
                            this.graphicPixelHeightLeft -= trueHeight;
                        }
                        if (this.graphicPixelHeightLeft == 0 && counter < module.chapters.size() - 1) {
                            currentPage = this.resetToNewPage(currentPage, chapter);
                            this.previousHeight = 0;
                        }
                    }
                    ++counter;
                }
                currentPage = this.writeCurrentTextToPage(currentPage, chapter);
                PAGES.add(currentPage);
                this.graphicPixelHeightLeft = 150;
                this.lineY = 40;
                this.lineX = 12;
                this.graphicPixelWidthLeft = 154;
            }
        }
        if (PAGES.size() % 2 == 1) {
            PAGES.add(new Page.CoverPage(this.nextPageNumber));
            ++this.nextPageNumber;
        }
    }

    private Page writeCurrentTextToPage(Page currentPage, Chapter chapter) {
        if (this.mergedText.equals((Object)Component.m_237119_())) {
            return currentPage;
        }
        int remainder = this.lineY % 10;
        if (remainder > 0) {
            int whole = this.lineY - remainder;
            this.lineY = whole + 10;
            this.graphicPixelHeightLeft = 190 - this.lineY;
        }
        ArrayList text = new ArrayList(this.f_96547_.m_92865_().m_92414_((FormattedText)this.mergedText, 154, Style.f_131099_));
        this.mergedText = Component.m_237119_();
        while (text.size() > 0) {
            if (this.graphicPixelHeightLeft <= 0) {
                currentPage = this.resetToNewPage(currentPage, chapter);
            }
            Page.TextWrapper wrapper = new Page.TextWrapper(this.lineX, this.lineY, (FormattedText)text.get(0), this.color, this.centered, this.textOnTooltip, this.textOnClick, this.textOnKeyPress);
            currentPage.text.add(wrapper);
            if (this.textOnTooltip != null) {
                currentPage.tooltipText.add(wrapper);
            }
            if (this.textOnClick != null) {
                currentPage.clickText.add(wrapper);
            }
            if (this.textOnKeyPress != null) {
                currentPage.keyPressText.add(wrapper);
            }
            text.remove(0);
            this.lineY += 10;
            this.graphicPixelHeightLeft -= 10;
        }
        this.textOnTooltip = null;
        this.textOnClick = null;
        this.textOnKeyPress = null;
        return currentPage;
    }

    private Page resetToNewPage(Page page, Chapter chapter) {
        PAGES.add(page);
        page = new Page(this.nextPageNumber);
        page.associatedChapter = chapter;
        ++this.nextPageNumber;
        this.graphicPixelHeightLeft = 150;
        this.lineY = 40;
        this.lineX = 12;
        this.graphicPixelWidthLeft = 154;
        return page;
    }

    private void genSearchPages() {
        PAGES.add(this.getSearchPageLeft());
        ++this.nextPageNumber;
        PAGES.add(this.getSeatchPageRight());
        ++this.nextPageNumber;
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTick, int x, int y) {
        int guiWidth = (this.f_96543_ - this.f_97726_) / 2;
        int guiHeight = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(PAGE_TEXTURE_LEFT, guiWidth + -83, guiHeight, 0, 0, 171, 224);
        graphics.m_280218_(PAGE_TEXTURE_RIGHT, guiWidth + 88, guiHeight, 0, 0, 171, 224);
        ScreenGuidebook.updatePageArrowVis();
        ScreenGuidebook.renderPageBackground(graphics, -83, guiWidth, guiHeight, this.getCurrentPage());
        ScreenGuidebook.renderPageBackground(graphics, 80, guiWidth, guiHeight, this.getNextPage());
    }

    private static void renderPageBackground(GuiGraphics graphics, int xShift, int guiWidth, int guiHeight, Page page) {
        for (Page.GraphicWrapper graphic : page.graphics) {
            graphic.graphic().render(graphics, graphic.x(), graphic.y(), xShift, guiWidth, guiHeight, page);
        }
    }

    @Override
    protected void m_280003_(GuiGraphics graphics, int x, int y) {
        int refX = this.getXRef();
        int refY = this.getYRef();
        this.renderPageLabels(graphics, -83, refX, refY, this.getCurrentPage());
        this.renderPageLabels(graphics, 80, refX, refY, this.getNextPage());
        int guiWidth = (this.f_96543_ - this.f_97726_) / 2;
        int guiHeight = (this.f_96544_ - this.f_97727_) / 2;
        int xAxis = x - guiWidth;
        int yAxis = y - guiHeight;
        this.renderPageTooltips(graphics, -83, x, y, refX, refY, xAxis, yAxis, guiWidth, guiHeight, this.getCurrentPage());
        this.renderPageTooltips(graphics, 80, x, y, refX, refY, xAxis, yAxis, guiWidth, guiHeight, this.getNextPage());
    }

    private void renderPageLabels(GuiGraphics graphics, int xPageShift, int refX, int refY, Page page) {
        for (Page.TextWrapper text : page.text) {
            if (text.centered()) {
                int xShift = (154 - this.f_96547_.m_92852_(text.characters())) / 2;
                graphics.m_280649_(this.getFontRenderer(), Language.m_128107_().m_5536_(text.characters()), text.x() + refX + xShift + xPageShift, refY + text.y(), text.color().color(), false);
                continue;
            }
            graphics.m_280649_(this.getFontRenderer(), Language.m_128107_().m_5536_(text.characters()), text.x() + refX + xPageShift, text.y() + refY, text.color().color(), false);
        }
        for (Page.GraphicWrapper wrapper : page.graphics) {
            AbstractGraphicWrapper<?> graphic = wrapper.graphic();
            for (AbstractGraphicWrapper.GraphicTextDescriptor descriptor : graphic.descriptors) {
                graphics.m_280614_(this.getFontRenderer(), descriptor.text, refX + wrapper.x() + descriptor.xOffsetFromImage + xPageShift, refY + wrapper.y() + descriptor.yOffsetFromImage, descriptor.color, false);
            }
        }
        page.renderAdditionalText(graphics, refX, refY, xPageShift, this.f_96547_, 154, 12);
    }

    private void renderPageTooltips(GuiGraphics graphics, int xPageShift, int mouseX, int mouseY, int refX, int refY, int xAxis, int yAxis, int guiWidth, int guiHeight, Page page) {
        int textWidth = 0;
        int xShift = 0;
        for (Page.TextWrapper text : page.tooltipText) {
            textWidth = this.f_96547_.m_92852_(text.characters());
            xShift = text.centered() ? (154 - textWidth) / 2 : 0;
            if (!this.isPointInRegionText(refX + xShift + xPageShift + text.x(), refY + text.y(), xAxis, yAxis, textWidth, 10)) continue;
            text.onTooltip().onTooltip(graphics, xAxis, yAxis, this);
        }
        xShift = 0;
        for (Page.GraphicWrapper wrapper : page.tooltipGraphics) {
            AbstractGraphicWrapper<?> graphic = wrapper.graphic();
            if (this.isPointInRegionGraphic(mouseX, mouseY, guiWidth + wrapper.x() + graphic.lookupXOffset + xPageShift, guiHeight + wrapper.y() + graphic.lookupYOffset - graphic.descriptorTopOffset, graphic.width, graphic.height)) {
                wrapper.onTooltip().onTooltip(graphics, xAxis, yAxis, this);
            }
            for (AbstractGraphicWrapper.GraphicTextDescriptor descriptor : graphic.descriptors) {
                if (descriptor.onTooltip == null || !this.isPointInRegionText(refX + wrapper.x() + descriptor.xOffsetFromImage + xPageShift, refY + wrapper.y() + descriptor.yOffsetFromImage, xAxis, yAxis, this.f_96547_.m_92852_((FormattedText)descriptor.text), 10)) continue;
                descriptor.onTooltip.onTooltip(graphics, xAxis, yAxis, this);
            }
        }
    }

    public Page getCurrentPage() {
        if (currPageNumber >= PAGES.size()) {
            currPageNumber = PAGES.size() - 2;
        }
        return PAGES.get(Math.max(0, currPageNumber));
    }

    public Page getNextPage() {
        if (currPageNumber >= PAGES.size()) {
            currPageNumber = PAGES.size() - 2;
        }
        return PAGES.get(Math.max(0, currPageNumber + 1));
    }

    protected void pageForward() {
        if (currPageNumber < PAGES.size() - 2) {
            ScreenGuidebook.movePage(2);
        }
        ScreenGuidebook.updatePageArrowVis();
    }

    protected void pageBackward() {
        if (currPageNumber > 1) {
            ScreenGuidebook.movePage(-2);
        }
        ScreenGuidebook.updatePageArrowVis();
    }

    protected void goToChapterPage() {
        Page page = this.getCurrentPage();
        if (page instanceof Page.ModulePage) {
            Page.ModulePage module = (Page.ModulePage)page;
            ScreenGuidebook.setPageNumber(module.getPage());
        } else if (page instanceof Page.ChapterPage) {
            Page.ChapterPage chapter = (Page.ChapterPage)page;
            ScreenGuidebook.setPageNumber(chapter.associatedModule.getPage());
        } else {
            ScreenGuidebook.setPageNumber(page.associatedChapter.module.getPage());
        }
    }

    protected void goToSearchPage() {
        ScreenGuidebook.setPageNumber(PAGES.size() - 2);
    }

    protected void goToModulePage() {
        ScreenGuidebook.setPageNumber(1);
    }

    private static void movePage(int number) {
        currPageNumber += number;
        currPageNumber = Mth.m_14045_((int)currPageNumber, (int)0, (int)(PAGES.size() - 4));
    }

    private static void setPageNumber(int number) {
        if (number % 2 == 1) {
            --number;
        }
        currPageNumber = number;
    }

    private static void updatePageArrowVis() {
        forward.setVisible(currPageNumber < PAGES.size() - 4);
        back.setVisible(currPageNumber > 0 && currPageNumber < PAGES.size() - 2);
        home.setVisible(currPageNumber != 0);
        chapters.setVisible(currPageNumber != 0 && currPageNumber < PAGES.size() - 4);
        search.setVisible(currPageNumber < PAGES.size() - 3);
    }

    public static void addGuidebookModule(Module module) {
        if (module.isFirst()) {
            GUIDEBOOK_MODULES.add(0, module);
        } else {
            GUIDEBOOK_MODULES.add(module);
        }
    }

    private Page.CoverPage getCoverPage() {
        Page.CoverPage page = new Page.CoverPage(this.nextPageNumber);
        List split = this.f_96547_.m_92865_().m_92414_((FormattedText)VoltaicTextUtils.guidebook("title", new Object[0]).m_130940_(ChatFormatting.BOLD), 154, Style.f_131099_);
        int y = 16;
        for (FormattedText text : split) {
            page.text.add(new Page.TextWrapper(12, y, text, TextWrapperObject.DEFAULT_COLOR, true, null, null, null));
            y += 10;
        }
        int xOffset = 40;
        page.graphics.add(new Page.GraphicWrapper(12, y += 5, new ImageWrapperObject(xOffset, 0, 0, 0, 74, 100, 74, 100, Voltaic.rl("textures/screen/guidebook/resources/guidebookcover.png"), new AbstractGraphicWrapper.GraphicTextDescriptor[0]), null, null, null));
        y += 105;
        split = this.f_96547_.m_92865_().m_92414_((FormattedText)VoltaicTextUtils.guidebook("titlequote", new Object[0]), 154, Style.f_131099_);
        for (FormattedText text : split) {
            page.text.add(new Page.TextWrapper(12, y, text, TextWrapperObject.DEFAULT_COLOR, false, null, null, null));
            y += 10;
        }
        return page;
    }

    private Page.CoverPage getSearchPageLeft() {
        Page.CoverPage page = new Page.CoverPage(this.nextPageNumber);
        List split = this.f_96547_.m_92865_().m_92414_((FormattedText)VoltaicTextUtils.guidebook("searchparameters", new Object[0]).m_130940_(ChatFormatting.BOLD), 154, Style.f_131099_);
        int y = 16;
        for (FormattedText text : split) {
            page.text.add(new Page.TextWrapper(12, y, text, TextWrapperObject.DEFAULT_COLOR, true, null, null, null));
            y += 12;
        }
        y += 5;
        for (Module module : GUIDEBOOK_MODULES) {
            page.text.add(new Page.TextWrapper(27, y, (FormattedText)module.getTitle(), TextWrapperObject.DEFAULT_COLOR, false, null, null, null));
            ButtonModuleSelector selector = new ButtonModuleSelector(70, -1 + y, this.nextPageNumber, true);
            MODULE_PARAMETERS.add(selector);
            y += 10;
        }
        page.text.add(new Page.TextWrapper(27, 165, (FormattedText)VoltaicTextUtils.guidebook("casesensitive", new Object[0]), TextWrapperObject.DEFAULT_COLOR, false, null, null, null));
        caseSensitive = new ButtonModuleSelector(70, 165, this.nextPageNumber, false);
        BUTTONS.add((ScreenComponentButton<?>)((ButtonSpecificPage)new ButtonSpecificPage(-71, 180, 75, 20, this.nextPageNumber).setLabel((Component)VoltaicTextUtils.guidebook("selectall", new Object[0]))).setOnPress(button -> {
            for (ButtonModuleSelector selector : MODULE_PARAMETERS) {
                selector.setSelected(true);
            }
        }));
        BUTTONS.add((ScreenComponentButton<?>)((ButtonSpecificPage)new ButtonSpecificPage(8, 180, 75, 20, this.nextPageNumber).setLabel((Component)VoltaicTextUtils.guidebook("selectnone", new Object[0]))).setOnPress(button -> {
            for (ButtonModuleSelector selector : MODULE_PARAMETERS) {
                selector.setSelected(false);
            }
        }));
        return page;
    }

    private Page.CoverPage getSeatchPageRight() {
        Page.CoverPage page = new Page.CoverPage(this.nextPageNumber);
        searchBox = new EditBoxSpecificPage(92, 10, 154, 12, this.nextPageNumber, this.getFontRenderer());
        searchBox.setResponder(this::onTextSearched);
        searchBox.setTextColor(Color.WHITE);
        searchBox.setMaxLength(100);
        for (int i = 0; i < 5; ++i) {
            ButtonSearchedText search = (ButtonSearchedText)new ButtonSearchedText(92, 35 + 35 * i, 154, 20, this.nextPageNumber).setOnPress(button -> ScreenGuidebook.setPageNumber(((ButtonSearchedText)button).specifiedPage));
            SEARCH_BUTTONS.add(search);
            search.setShouldShow(false);
        }
        down = new ScreenComponentGuidebookArrow(ScreenComponentGuidebookArrow.ArrowTextures.ARROW_DOWN, 174, 200, this.nextPageNumber);
        up = new ScreenComponentGuidebookArrow(ScreenComponentGuidebookArrow.ArrowTextures.ARROW_UP, 154, 200, this.nextPageNumber);
        return page;
    }

    private void onTextSearched(String text) {
        SEARCHES.clear();
        if (text.isEmpty() || text.isBlank()) {
            this.maxScroll = 0;
            this.scrollIndex = 0;
            ScreenGuidebook.resetSearchButtons();
            return;
        }
        ArrayList<SearchHit> found = new ArrayList<SearchHit>();
        ArrayList<Module> selectedModules = new ArrayList<Module>();
        for (int i = 0; i < GUIDEBOOK_MODULES.size(); ++i) {
            if (!MODULE_PARAMETERS.get(i).isSelected()) continue;
            selectedModules.add(GUIDEBOOK_MODULES.get(i));
        }
        for (Page page : PAGES) {
            if (page instanceof Page.ChapterPage || page instanceof Page.ModulePage || page instanceof Page.CoverPage) continue;
            for (Module module : selectedModules) {
                if (!page.associatedChapter.module.isCat(module.getTitle())) continue;
                for (Page.TextWrapper wrapper : page.text) {
                    if (caseSensitive.isSelected() && wrapper.characters().getString().contains(text)) {
                        found.add(new SearchHit(wrapper.characters(), page.getPage(), page.associatedChapter));
                        continue;
                    }
                    if (caseSensitive.isSelected() || !wrapper.characters().getString().toLowerCase(Locale.ROOT).contains(text.toLowerCase())) continue;
                    found.add(new SearchHit(wrapper.characters(), page.getPage(), page.associatedChapter));
                }
                for (Page.GraphicWrapper graphic : page.graphics) {
                    for (AbstractGraphicWrapper.GraphicTextDescriptor descriptor : graphic.graphic().descriptors) {
                        if (caseSensitive.isSelected() && descriptor.text.getString().contains(text)) {
                            found.add(new SearchHit((FormattedText)descriptor.text, page.getPage(), page.associatedChapter));
                            continue;
                        }
                        if (caseSensitive.isSelected() || !descriptor.text.getString().toLowerCase(Locale.ROOT).contains(text.toLowerCase())) continue;
                        found.add(new SearchHit((FormattedText)descriptor.text, page.getPage(), page.associatedChapter));
                    }
                }
            }
        }
        SEARCHES.addAll(found);
        this.maxScroll = Math.max(0, SEARCHES.size() - 5);
        if (this.scrollIndex > this.maxScroll) {
            this.scrollIndex = this.maxScroll;
        }
        this.updateSearchButtons();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (SEARCHES.size() == 0) {
            ScreenGuidebook.resetSearchButtons();
            return super.m_6050_(mouseX, mouseY, delta);
        }
        if (currPageNumber >= PAGES.size() - 2) {
            int scrollDelta = delta > 0.0 ? -1 : 1;
            this.scrollIndex = Mth.m_14045_((int)(this.scrollIndex + scrollDelta), (int)0, (int)this.maxScroll);
            this.updateSearchButtons();
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void updateSearchButtons() {
        up.setShouldRender(this.scrollIndex > 0);
        down.setShouldRender(this.scrollIndex < this.maxScroll);
        ScreenGuidebook.resetSearchButtons();
        if (SEARCHES.size() == 0) {
            return;
        }
        if (this.scrollIndex > this.maxScroll) {
            this.scrollIndex = this.maxScroll;
        }
        int listSize = Math.min(5, SEARCHES.size());
        for (int i = 0; i < listSize; ++i) {
            ButtonSearchedText searched = SEARCH_BUTTONS.get(i);
            SearchHit hit = SEARCHES.get(i + this.scrollIndex);
            searched.setShouldShow(true);
            searched.setChapter((Component)hit.chapter.getTitle());
            searched.setLine(hit.text);
            searched.setPage(hit.page);
        }
    }

    private static void resetSearchButtons() {
        for (ButtonSearchedText button : SEARCH_BUTTONS) {
            button.setLine((FormattedText)Component.m_237119_());
            button.setChapter((Component)Component.m_237119_());
            button.setShouldShow(false);
            button.setPage(0);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        double mouseX = this.f_96541_.f_91067_.m_91589_() * (double)this.f_96541_.m_91268_().m_85445_() / (double)this.f_96541_.m_91268_().m_85443_();
        double mouseY = this.f_96541_.f_91067_.m_91594_() * (double)this.f_96541_.m_91268_().m_85446_() / (double)this.f_96541_.m_91268_().m_85444_();
        int refX = this.getXRef();
        int refY = this.getYRef();
        int guiWidth = (this.f_96543_ - this.f_97726_) / 2;
        int guiHeight = (this.f_96544_ - this.f_97727_) / 2;
        int xAxis = (int)(mouseX - (double)guiWidth);
        int yAxis = (int)(mouseY - (double)guiHeight);
        this.handlePageKeyPress(-83, (int)mouseX, (int)mouseY, refX, refY, xAxis, yAxis, guiWidth, guiHeight, keyCode, scanCode, modifiers, this.getCurrentPage());
        this.handlePageKeyPress(80, (int)mouseX, (int)mouseY, refX, refY, xAxis, yAxis, guiWidth, guiHeight, keyCode, scanCode, modifiers, this.getNextPage());
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && searchBox.isVisible() && searchBox.m_93696_()) {
            return false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void handlePageKeyPress(int xPageShift, int mouseX, int mouseY, int refX, int refY, int xAxis, int yAxis, int guiWidth, int guiHeight, int keyCode, int scanCode, int modifiers, Page page) {
        int textWidth = 0;
        int xShift = 0;
        int x = 0;
        int y = 0;
        for (Page.TextWrapper text : page.keyPressText) {
            textWidth = this.f_96547_.m_92852_(text.characters());
            if (text.centered()) {
                xShift = (154 - textWidth) / 2;
            }
            if (!this.isPointInRegionText(x = refX + xShift + xPageShift + text.x(), y = refY + text.y(), xAxis, yAxis, textWidth, 10)) continue;
            text.onKeyPress().onKeyPress(keyCode, scanCode, modifiers, x, y, xAxis, yAxis, this);
        }
        for (Page.GraphicWrapper wrapper : page.keyPressGraphics) {
            AbstractGraphicWrapper<?> graphic = wrapper.graphic();
            x = guiWidth + wrapper.x() + graphic.lookupXOffset + xPageShift;
            if (this.isPointInRegionGraphic(mouseX, mouseY, x, y = guiHeight + wrapper.y() + graphic.lookupYOffset - graphic.descriptorTopOffset, graphic.width, graphic.height)) {
                wrapper.onKeyPress().onKeyPress(keyCode, scanCode, modifiers, x, y, xAxis, yAxis, this);
            }
            for (AbstractGraphicWrapper.GraphicTextDescriptor descriptor : graphic.descriptors) {
                x = refX + wrapper.x() + descriptor.xOffsetFromImage + xPageShift;
                y = refY + wrapper.y() + descriptor.yOffsetFromImage;
                if (descriptor.onKeyPress == null || !this.isPointInRegionText(x, y, xAxis, yAxis, this.f_96547_.m_92852_((FormattedText)descriptor.text), 10)) continue;
                descriptor.onKeyPress.onKeyPress(keyCode, scanCode, modifiers, x, y, xAxis, yAxis, this);
            }
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int refX = this.getXRef();
        int refY = this.getYRef();
        int guiWidth = (this.f_96543_ - this.f_97726_) / 2;
        int guiHeight = (this.f_96544_ - this.f_97727_) / 2;
        int xAxis = (int)(mouseX - (double)guiWidth);
        int yAxis = (int)(mouseY - (double)guiHeight);
        this.handlePageClick(-83, (int)mouseX, (int)mouseY, refX, refY, xAxis, yAxis, guiWidth, guiHeight, this.getCurrentPage());
        this.handlePageClick(80, (int)mouseX, (int)mouseY, refX, refY, xAxis, yAxis, guiWidth, guiHeight, this.getNextPage());
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void handlePageClick(int xPageShift, int mouseX, int mouseY, int refX, int refY, int xAxis, int yAxis, int guiWidth, int guiHeight, Page page) {
        int textWidth = 0;
        int xShift = 0;
        int x = 0;
        int y = 0;
        for (Page.TextWrapper text : page.clickText) {
            textWidth = this.f_96547_.m_92852_(text.characters());
            if (text.centered()) {
                xShift = (154 - textWidth) / 2;
            }
            if (!this.isPointInRegionText(x = refX + xShift + xPageShift + text.x(), y = refY + text.y(), xAxis, yAxis, textWidth, 10)) continue;
            text.onClick().onClick(x, y, xAxis, yAxis, this);
        }
        for (Page.GraphicWrapper wrapper : page.clickGraphics) {
            AbstractGraphicWrapper<?> graphic = wrapper.graphic();
            x = guiWidth + wrapper.x() + graphic.lookupXOffset + xPageShift;
            if (this.isPointInRegionGraphic(mouseX, mouseY, x, y = guiHeight + wrapper.y() + graphic.lookupYOffset - graphic.descriptorTopOffset, graphic.width, graphic.height)) {
                wrapper.onClick().onClick(x, y, xAxis, yAxis, this);
            }
            for (AbstractGraphicWrapper.GraphicTextDescriptor descriptor : graphic.descriptors) {
                x = refX + wrapper.x() + descriptor.xOffsetFromImage + xPageShift;
                y = refY + wrapper.y() + descriptor.yOffsetFromImage;
                if (descriptor.onClick == null || !this.isPointInRegionText(x, y, xAxis, yAxis, this.f_96547_.m_92852_((FormattedText)descriptor.text), 10)) continue;
                descriptor.onClick.onClick(x, y, xAxis, yAxis, this);
            }
        }
    }

    public boolean isPointInRegionText(int x, int y, double xAxis, double yAxis, int width, int height) {
        return xAxis >= (double)x && xAxis <= (double)(x + width - 1) && yAxis >= (double)y && yAxis <= (double)(y + height - 1);
    }

    public boolean isPointInRegionGraphic(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    public static void setInitNotHappened() {
        currPageNumber = 0;
        hasInitHappened = false;
    }

    public int getXRef() {
        return this.f_97728_ - 8;
    }

    public int getYRef() {
        return this.f_97729_ - 6;
    }

    static {
        MODULE_PARAMETERS = new ArrayList<ButtonModuleSelector>();
        SEARCHES = new ArrayList<SearchHit>();
        SEARCH_BUTTONS = new ArrayList<ButtonSearchedText>();
        hasInitHappened = false;
        BUTTONS = new ArrayList();
    }

    private record SearchHit(FormattedText text, int page, Chapter chapter) {
    }
}

